/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.directory.InitialDirContext;

public class MQJMSIVT {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQJMSIVT.java, jms, j600, j600-101-060328 1.33.1.1 05/05/25 15:59:25";
    public static final String CLASSNAME = "MQJMSIVT";
    public static String QMGR = null;
    public static final String QUEUE = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    public static final String qcfLookup = "ivtQCF";
    public static final String qLookup = "ivtQ";
    public static boolean client = false;
    public static String hostname = null;
    public static String port = null;
    public static String channel = null;
    public static String ccsid = null;
    private static PrintWriter pw = null;

    public static void main(String[] stringArray) throws UnsupportedEncodingException {
        int n;
        block119: {
            String string;
            Object object;
            int n2;
            int n3;
            String string2;
            String string3;
            boolean bl;
            Context context;
            MQQueueConnectionFactory mQQueueConnectionFactory;
            QueueConnection queueConnection;
            QueueSession queueSession;
            Queue queue;
            String string4;
            block118: {
                Locale locale = Locale.getDefault();
                n = 0;
                String string5 = locale.getLanguage();
                String string6 = System.getProperty("os.name");
                pw = !(!string6.equals("Windows NT") && !string6.equals("Windows 2000") && !string6.equals("Windows XP") && !string6.equals("OS/2") || !string5.equals("en") && !string5.equals("fr") && !string5.equals("de") && !string5.equals("es") && !string5.equals("it") && !string5.equals("pt")) ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "Cp850")) : new PrintWriter(new OutputStreamWriter(System.out));
                string4 = null;
                queue = null;
                queueSession = null;
                queueConnection = null;
                mQQueueConnectionFactory = null;
                context = null;
                bl = true;
                boolean bl2 = false;
                string3 = "com.sun.jndi.ldap.LdapCtxFactory";
                string2 = null;
                n3 = 0;
                n2 = 0;
                try {
                    Class.forName("javax.jms.Message");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException);
                    System.exit(-1);
                }
                MQConnectionMetaData mQConnectionMetaData = new MQConnectionMetaData();
                String string7 = mQConnectionMetaData.getProviderVersion();
                pw.println();
                pw.println(ConfigEnvironment.getMessage("MQJMS1003"));
                pw.println(ConfigEnvironment.getMessage("MQJMS1002") + " " + string7);
                pw.println(ConfigEnvironment.getMessage("MQJMS5000") + "\n");
                pw.flush();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i].toLowerCase();
                    if (((String)object).equals("-nojndi")) {
                        bl = false;
                        continue;
                    }
                    if (((String)object).equals("-m")) {
                        if (i + 1 < stringArray.length) {
                            QMGR = stringArray[++i];
                            continue;
                        }
                        string = ConfigEnvironment.getMessage("MQJMS5036", "-m");
                        pw.println(string);
                        pw.flush();
                        continue;
                    }
                    if (((String)object).equals("-t")) {
                        bl2 = true;
                        continue;
                    }
                    if (((String)object).equals("-url")) {
                        if (i + 1 < stringArray.length) {
                            string2 = stringArray[++i];
                        } else {
                            pw.println(ConfigEnvironment.getMessage("MQJMS5001"));
                        }
                        pw.flush();
                        continue;
                    }
                    if (((String)object).equals("-icf")) {
                        if (i + 1 < stringArray.length) {
                            string3 = stringArray[++i];
                            continue;
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5002"));
                        continue;
                    }
                    if (((String)object).equals("-client")) {
                        client = true;
                        continue;
                    }
                    if (((String)object).equals("-host")) {
                        if (i + 1 < stringArray.length) {
                            hostname = stringArray[++i];
                            continue;
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5036", "-host"));
                        continue;
                    }
                    if (((String)object).equals("-port")) {
                        if (i + 1 < stringArray.length) {
                            port = stringArray[++i];
                            continue;
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5036", "-port"));
                        continue;
                    }
                    if (((String)object).equals("-channel")) {
                        if (i + 1 < stringArray.length) {
                            channel = stringArray[++i];
                            continue;
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5036", "-channel"));
                        continue;
                    }
                    if (((String)object).equals("-ccsid")) {
                        if (i + 1 < stringArray.length) {
                            ccsid = stringArray[++i];
                            continue;
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5036", "-ccsid"));
                        continue;
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS5003") + ": " + (String)object);
                }
                pw.flush();
                if (bl2) {
                    ConfigEnvironment.start();
                    if (Trace.isOn) {
                        Trace.entry(CLASSNAME, "main");
                        Trace.trace(CLASSNAME, "Trace started from main by -t flag");
                    }
                }
                if (bl) {
                    if (string2 == null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                    if (client || QMGR != null || hostname != null || port != null || channel != null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                } else if (!client) {
                    if (hostname != null || port != null || channel != null) {
                        MQJMSIVT.displayUsage();
                        System.exit(-1);
                    }
                } else if (QMGR == null || hostname == null) {
                    MQJMSIVT.displayUsage();
                    System.exit(-1);
                }
                if (!client && !bl && QMGR == null) {
                    QMGR = "";
                }
                if (client) {
                    try {
                        n3 = port == null ? 1414 : Integer.parseInt(port);
                    }
                    catch (NumberFormatException numberFormatException) {
                        pw.println(ConfigEnvironment.getMessage("MQJMS5064"));
                        pw.flush();
                        System.exit(-1);
                    }
                    if (channel == null) {
                        channel = "SYSTEM.DEF.SVRCONN";
                    }
                    if (ccsid != null && ccsid.length() > 0) {
                        try {
                            n2 = Integer.parseInt(ccsid);
                        }
                        catch (NumberFormatException numberFormatException) {
                            pw.println(ConfigEnvironment.getMessage("MQJMS1046", ccsid));
                            pw.flush();
                            System.exit(-1);
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Using following parameters:");
                    if (bl) {
                        Trace.trace(CLASSNAME, "Using JNDI");
                        Trace.trace(CLASSNAME, "InitialContextFactory: '" + string3 + "'");
                        Trace.trace(CLASSNAME, "ProviderURL: '" + string2 + "'");
                    } else {
                        Trace.trace(CLASSNAME, "Not using JNDI");
                        if (client) {
                            Trace.trace(CLASSNAME, "Using CLIENT connection");
                            Trace.trace(CLASSNAME, "Queue Manager: '" + QMGR + "'");
                            Trace.trace(CLASSNAME, "HostName: '" + hostname + "'");
                            Trace.trace(CLASSNAME, "Port: " + n3);
                            Trace.trace(CLASSNAME, "Channel: '" + channel + "'");
                            Trace.trace(CLASSNAME, "Ccsid: '" + ccsid + "'");
                        } else {
                            Trace.trace(CLASSNAME, "Using BINDINGS connection");
                            Trace.trace(CLASSNAME, "Queue Manager: '" + QMGR + "'");
                        }
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "checking classpath");
                    }
                    try {
                        Class.forName("javax.jms.Message");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "javax.jms.Message missing");
                        }
                        object = ConfigEnvironment.getMessage("MQJMS5037", "javax.jms.jar");
                        System.err.println((String)object);
                        pw.flush();
                        throw classNotFoundException;
                    }
                    try {
                        Class.forName("com.ibm.mq.MQMessage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "com.ibm.mq.MQMessage missing");
                        }
                        object = ConfigEnvironment.getMessage("MQJMS5037", "com.ibm.mq.jar");
                        System.err.println((String)object);
                        pw.flush();
                        throw classNotFoundException;
                    }
                    try {
                        Class.forName("javax.naming.InitialContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "javax.naming.InitialContext missing");
                        }
                        object = ConfigEnvironment.getMessage("MQJMS5037", "jndi.jar");
                        System.err.println((String)object);
                        pw.flush();
                        throw classNotFoundException;
                    }
                    if (!bl) break block118;
                    try {
                        Class.forName(string3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "jndi provider for '" + string3 + "' missing");
                        }
                        object = ConfigEnvironment.getMessage("MQJMS5038", string3);
                        System.err.println((String)object);
                        pw.flush();
                        throw classNotFoundException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "classpath check failed with " + classNotFoundException);
                        Trace.exit(CLASSNAME, "main");
                    }
                    System.err.println(classNotFoundException);
                    pw.flush();
                    System.exit(-1);
                }
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "User has opted for JNDI lookup");
                }
                if (string2 == null) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS5004"));
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "User has not specified a URL for JNDI lookup");
                        Trace.trace(CLASSNAME, "Exiting via System.exit(-1)");
                        Trace.exit(CLASSNAME, "main");
                    }
                    System.exit(-1);
                } else {
                    pw.println(ConfigEnvironment.getMessage("MQJMS5005"));
                    pw.flush();
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("java.naming.factory.initial", string3);
                    hashtable.put("java.naming.provider.url", string2);
                    hashtable.put("java.naming.referral", "throw");
                    try {
                        context = new InitialDirContext(hashtable);
                    }
                    catch (Exception exception) {
                        string = ConfigEnvironment.getMessage("MQJMS5006");
                        pw.println(string);
                        pw.println(exception);
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Initial context creation failed!");
                            Trace.exception(CLASSNAME, "main", (Throwable)exception);
                            Trace.trace(CLASSNAME, "Exiting via System.exit(-1)");
                            Trace.exit(CLASSNAME, "main");
                        }
                        pw.flush();
                        System.exit(-1);
                    }
                }
            } else if (Trace.isOn) {
                Trace.trace(CLASSNAME, "User is bypassing JNDI lookup");
            }
            pw.println();
            string4 = "A simple text message from the MQJMSIVT program";
            if (!bl) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating a QCF ourselves");
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS5007"));
                pw.flush();
                mQQueueConnectionFactory = new MQQueueConnectionFactory();
                try {
                    mQQueueConnectionFactory.setQueueManager(QMGR);
                    if (client) {
                        mQQueueConnectionFactory.setTransportType(1);
                        mQQueueConnectionFactory.setHostName(hostname);
                        mQQueueConnectionFactory.setPort(n3);
                        mQQueueConnectionFactory.setChannel(channel);
                        if (ccsid != null) {
                            mQQueueConnectionFactory.setCCSID(n2);
                        }
                    }
                }
                catch (JMSException jMSException) {
                    n = 2;
                    pw.println(ConfigEnvironment.getMessage("MQJMS5009"));
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Could not set properties in QCF");
                        Trace.exception(CLASSNAME, "main", (Throwable)jMSException);
                        Trace.trace(CLASSNAME, "Exiting via System.exit(-1)");
                        Trace.exit(CLASSNAME, "main");
                    }
                    pw.flush();
                    System.exit(-1);
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "QCF created OK");
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Obtaining a QCF from JNDI (lookup key is ivtQCF)");
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS5008"));
                pw.flush();
                try {
                    mQQueueConnectionFactory = (QueueConnectionFactory)context.lookup(qcfLookup);
                }
                catch (Exception exception) {
                    try {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Normal lookup failed with the following exception: ");
                            Trace.exception(CLASSNAME, "main", (Throwable)exception);
                            Trace.trace(CLASSNAME, "Now trying with cn= prefix");
                        }
                        mQQueueConnectionFactory = (QueueConnectionFactory)context.lookup("cn=ivtQCF");
                    }
                    catch (Exception exception2) {
                        pw.println(ConfigEnvironment.getMessage("MQJMS5009"));
                        pw.flush();
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Extended lookup failed with the following exception: ");
                            Trace.exception(CLASSNAME, "main", (Throwable)exception2);
                            Trace.trace(CLASSNAME, "Exiting via System.exit(-1)");
                            Trace.exit(CLASSNAME, "main");
                        }
                        System.exit(-1);
                    }
                }
            }
            pw.println(ConfigEnvironment.getMessage("MQJMS5010"));
            pw.flush();
            try {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating connection");
                }
                queueConnection = mQQueueConnectionFactory.createQueueConnection();
                queueConnection.start();
                pw.println(ConfigEnvironment.getMessage("MQJMS5011"));
                pw.flush();
                boolean bl3 = false;
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating session");
                }
                queueSession = queueConnection.createQueueSession(bl3, 1);
                if (!bl) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Creating a Q ourselves");
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS5012"));
                    pw.flush();
                    queue = queueSession.createQueue(QUEUE);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Obtaining a Q from JNDI (lookup key is ivtQ)");
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS5013"));
                    pw.flush();
                    try {
                        queue = (Queue)context.lookup(qLookup);
                    }
                    catch (Exception exception) {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "Normal lookup failed with the following exception: ");
                                Trace.exception(CLASSNAME, "main", (Throwable)exception);
                                Trace.trace(CLASSNAME, "Now trying with cn= prefix");
                            }
                            queue = (Queue)context.lookup("cn=ivtQ");
                        }
                        catch (Exception exception3) {
                            pw.println(ConfigEnvironment.getMessage("MQJMS5014"));
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "Extended lookup failed with the following exception: ");
                                Trace.exception(CLASSNAME, "main", (Throwable)exception3);
                                Trace.trace(CLASSNAME, "Exiting via System.exit(-1)");
                                Trace.exit(CLASSNAME, "main");
                            }
                            pw.flush();
                            System.exit(-1);
                        }
                    }
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS5015"));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating a sender");
                }
                object = queueSession.createSender(queue);
                pw.println(ConfigEnvironment.getMessage("MQJMS5016"));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating a receiver");
                }
                string = queueSession.createReceiver(queue);
                pw.println(ConfigEnvironment.getMessage("MQJMS5017"));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating a message");
                }
                TextMessage textMessage = queueSession.createTextMessage();
                textMessage.setText(string4);
                pw.println(ConfigEnvironment.getMessage("MQJMS5018") + " " + QUEUE);
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Sending the message");
                }
                object.send((Message)textMessage);
                pw.println(ConfigEnvironment.getMessage("MQJMS5019"));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Receiving the message");
                }
                Message message = string.receive(1000L);
                pw.flush();
                if (message == null) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS5020"));
                    throw new JMSException(ConfigEnvironment.getMessage("MQJMS5021"));
                }
                pw.println("\n" + ConfigEnvironment.getMessage("MQJMS5022") + ": " + message);
                pw.flush();
                if (message instanceof TextMessage) {
                    String string8;
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Retrived message is a TextMessage; now checking for equality with the sent message");
                    }
                    if ((string8 = ((TextMessage)message).getText()).equals(string4)) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Messages are equal. Great!");
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5023"));
                        pw.flush();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "ERROR! Messages differ!");
                            Trace.trace(CLASSNAME, "Original=" + string4);
                            Trace.trace(CLASSNAME, "Reply=" + string8);
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS5024"));
                        pw.println(ConfigEnvironment.getMessage("MQJMS5025") + " = '" + string4 + "'");
                        pw.println(ConfigEnvironment.getMessage("MQJMS5026") + " = '" + string8 + "'");
                        pw.flush();
                    }
                } else {
                    pw.println(ConfigEnvironment.getMessage("MQJMS5027"));
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "The retrieved message was not a TextMessage");
                    }
                    pw.flush();
                    throw new JMSException(ConfigEnvironment.getMessage("MQJMS5028"));
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Closing down queues, session and connection");
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS5029"));
                string.close();
                pw.println(ConfigEnvironment.getMessage("MQJMS5030"));
                object.close();
                pw.println(ConfigEnvironment.getMessage("MQJMS5031"));
                queueSession.close();
                queueSession = null;
                pw.println(ConfigEnvironment.getMessage("MQJMS5032"));
                queueConnection.close();
                queueConnection = null;
                pw.println(ConfigEnvironment.getMessage("MQJMS5033"));
                pw.flush();
            }
            catch (Exception exception) {
                n = 3;
                pw.println(ConfigEnvironment.getMessage("MQJMS5034") + ": " + exception);
                if (exception instanceof JMSException || exception instanceof IllegalStateException) {
                    n = 2;
                    object = ((JMSException)((Object)exception)).getLinkedException();
                    if (object != null) {
                        pw.println(ConfigEnvironment.getMessage("MQJMS5058") + ": " + object);
                        pw.flush();
                    }
                }
                pw.flush();
                if (!Trace.isOn) break block119;
                Trace.trace(CLASSNAME, "The following exception was caught: ");
                Trace.exception(CLASSNAME, "main", (Throwable)exception);
            }
        }
        pw.println(ConfigEnvironment.getMessage("MQJMS5035"));
        pw.flush();
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "IVT finished");
            Trace.exit(CLASSNAME, "main");
        }
        System.exit(n);
    }

    private static void displayUsage() {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "displayUsage");
        }
        pw.println(ConfigEnvironment.getMessage("MQJMS5065"));
        pw.println("    " + ConfigEnvironment.getMessage("MQJMS5066"));
        pw.println("    " + ConfigEnvironment.getMessage("MQJMS5067"));
        pw.println("    " + ConfigEnvironment.getMessage("MQJMS5068"));
        pw.flush();
    }
}

