/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: ZipObject.java,v 1.1 2008/12/01 14:29:38 tzimber Exp $
 */
package ch.e2e.bridge.tools.zip;

/**
 * Holds the name of the entry and his unpacked content.
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class ZipObject {
	/**
	 * The name of the entry in the packed file.
	 */
	private String name;
	/**
	 * The unpacked content.
	 */
	private byte[] blob;
	/**
	 * Indicates wether or not the ZipObject is a directory entry.
	 */
	private boolean directory = false;

	public ZipObject(String name) {
		this.name = name;
	}

	public ZipObject(String name, byte[] blob) {
		this.blob = blob;
		this.name = name;
	}

	public ZipObject() {
	}

	/**
	 * Returns the unpacked content.
	 * @return the unpacked content.
	 */
	public byte[] getBlob() {
		return blob;
	}

	/**
	 * Sets the unpacked content.
	 * @param blob
	 */
	public void setBlob(byte[] blob) {
		this.blob = blob;
	}

	/**
	 * Return <code>true</code> when the  object represents a directory entry.
	 * @return <code>true</code> when the  object represents a directory entry.
	 */
	public boolean isDirectory() {
		return directory;
	}

	/**
	 * Set this flag <code>true</code> if the object represents a diretory entry.
	 * @param directory <code>true</code> to represent a directory entry.
	 */
	public void setDirectory(boolean directory) {
		this.directory = directory;
	}

	/**
	 * Returns the name of the entry in the packed file.
	 * @return the name of the entry in the packed file.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of the entry in the packed file.
	 * @param name The name of the entry in the packed file.
	 */
	public void setName(String name) {
		this.name = name;
	}
}
