/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Interpreter.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;

/**
 * Holds the infomation of the interpreter of an album or song.
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Interpreter {
	/**
	 * The firstname of the interpreter.
	 */
	private String firstname;
	/**
	 * The lastname of  the interpreter.
	 */
	private String lastname;
	/**
	 * The fullname of the interpreter.
	 */
	private String fullname;

	/**
	 * The default constructor of the object.
	 */
	public Interpreter() {}

	/**
	 * Constructs a new interpreter object with the name from the DB.
	 * The name form the DB will be splitted in first- and lastname and
	 * the fullname will be created.
	 * @param dbName The interpreters name from DB.
	 */
	public Interpreter(String dbName) {
		int index = dbName.indexOf(';');
		if (index == -1) {
			fullname = dbName;
			lastname = dbName;
			firstname = "";
		} else {
			lastname = dbName.substring(0, index).trim();
			firstname = dbName.substring(index + 1).trim();
			fullname = firstname + ' ' + lastname;
		}
	}

	/**
	 * Returns the firstname of the interpreter.
	 * @return the firstname of the interpreter.
	 */
	public String getFirstname() {
		return firstname;
	}

	/**
	 * Sets the firstname of the interpreter.
	 * @param firstname The firstname of the interpreter.
	 */
	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	/**
	 * Returns the fullname of the interpreter.
	 * @return the fullname of the interpreter.
	 */
	public String getFullname() {
		return fullname;
	}

	/**
	 * Sets the fullname of the interpreter.
	 * @param fullname The fullname of the interpreter.
	 */
	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	/**
	 * Returns the lastname of the interpreter.
	 * @return the lastname of the interpreter.
	 */
	public String getLastname() {
		return lastname;
	}

	/**
	 * Sets the lastname of the interpreter.
	 * @param lastname The lastname of the interpreter.
	 */
	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	/**
	 * Overrides toString of java.lang.Object.
	 * @return a String representation of this track.
	 */
	public String toString() {
		return "[firstname: " + firstname + ", lastname: " + lastname + ", fullname: " + fullname + "]";
	}
}
