/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: DBSearch.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;

/**
 * This class offers you a few methods to search the CD DB.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the method:<br>
 * <ul>
 * <code><li><a href="#findAlbum(java.lang.String, java.lang.String)">public Album[] findAlbum(String title, String interpreter)</a></li></code>
 * <code><li><a href="#findSongAlbum(java.lang.String, java.lang.String)">public Album[] findSongAlbum(String title, String interpreter)</a></li></code>
 * <code><li><a href="#findASongs(java.lang.String)">public TrackResult[] findSongs(String interpreter)</a></li></code>
 * <code><li><a href="#getAllInterpreter()">public String[] getAllInterpreter()</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class DBSearch {
	/**
	 * Retrieves the album wih the given title from the given interpreter.
	 * If the interpreter is null, the method returns all albums with the
	 * given title. If the title is null, the method returns all albums
	 * of the given interpreter.
	 * @param title
	 * @param interpreter
	 * @return the album wih the given title from the given interpreter.
	 */
	public static Album[] findAlbum(String title, String interpreter) {
		return AlbumDB.getInstance().findAlbum(title, interpreter);
	}

	/**
	 * Retrieves the album wih the given song of the given interpreter.
	 * If the interpreter is null, the method returns all albums with the
	 * given title. If the title is null, the method returns all albums
	 * of the given interpreter.
	 * @param songTitle The title of the song to search for.
	 * @param interpreter The name of the interpreter to search for.
	 * @return the album wih the given song of the given interpreter.
	 */
	public static Album[] findSongAlbum(String songTitle, String interpreter) {
		return AlbumDB.getInstance().findSongAlbum(songTitle, interpreter);
	}

	/**
	 * Retrieves all songs of the given interpreter.
	 * @param interpreter The name of the interpreter to search for.
	 * @return all songs of the given interpreter.
	 */
	public static TrackResult[] findSongs(String interpreter) {
		return AlbumDB.getInstance().findSongs(interpreter);
	}

	/**
	 * Retrieves all existing interpreter.
	 * @return All existing interpreter.
	 */
	public static String[] getAllInterpreter() {
		return AlbumDB.getInstance().getAllInterpreter();
	}
}
