/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQJavaLevel;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.QMElt;
import com.ibm.mq.QMTree;
import com.ibm.mq.QMTreeException;
import com.ibm.mq.QueueManagerFactoryProperties;
import com.ibm.mq.TreeElt;
import com.ibm.mqservices.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public final class MQQueueManagerFactory {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQQueueManagerFactory.java, java, j600, j600-101-060328 1.12.1.1 05/05/25 16:05:11";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MQQueueManagerFactory theFactory = null;
    private static QMTree qmTree = null;
    private static final Object lock = new Object();
    private static final String clsName = "MQQueueManagerFactory";

    private MQQueueManagerFactory() {
        if (Trace.isOn) {
            Trace.entry(clsName, "MQQueueManagerFactory constructor");
            Trace.trace(2, clsName, sccsid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQQueueManagerFactory getInstance() {
        MQJavaLevel.traceBuildInfo();
        Object object = lock;
        synchronized (object) {
            if (theFactory == null) {
                theFactory = new MQQueueManagerFactory();
                qmTree = new QMTree();
            }
        }
        return theFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQQueueManager createQueueManager(int n, QueueManagerFactoryProperties queueManagerFactoryProperties) throws MQException {
        if (Trace.isOn) {
            Trace.entry(clsName, "MQQueueManagerFactory.createQueueManager(...)");
            Trace.trace(5, clsName, "options: " + n);
        }
        MQQueueManager mQQueueManager = null;
        Object object = lock;
        synchronized (object) {
            boolean bl;
            if (queueManagerFactoryProperties == null || !queueManagerFactoryProperties.isValid()) {
                MQException mQException = new MQException(2, 2046, this);
                if (Trace.isOn) {
                    Trace.exceptionTrace(1, clsName, mQException);
                }
                throw mQException;
            }
            boolean bl2 = bl = n < 0;
            if (bl) {
                n ^= 0xFFFFFFFF;
            }
            switch (n) {
                case 0: {
                    if (!bl && queueManagerFactoryProperties != null) {
                        mQQueueManager = this.constructQueueManager(queueManagerFactoryProperties);
                        break;
                    }
                    throw new MQException(1, 2046, "no available queue manager");
                }
                case 8: 
                case 32: {
                    Object object2;
                    Object object3;
                    Iterator iterator;
                    Object object4;
                    Object object5;
                    Thread thread = Thread.currentThread();
                    String string = queueManagerFactoryProperties.getName();
                    if (string == null || string.trim().equals("")) {
                        object5 = this.createQueueManager(0, queueManagerFactoryProperties);
                        object4 = new byte[48];
                        int[] nArray = new int[]{2015};
                        ((MQManagedObject)object5).inquire(nArray, null, (byte[])object4);
                        ((MQQueueManager)object5).disconnect();
                        string = new String((byte[])object4);
                        if (string != null) {
                            string = string.trim();
                        } else {
                            throw new MQException(2, 2195, "could not resolve default queue manager");
                        }
                    }
                    if (Trace.isOn) {
                        Trace.trace(5, clsName, "thread: " + thread + ", qMgrName: " + string);
                    }
                    object5 = qmTree.getAssociateBranch(n);
                    object4 = ((TreeElt)object5).children();
                    boolean bl3 = false;
                    if (n == 8) {
                        iterator = object4.iterator();
                        while (!bl3 && iterator.hasNext()) {
                            TreeElt treeElt = (TreeElt)iterator.next();
                            if (thread == (Thread)treeElt.getElement()) {
                                object3 = qmTree.getChild((TreeElt)object5, thread);
                                if (object3 != null) {
                                    object5 = object3;
                                    object4 = ((TreeElt)object5).children();
                                    bl3 = true;
                                    continue;
                                }
                                object4 = new ArrayList();
                                continue;
                            }
                            object4 = new ArrayList();
                        }
                    }
                    iterator = object4.iterator();
                    boolean bl4 = false;
                    while (!bl4 && iterator.hasNext()) {
                        object3 = (TreeElt)iterator.next();
                        object2 = (QMElt)((TreeElt)object3).getElement();
                        if (!string.equals(((QMElt)object2).name)) continue;
                        bl4 = true;
                        object5 = object3;
                    }
                    if (Trace.isOn) {
                        Trace.trace(5, clsName, "matching queue manager " + (bl4 ? "found" : "not found"));
                    }
                    if (bl4) {
                        object3 = (QMElt)((TreeElt)object5).getElement();
                        mQQueueManager = ((QMElt)object3).mgr;
                        queueManagerFactoryProperties.getMgr().association = n;
                        try {
                            qmTree.addChild((TreeElt)object5, queueManagerFactoryProperties.getMgr());
                            break;
                        }
                        catch (QMTreeException qMTreeException) {
                            MQException mQException = new MQException(2, 2195, "failed to update qmTree");
                            mQException.initCause(qMTreeException);
                            throw mQException;
                        }
                    }
                    if (bl) {
                        throw new MQException(1, 2046, "no available queue manager");
                    }
                    mQQueueManager = this.constructQueueManager(queueManagerFactoryProperties);
                    try {
                        if (n == 8 && !bl3) {
                            qmTree.addChild((TreeElt)object5, thread);
                            object5 = qmTree.getChild((TreeElt)object5, thread);
                        }
                        object3 = new QMElt(string, mQQueueManager);
                        qmTree.addChild((TreeElt)object5, object3);
                        object5 = qmTree.getChild((TreeElt)object5, object3);
                        qmTree.addChild((TreeElt)object5, queueManagerFactoryProperties.getMgr());
                        queueManagerFactoryProperties.getMgr().association = n;
                        break;
                    }
                    catch (QMTreeException qMTreeException) {
                        object2 = new MQException(2, 2195, "failed to update qmTree");
                        ((MQException)object2).initCause(qMTreeException);
                        throw object2;
                    }
                }
                default: {
                    MQException mQException = new MQException(2, 2046, this);
                    if (Trace.isOn) {
                        Trace.trace(1, clsName, "bad context value: " + n);
                        Trace.exceptionTrace(1, clsName, mQException);
                    }
                    throw mQException;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(clsName, "MQQueueManagerFactory.createQueueManager(...)");
        }
        return mQQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(MQQueueManager mQQueueManager) throws MQException {
        Object object = lock;
        synchronized (object) {
            if (qmTree.leafContains(mQQueueManager)) {
                switch (mQQueueManager.association) {
                    case 0: {
                        break;
                    }
                    case 8: 
                    case 32: {
                        TreeElt treeElt = MQQueueManagerFactory.find(mQQueueManager);
                        if (treeElt != null) {
                            try {
                                qmTree.removeChild(treeElt, mQQueueManager);
                                while (treeElt.children().size() == 0 && treeElt.depth() != 1) {
                                    Object object2 = treeElt.getElement();
                                    if (object2 instanceof MQQueueManager) {
                                        ((MQQueueManager)object2).connected = false;
                                    }
                                    treeElt = qmTree.parent(treeElt);
                                    qmTree.removeChild(treeElt, object2);
                                }
                                break;
                            }
                            catch (QMTreeException qMTreeException) {
                                MQException mQException = new MQException(2, 2195, "failed to remove qm: " + mQQueueManager);
                                mQException.initCause(qMTreeException);
                                throw mQException;
                            }
                        }
                        if (mQQueueManager.association != 8 || !qmTree.leafContains(mQQueueManager)) break;
                        MQException mQException = new MQException(2, 2042, this);
                        if (Trace.isOn) {
                            Trace.exceptionTrace(1, this, mQException);
                        }
                        throw mQException;
                    }
                    default: {
                        MQException mQException = new MQException(2, 2046, this);
                        if (Trace.isOn) {
                            Trace.trace(1, clsName, "bad association value: " + mQQueueManager.association);
                            Trace.exceptionTrace(1, clsName, mQException);
                        }
                        throw mQException;
                    }
                }
            }
        }
    }

    public static boolean isReferenced(MQQueueManager mQQueueManager) {
        return qmTree != null ? qmTree.leafContains(mQQueueManager) : false;
    }

    public static boolean isLastReference(MQQueueManager mQQueueManager) {
        return MQQueueManagerFactory.getReferenceCount(mQQueueManager) <= 1;
    }

    public static int getReferenceCount(MQQueueManager mQQueueManager) {
        TreeElt treeElt;
        int n = 0;
        if (mQQueueManager != null && mQQueueManager.association != 0 && (treeElt = MQQueueManagerFactory.find(mQQueueManager)) != null && treeElt.getParent() != null) {
            n = treeElt.getParent().children().size();
        }
        return n;
    }

    public static boolean compare(MQQueueManager mQQueueManager, MQQueueManager mQQueueManager2) {
        boolean bl = false;
        if (mQQueueManager == null || mQQueueManager2 == null) {
            bl = false;
        } else if (mQQueueManager.association == mQQueueManager2.association && mQQueueManager.association != 0) {
            TreeElt treeElt = MQQueueManagerFactory.find(mQQueueManager);
            TreeElt treeElt2 = MQQueueManagerFactory.find(mQQueueManager2);
            bl = treeElt != null && treeElt2 != null && treeElt.getParent() == treeElt2.getParent();
        } else {
            bl = mQQueueManager == mQQueueManager2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeElt find(MQQueueManager mQQueueManager) {
        TreeElt treeElt = null;
        Object object = lock;
        synchronized (object) {
            if (qmTree != null && mQQueueManager != null) {
                Object object2;
                treeElt = qmTree.root();
                treeElt = qmTree.getChild(treeElt, new Integer(mQQueueManager.association));
                if (mQQueueManager.association == 8) {
                    object2 = Thread.currentThread();
                    treeElt = qmTree.getChild(treeElt, object2);
                }
                if (treeElt != null) {
                    object2 = treeElt.children();
                    Iterator iterator = object2.iterator();
                    boolean bl = false;
                    while (!bl && iterator.hasNext()) {
                        QMElt qMElt = (QMElt)((TreeElt)iterator.next()).getElement();
                        TreeElt treeElt2 = qmTree.getChild(treeElt, qMElt);
                        Collection collection = treeElt2.children();
                        Iterator iterator2 = collection.iterator();
                        while (!bl && iterator2.hasNext()) {
                            MQQueueManager mQQueueManager2 = (MQQueueManager)((TreeElt)iterator2.next()).getElement();
                            if (mQQueueManager2 != mQQueueManager) continue;
                            bl = true;
                            treeElt = qmTree.getChild(treeElt2, mQQueueManager);
                        }
                    }
                    if (!bl) {
                        treeElt = null;
                    }
                }
            }
        }
        return treeElt;
    }

    private MQQueueManager constructQueueManager(QueueManagerFactoryProperties queueManagerFactoryProperties) throws MQException {
        MQQueueManager mQQueueManager = null;
        Object object = queueManagerFactoryProperties.getConMgr();
        mQQueueManager = object != null ? (object instanceof MQConnectionManager ? this.procure(queueManagerFactoryProperties.getName(), queueManagerFactoryProperties.getProperties(), (MQConnectionManager)object, null) : this.procure(queueManagerFactoryProperties.getName(), queueManagerFactoryProperties.getProperties(), null, (ConnectionManager)object)) : this.procure(queueManagerFactoryProperties.getName(), queueManagerFactoryProperties.getProperties(), null, null);
        return mQQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MQQueueManager procure(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager, ConnectionManager connectionManager) throws MQException {
        Trace.entry(clsName, "construct");
        try {
            Object object;
            if (mQConnectionManager == null && connectionManager == null) {
                object = MQEnvironment.poolTokenSet;
                synchronized (object) {
                    mQConnectionManager = MQEnvironment.defaultMQCxManager;
                    connectionManager = MQEnvironment.defaultCxManager;
                }
            }
            if (mQConnectionManager == null && connectionManager instanceof MQConnectionManager) {
                mQConnectionManager = (MQConnectionManager)connectionManager;
                connectionManager = null;
            }
            object = null;
            object = mQConnectionManager != null ? this.obtainBaseMQQueueManager(string, hashtable, mQConnectionManager) : this.obtainBaseMQQueueManager(string, hashtable, connectionManager);
            Object object2 = object;
            return object2;
        }
        finally {
            Trace.exit(clsName, "construct");
        }
    }

    private MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, ConnectionManager connectionManager) throws MQException {
        String string2 = this.determineTransport(hashtable);
        ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)MQSESSION.getMQManagedConnectionFactory(string2, string, hashtable, false);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string2, hashtable, false);
        try {
            MQQueueManager mQQueueManager = (MQQueueManager)connectionManager.allocateConnection(managedConnectionFactory, connectionRequestInfo);
            return mQQueueManager;
        }
        catch (ResourceException resourceException) {
            throw this.processException(resourceException);
        }
        finally {
            Trace.exit(clsName, "obtainBaseMQQueueManager (Java 2 version)");
        }
    }

    private MQQueueManager obtainBaseMQQueueManager(String string, Hashtable hashtable, MQConnectionManager mQConnectionManager) throws MQException {
        String string2 = this.determineTransport(hashtable);
        MQManagedConnectionFactory mQManagedConnectionFactory = MQSESSION.getMQManagedConnectionFactory(string2, string, hashtable, true);
        ConnectionRequestInfo connectionRequestInfo = MQSESSION.getConnectionRequestInfo(string2, hashtable, false);
        try {
            MQQueueManager mQQueueManager;
            MQQueueManager mQQueueManager2 = mQQueueManager = (MQQueueManager)mQConnectionManager.allocateConnection(mQManagedConnectionFactory, connectionRequestInfo);
            return mQQueueManager2;
        }
        catch (ResourceException resourceException) {
            throw this.processException(resourceException);
        }
        finally {
            Trace.exit(clsName, "TODO");
        }
    }

    private String determineTransport(Hashtable hashtable) throws MQException {
        String string;
        String string2 = MQEnvironment.getStringProperty("transport", hashtable);
        if (string2.equals("MQSeries")) {
            string = MQEnvironment.getStringProperty("hostname", hashtable);
            string2 = string == null || string.trim().equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        if (!string2.equals("MQSeries Client") && (string = MQEnvironment.getStringProperty("SSL Cipher Suite", hashtable)) != null && !string.trim().equals("")) {
            throw new MQException(2, 2396, null);
        }
        return string2;
    }

    private MQException processException(ResourceException resourceException) {
        if (resourceException.getMessage().equals("allocateConnection")) {
            return new MQException(2, 2025, "no more connections available");
        }
        Exception exception = resourceException.getLinkedException();
        if (exception instanceof MQException) {
            return (MQException)exception;
        }
        return new MQException(2, 2195, this);
    }
}

