/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQConnectionEventListener;
import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQConnectionSecurityParameters;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionMetaData;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mq.MQSSLConfigurationOptions;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mqservices.Trace;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.transaction.xa.XAResource;

public class MQManagedConnectionJ11 {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQManagedConnectionJ11.java, java, j600, j600-101-060328 1.52.1.1 05/05/25 15:40:06";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String qmgrName;
    private MQSESSION session;
    private Pint Hconn = new Pint();
    private boolean connected = false;
    private Hashtable properties = new Hashtable();
    private boolean reusable = true;
    Vector qmgrs = new Vector();
    ConnectionRequestInfo initialCxReqInf;
    MQManagedConnectionFactory initialMCF;
    PrintWriter logWriter;
    ManagedConnectionMetaData metaData = null;
    Vector mqListeners = new Vector();
    boolean allowErrorEvents = false;

    MQManagedConnectionJ11(String string, Hashtable hashtable, ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQManagedConnection constructor");
        }
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pthrowable pthrowable = new Pthrowable();
        boolean bl = false;
        if (string == null) {
            string = "";
        }
        this.qmgrName = string;
        if (hashtable == null || connectionRequestInfo == null || mQManagedConnectionFactory == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQManagedConnection constructor (via exception)");
            }
            throw new NullPointerException();
        }
        this.initialCxReqInf = connectionRequestInfo;
        this.initialMCF = (MQManagedConnectionFactory)mQManagedConnectionFactory.clone();
        this.properties = hashtable;
        this.connected = false;
        this.session = MQSESSION.getSession(this);
        boolean bl2 = "SPI_ENABLE".equals(this.getStringProperty("SPI"));
        MQConnectionOptions mQConnectionOptions = this.constructCNO();
        if (bl2) {
            this.session.spiConnect(string, mQConnectionOptions, this.Hconn, pint, pint2, pthrowable);
        } else if (mQConnectionOptions == null) {
            this.session.MQCONN(string, this.Hconn, pint, pint2, pthrowable);
        } else {
            this.session.MQCONNX(string, mQConnectionOptions, this.Hconn, pint, pint2, pthrowable);
        }
        if (pint.x != 0 || pint2.x != 0) {
            MQException mQException;
            this.session = null;
            if (Trace.isOn) {
                Trace.exit(this, "MQManagedConnection constructor (via exception)");
            }
            if (pthrowable != null && pthrowable.e != null && pthrowable.e instanceof MQException) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Flowing exception message from pCause");
                }
                mQException = new MQException(pint.x, pint2.x, (Object)this, (MQException)pthrowable.e);
            } else {
                if (Trace.isOn) {
                    Trace.trace(2, this, "It was not possible to flow the exception message");
                }
                mQException = new MQException(pint.x, pint2.x, this);
            }
            if (pthrowable != null && pthrowable.e != null) {
                mQException.initCause(pthrowable.e);
            }
            throw mQException;
        }
        this.connected = true;
        if (Trace.isOn) {
            Trace.exit(this, "MQManagedConnection constructor");
        }
    }

    public void addMQConnectionEventListener(MQConnectionEventListener mQConnectionEventListener) {
        if (Trace.isOn) {
            Trace.entry(this, "addMQConnectionEventListener");
        }
        if (mQConnectionEventListener == null) {
            if (Trace.isOn) {
                Trace.exit(this, "addMQConnectionEventListener (via exception)");
            }
            throw new NullPointerException();
        }
        this.mqListeners.addElement(mQConnectionEventListener);
        if (Trace.isOn) {
            Trace.exit(this, "addMQConnectionEventListener");
        }
    }

    public void removeMQConnectionEventListener(MQConnectionEventListener mQConnectionEventListener) {
        if (Trace.isOn) {
            Trace.entry(this, "removeMQConnectionEventListener");
        }
        if (mQConnectionEventListener == null) {
            if (Trace.isOn) {
                Trace.exit(this, "addMQConnectionEventListener (via exception)");
            }
            throw new NullPointerException();
        }
        this.mqListeners.removeElement(mQConnectionEventListener);
        if (Trace.isOn) {
            Trace.exit(this, "removeMQConnectionEventListener");
        }
    }

    public synchronized Object getConnection(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        MQQueueManager mQQueueManager;
        if (Trace.isOn) {
            Trace.entry(this, "getConnection");
        }
        if (!this.connected) {
            String string = MQException.getNLSMsg(106);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            if (Trace.isOn) {
                Trace.exit(this, "getConnection (via exception)");
            }
            throw illegalStateException;
        }
        if (!this.reusable) {
            String string = MQException.getNLSMsg(108);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            if (Trace.isOn) {
                Trace.exit(this, "getConnection (via exception)");
            }
            throw illegalStateException;
        }
        if (!this.isSuitable(connectionRequestInfo, this.initialMCF)) {
            String string = MQException.getNLSMsg(105);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            if (Trace.isOn) {
                Trace.exit(this, "getConnection (via exception)");
            }
            throw illegalStateException;
        }
        try {
            mQQueueManager = new MQQueueManager(this);
        }
        catch (MQException mQException) {
            ResourceException resourceException = mQException.getResourceException();
            if (Trace.isOn) {
                Trace.exit(this, "getConnection (via exception)");
            }
            throw resourceException;
        }
        this.qmgrs.addElement(mQQueueManager);
        this.allowErrorEvents = true;
        if (Trace.isOn) {
            Trace.exit(this, "getConnection");
        }
        return mQQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws ResourceException {
        MQQueueManager mQQueueManager;
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "destroy");
        }
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        this.allowErrorEvents = false;
        Enumeration enumeration = this.qmgrs.elements();
        while (enumeration.hasMoreElements()) {
            object = (MQQueueManager)enumeration.nextElement();
            mQQueueManager = object;
            synchronized (mQQueueManager) {
                if (((MQQueueManager)object).isConnected()) {
                    ((MQQueueManager)object).cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "destroy (via exception)");
            }
            object = MQException.getNLSMsg(106);
            throw new IllegalStateException((String)object);
        }
        this.session.MQDISC(this.Hconn, pint, pint2);
        this.connected = false;
        this.session = null;
        if (pint.x != 0 || pint2.x != 0) {
            object = new MQException(pint.x, pint2.x, this);
            mQQueueManager = ((MQException)object).getResourceException();
            if (Trace.isOn) {
                Trace.exit(this, "destory (via exception)");
            }
            throw mQQueueManager;
        }
        if (Trace.isOn) {
            Trace.exit(this, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanup() throws ResourceException {
        Object object;
        Object object2;
        if (Trace.isOn) {
            Trace.entry(this, "cleanup()");
        }
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        this.allowErrorEvents = false;
        Enumeration enumeration = this.qmgrs.elements();
        while (enumeration.hasMoreElements()) {
            object = object2 = (MQQueueManager)enumeration.nextElement();
            synchronized (object) {
                if (((MQQueueManager)object2).isConnected()) {
                    ((MQQueueManager)object2).cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        object2 = this.getStringProperty("Thread access");
        if (object2 != null && ((String)object2).equals("SINGLE_THREAD")) {
            if (Trace.isOn) {
                Trace.trace(2, this, "cleanup attempted on SINGLE_THREAD MQManagedConnection");
                Trace.exit(this, "cleanup (via exception)");
            }
            object = MQException.getNLSMsg(108);
            throw new IllegalStateException((String)object);
        }
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "cleanup (via exception)");
            }
            object = MQException.getNLSMsg(106);
            throw new IllegalStateException((String)object);
        }
        this.session.MQBACK(this.Hconn.x, pint, pint2);
        if (!this.reusable) {
            if (Trace.isOn) {
                Trace.exit(this, "cleanup (via exception)");
            }
            object = MQException.getNLSMsg(108);
            throw new IllegalStateException((String)object);
        }
        if ((pint.x != 0 || pint2.x != 0) && pint2.x != 2012) {
            object = new MQException(pint.x, pint2.x, this);
            ResourceException resourceException = ((MQException)object).getResourceException();
            if (Trace.isOn) {
                Trace.exit(this, "cleanup (via exception)");
            }
            throw resourceException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "cleanup");
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "associateConnection - NOT SUPPORTED");
            Trace.exit(this, "assoicateConnection (via exception)");
        }
        String string = MQException.getNLSMsg(107, "associateConnection");
        throw new NotSupportedException(string);
    }

    public XAResource getXAResource() throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "getXAResource - NOT SUPPORTED");
            Trace.exit(this, "getXAResource (via exception)");
        }
        String string = MQException.getNLSMsg(107, "getXAResource");
        throw new NotSupportedException(string);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "getLocalTransaction - NOT SUPPORTED");
            Trace.exit(this, "getLocalTransaction (via exception)");
        }
        String string = MQException.getNLSMsg(107, "getLocalTransaction");
        throw new NotSupportedException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "getMetaData");
        }
        if (this.metaData == null) {
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
            synchronized (mQManagedConnectionJ11) {
                if (this.metaData == null) {
                    this.metaData = new MQManagedConnectionMetaData(this);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getMetaData");
        }
        return this.metaData;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionClosedEvent(MQQueueManager mQQueueManager) {
        Vector vector;
        if (Trace.isOn) {
            Trace.entry(this, "fireConnectionClosedEvent");
        }
        this.qmgrs.removeElement(mQQueueManager);
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.mqListeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            MQConnectionEventListener mQConnectionEventListener = (MQConnectionEventListener)object.nextElement();
            mQConnectionEventListener.connectionClosed(this, mQQueueManager);
        }
        if (Trace.isOn) {
            Trace.exit(this, "fireConnectionClosedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionErrorEvent(MQQueueManager mQQueueManager, Exception exception) {
        if (Trace.isOn) {
            Trace.entry(this, "fireConnectionErrorEvent");
        }
        if (this.allowErrorEvents) {
            Vector vector;
            Object object = this;
            synchronized (object) {
                vector = (Vector)this.mqListeners.clone();
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                MQConnectionEventListener mQConnectionEventListener = (MQConnectionEventListener)object.nextElement();
                mQConnectionEventListener.connectionErrorOccurred(this, mQQueueManager, exception);
            }
            if (Trace.isOn) {
                Trace.exit(this, "fireConnectionErrorEvent");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            Pint pint = new Pint();
            Pint pint2 = new Pint();
            Enumeration enumeration = this.qmgrs.elements();
            while (enumeration.hasMoreElements()) {
                MQQueueManager mQQueueManager;
                MQQueueManager mQQueueManager2 = mQQueueManager = (MQQueueManager)enumeration.nextElement();
                synchronized (mQQueueManager2) {
                    if (mQQueueManager.isConnected()) {
                        mQQueueManager.cleanup();
                    }
                }
            }
            this.qmgrs.removeAllElements();
            if (this.connected) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "implicit disconnect");
                }
                try {
                    if (MQSESSION.backoutOnImplicitDisc()) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Backout on implicit disconnect");
                        }
                        this.session.MQBACK(this.Hconn.x, pint, pint2);
                        if (pint.x != 0) {
                            if (pint2.x == 2012) {
                                if (Trace.isOn) {
                                    Trace.trace(2, this, "Backout on implicit disconnect not performed due to environment");
                                }
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(2, this, "Backout on implicit disconnect failed");
                                    Trace.exit(this, "finalize (via exception)");
                                }
                                throw new MQException(pint.x, pint2.x, this);
                            }
                        }
                    }
                    this.destroy();
                }
                catch (Exception exception) {
                    if (!Trace.isOn) break block18;
                    Trace.trace(4, this, "exception discarded: " + exception);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    boolean isConnected() {
        return this.connected;
    }

    MQSESSION getMQSESSION() {
        return this.session;
    }

    Pint getHConn() {
        return this.Hconn;
    }

    String getQmgrName() {
        return this.qmgrName;
    }

    Object getProperty(Object object) {
        return this.properties.get(object);
    }

    int getIntegerProperty(Object object) {
        return this.getIntegerProperty(object, 0);
    }

    int getIntegerProperty(Object object, int n) {
        Object object2 = this.getProperty(object);
        int n2 = object2 != null && object2 instanceof Integer ? (Integer)object2 : n;
        return n2;
    }

    public String getStringProperty(Object object) {
        return this.getStringProperty(object, null);
    }

    String getStringProperty(Object object, String string) {
        Object object2 = this.getProperty(object);
        String string2 = object2 != null && object2 instanceof String ? (String)object2 : string;
        return string2;
    }

    String getStringProperty(Object object, String string, int n) {
        return MQSESSION.setStringToLength(this.getStringProperty(object, string), n);
    }

    void setNotReusable() {
        this.reusable = false;
        if (Trace.isOn) {
            Trace.trace(2, this, "MQManagedConnection set to be non-reusable");
        }
    }

    boolean isReusable() {
        return this.reusable;
    }

    boolean isSuitable(ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) {
        if (this.connected && this.reusable && ((Object)this.initialMCF).equals(mQManagedConnectionFactory)) {
            if (connectionRequestInfo instanceof ClientConnectionRequestInfo) {
                return ((ClientConnectionRequestInfo)connectionRequestInfo).isSuitable(this);
            }
            return this.initialCxReqInf.equals(connectionRequestInfo);
        }
        return false;
    }

    protected boolean authenticate(Pint pint, Pint pint2) throws MQException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "authenticate");
            }
            MQSESSION mQSESSION = MQSESSION.getSession(this);
            MQManagedConnectionMetaData mQManagedConnectionMetaData = (MQManagedConnectionMetaData)this.getMetaData();
            int n = mQManagedConnectionMetaData.getCommandLevel();
            if (n >= 531) {
                mQSESSION.setAuthenticateBindings(true);
            } else {
                mQSESSION.setAuthenticateBindings(false);
            }
            String string = this.getStringProperty("userID", "");
            String string2 = this.getStringProperty("password", "");
            pint.x = 0;
            if (null != string && !string.trim().equals("")) {
                mQSESSION.authenticate(this.Hconn.x, string, string2, pint, pint2);
            }
            if (pint.x == 2) {
                if (Trace.isOn) {
                    Trace.trace(this, "Failed to authenticate userId and Password: rc=" + pint2.x);
                }
                MQException mQException = new MQException(pint.x, pint2.x, this);
                throw mQException;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof MQException) {
                throw (MQException)exception;
            }
            MQException mQException = new MQException(2, 2102, this);
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "authenticate");
            }
        }
    }

    private MQConnectionOptions constructCNO() throws MQException {
        Object object;
        int n;
        if (Trace.isOn) {
            Trace.entry(this, "ConstructCNO");
        }
        MQConnectionOptions mQConnectionOptions = new MQConnectionOptions();
        int n2 = n = this.getIntegerProperty("connectOptions");
        String string = this.getStringProperty("transport");
        if ((n2 &= 0xFFFFFC60) != 0) {
            if (Trace.isOn) {
                Trace.exit(this, "ConstructCNO");
            }
            throw new MQException(2, 2046, this);
        }
        if (string.equals("MQSeries Client")) {
            if (n != 0) {
                n2 = n;
                if ((n2 &= 0xFFFFFDFF) == 0 && n != 0) {
                    n -= 512;
                }
            }
            if (n != 0) {
                n2 = n;
                if ((n2 &= 0xFFFFFEFF) == 0 && n != 0) {
                    n -= 256;
                }
            }
            if ((n & 8) != 0 || (n & 0x10) != 0) {
                MQException mQException = new MQException(2, 2046, this);
                if (Trace.isOn) {
                    Trace.exit(this, "ConstructCNO");
                }
                throw mQException;
            }
        }
        mQConnectionOptions.setOptions(n);
        mQConnectionOptions.setVersion(1);
        Object object2 = this.getProperty("ConnTag Property");
        boolean bl = false;
        if (object2 != null && object2 instanceof byte[]) {
            object = (byte[])object2;
            for (int i = 0; i < ((byte[])object).length; ++i) {
                if (object[i] == 0) continue;
                bl = true;
            }
            if (bl) {
                mQConnectionOptions.setVersion(3);
                mQConnectionOptions.setConnTag((byte[])object);
            }
        }
        if (string.equals("MQSeries Client")) {
            int n3 = this.getIntegerProperty("KeyResetCount", 0);
            if (n3 < 0 || n3 > 999999999) {
                if (Trace.isOn) {
                    Trace.exit(this, "ConstructCNO");
                }
                throw new MQException(2, 2409, this);
            }
            if (n3 > 0) {
                ((MQSESSIONClient)this.session).setSSLResetCount(n3);
                mQConnectionOptions.setVersion(4);
                MQSSLConfigurationOptions mQSSLConfigurationOptions = new MQSSLConfigurationOptions();
                mQSSLConfigurationOptions.setKeyResetCount(n3);
                mQSSLConfigurationOptions.setVersion(2);
                mQConnectionOptions.setMQSCO(mQSSLConfigurationOptions);
            }
        }
        if (string.equals("MQSeries Bindings")) {
            object = this.getStringProperty("userID", null);
            String string2 = this.getStringProperty("password", null);
            if (Trace.isOn) {
                Trace.trace(this, "MQCSP UserName = " + (String)object);
            }
            if (object != null && string2 != null && object != "") {
                mQConnectionOptions.setVersion(5);
                MQConnectionSecurityParameters mQConnectionSecurityParameters = new MQConnectionSecurityParameters();
                mQConnectionSecurityParameters.setCSPUserId((String)object);
                mQConnectionSecurityParameters.setCSPPassword(string2);
                mQConnectionSecurityParameters.setAuthenticationType(1);
                mQConnectionOptions.setMQCSP(mQConnectionSecurityParameters);
                if (Trace.isOn) {
                    Trace.trace(this, " Constructed CSP AuthType " + mQConnectionSecurityParameters.getAuthenticationType());
                }
            }
        }
        if (n == 0 && mQConnectionOptions.getVersion() == 1) {
            if (Trace.isOn) {
                Trace.exit(this, "ConstructCNO returning null");
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "ConstructCNO returning CNO Version 5");
        }
        return mQConnectionOptions;
    }
}

