/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.SSLHelper;
import com.ibm.mqservices.Trace;

public class MQExternalUserExit {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQExternalUserExit.java, jms, j600, j600-101-060504 1.24.1.5 06/05/04 14:38:09";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String className;
    protected String sslCipherSpec = "";
    protected String[] exitLibraries = new String[]{""};
    protected String[] exitEntries = new String[]{""};
    protected String[] dataStrings = new String[]{""};
    protected byte[][] dllHandles = new byte[1][8];
    protected byte[][] fnPointers = new byte[1][8];
    protected int reasonCode;
    protected long sendExitBank = 0L;
    protected long recieveExitBank = 0L;
    protected long securityExitBank = 0L;
    private byte[] newBufferFromExit = null;
    private int exitCount = 0;
    private Object exitLock = new Object();

    public void setNewBuffer(byte[] byArray) {
        this.newBufferFromExit = byArray;
    }

    protected MQExternalUserExit() {
        String string;
        String string2 = className + " constructor";
        if (Trace.isOn) {
            Trace.entry(this, string2);
            Trace.trace(2, this, sccsid);
        }
        if ((string = MQEnvironment.sslCipherSuite) != null) {
            this.sslCipherSpec = SSLHelper.translate(string, 0);
        }
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
    }

    protected MQExternalUserExit(String string, String string2, String string3) {
        String string4;
        String string5 = className + " constructor";
        if (Trace.isOn) {
            Trace.entry(this, string5);
            Trace.trace(2, this, sccsid);
        }
        if ((string4 = MQEnvironment.sslCipherSuite) != null) {
            this.sslCipherSpec = SSLHelper.translate(string4, 0);
        }
        System.loadLibrary("mqjexitstub01");
        this.setLibraryName(string);
        this.setEntryPointName(string2);
        this.setUserData(string3);
        if (Trace.isOn) {
            Trace.exit(this, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] userExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
        int n = 0;
        String string = "userExit";
        Trace.entry(className, string);
        this.reasonCode = 0;
        if (mQChannelDefinition.sslPeerName == null) {
            mQChannelDefinition.sslPeerName = "";
        }
        if (mQChannelDefinition.remoteUserId == null) {
            mQChannelDefinition.remoteUserId = "";
        }
        if (mQChannelExit.exitUserArea == null) {
            mQChannelExit.exitUserArea = new byte[0];
        }
        int n2 = mQChannelExit.exitReason;
        boolean bl = false;
        if (11 == n2) {
            Object object = this.exitLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit.UserExit", "MQXR_INIT - attempt to route 1st call to exit. exitCount=" + this.exitCount);
                }
                if (this.exitCount <= 0) {
                    bl = true;
                }
                ++this.exitCount;
            }
        } else if (12 == n2) {
            Object object = this.exitLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.trace("MQExternalUserExit.UserExit", "MQXR_TERM - attempt to route last call to exit. prior to decrement exitCount=" + this.exitCount);
                }
                --this.exitCount;
                if (this.exitCount <= 0) {
                    bl = true;
                }
            }
        } else {
            if (Trace.isOn) {
                Trace.trace("MQExternalUserExit.UserExit", "Got exitreason=" + n2 + " sending direct to exit.");
            }
            bl = true;
        }
        if (bl) {
            this.newBufferFromExit = null;
            n = this.jniChannelExit(mQChannelExit, mQChannelDefinition, byArray);
            if (this.newBufferFromExit != null) {
                byArray = this.newBufferFromExit;
            }
        }
        Trace.trace(className, "trace code returned from jniChannelExit is " + n % 256);
        switch (n / 256) {
            case 0: {
                this.reasonCode = 0;
                break;
            }
            case 2: 
            case 3: {
                this.reasonCode = 2406;
                break;
            }
            default: {
                this.reasonCode = 2407;
            }
        }
        Trace.trace(className, "reason code after jniChannelExit is " + this.reasonCode);
        Trace.exit(className, string);
        return byArray;
    }

    private native int jniChannelExit(MQChannelExit var1, MQChannelDefinition var2, byte[] var3);

    public static native String getExitClasspath();

    public void setEntryPointName(String string) {
        String string2 = "setEntryPointName";
        Trace.entry(className, string2);
        Trace.trace(className, "entryPointName is " + string);
        this.exitEntries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    static String[] augment(String[] stringArray, String string) {
        String string2 = "augment";
        Trace.entry(className, string2);
        int n = stringArray.length;
        String[] stringArray2 = new String[1 + n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = string;
        Trace.trace(className, "New array is " + stringArray2);
        Trace.exit(className, string2);
        return stringArray2;
    }

    public void setLibraryName(String string) {
        String string2 = "setLibraryName";
        Trace.entry(className, string2);
        Trace.trace(className, "New library name is " + string);
        this.exitLibraries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public void setUserData(String string) {
        String string2 = "setUserData";
        Trace.entry(className, string2);
        Trace.trace(className, "New user data is " + string);
        this.dataStrings[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public String getUserData() {
        String string = "getUserData";
        Trace.entry(className, string);
        Trace.trace(className, "New user data is " + this.dataStrings[0]);
        Trace.exit(className, string);
        return this.dataStrings[0];
    }

    protected String getEntryPointName() {
        String string = "getEntryPointName";
        Trace.entry(className, string);
        Trace.trace(className, "Entry point name is " + this.exitEntries[0]);
        Trace.exit(className, string);
        return this.exitEntries[0];
    }

    protected String getLibraryName() {
        String string = "getLibraryName";
        Trace.entry(className, string);
        Trace.trace(className, "Library name is " + this.exitEntries[0]);
        Trace.exit(className, string);
        return this.exitLibraries[0];
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    static {
        System.loadLibrary("mqjexitstub01");
        className = "MQExternalUserExit";
    }
}

