/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APENC
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APENC.java, jms, j600, j600-101-060328 1.8.1.1 05/05/25 15:53:04";
    public static final String LONGNAME = "ENCODING";
    public static final String SHORTNAME = "ENC";
    public static final String NATIVE = "NATIVE";
    public static final char NORMAL = 'N';
    public static final char REVERSED = 'R';
    public static final char S390 = '3';
    public static final char UNKNOWN = '?';

    public static String valToString(int n) throws JMSException {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 273) {
            stringBuffer.append(NATIVE);
        } else {
            if ((n & 1) != 0) {
                stringBuffer.append('N');
            } else if ((n & 2) != 0) {
                stringBuffer.append('R');
            } else {
                stringBuffer.append('?');
            }
            if ((n & 0x10) != 0) {
                stringBuffer.append('N');
            } else if ((n & 0x20) != 0) {
                stringBuffer.append('R');
            } else {
                stringBuffer.append('?');
            }
            if ((n & 0x300) == 768) {
                stringBuffer.append('3');
            } else if ((n & 0x100) == 256) {
                stringBuffer.append('N');
            } else if ((n & 0x200) == 512) {
                stringBuffer.append('R');
            } else {
                stringBuffer.append('?');
            }
        }
        return stringBuffer.toString();
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(NATIVE)) {
            n = 273;
        } else if (string2.length() == 3) {
            n = 0;
            if (string2.charAt(0) == 'N') {
                n |= 1;
            } else if (string2.charAt(0) == 'R') {
                n |= 2;
            }
            if (string2.charAt(1) == 'N') {
                n |= 0x10;
            } else if (string2.charAt(1) == 'R') {
                n |= 0x20;
            }
            if (string2.charAt(2) == 'N') {
                n |= 0x100;
            } else if (string2.charAt(2) == 'R') {
                n |= 0x200;
            } else if (string2.charAt(2) == '3') {
                n |= 0x300;
            }
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block17: {
            try {
                String string;
                int n;
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = APENC.getProperty(SHORTNAME, hashtable)) == null) break block17;
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                } else if (object2 instanceof String) {
                    string = (String)object2;
                    n = APENC.stringToVal(string);
                } else {
                    String string2 = "value supplied as an unexpected object type " + object2.getClass();
                    String string3 = "MQJMS1016";
                    String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                    JMSException jMSException = new JMSException(string4, string3);
                    throw jMSException;
                }
                if (object instanceof MQDestination) {
                    try {
                        ((MQDestination)object).setEncoding(n);
                        break block17;
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                        throw bAOException;
                    }
                }
                string = "object supplied as an unexpected type " + object.getClass();
                String string5 = "MQJMS1016";
                String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                JMSException jMSException = new JMSException(string6, string5);
                throw jMSException;
            }
            catch (BAOException bAOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + bAOException);
                }
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQDestination)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQDestination)object).getEncoding();
            String string = APENC.valToString(n);
            hashtable.put(LONGNAME, string);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

