/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Vector;

public final class SerialMessage
implements Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SerialMessage.java, disthub, j600, j600-101-060328 1.5.1.1 05/05/25 15:44:27";
    private int msgType;
    private Serializable body;
    private Dictionary properties;
    private String correlationID;
    private String messageID;
    private int priority;
    private long timestamp;
    private String typeField;
    private String replyTopic;
    private String topic;
    private boolean readOnly;
    private boolean propertiesReadOnly;
    private long expiration;
    private boolean redelivered;
    private boolean persistent;
    private int streamOffset;

    public SerialMessage(MessageImpl messageImpl) {
        this.msgType = messageImpl instanceof BytesMessageImpl ? 3 : messageImpl.getMessageType();
        this.readOnly = messageImpl.readOnly;
        this.propertiesReadOnly = messageImpl.propertiesReadOnly;
        switch (this.msgType) {
            case 3: {
                this.saveBytesMessageState((BytesMessageImpl)messageImpl);
                break;
            }
            case 4: {
                this.body = messageImpl.getTextBody();
                break;
            }
            case 2: {
                this.body = messageImpl.getObjectRaw();
                break;
            }
            case 5: {
                this.body = messageImpl.getFields();
                this.streamOffset = ((StreamMessageImpl)messageImpl).lastField;
                break;
            }
            case 6: {
                this.body = (Serializable)((Object)messageImpl.getNamedFields());
            }
        }
        this.properties = messageImpl.getProperties();
        this.correlationID = messageImpl.getCorrelationID();
        this.messageID = messageImpl.messageId;
        if (this.messageID == null) {
            this.messageID = "ID:" + messageImpl.getMessageID();
        }
        this.priority = messageImpl.getPriority();
        this.timestamp = messageImpl.getTimestamp();
        this.typeField = messageImpl.getJMSTypeField();
        this.replyTopic = messageImpl.getReplyString();
        this.topic = messageImpl.getTopicString();
        this.expiration = messageImpl.expiration;
        this.redelivered = messageImpl.redelivered;
        this.persistent = messageImpl.getPersistent();
    }

    private void saveBytesMessageState(BytesMessageImpl bytesMessageImpl) {
        if (!this.readOnly) {
            byte[] byArray = bytesMessageImpl.baos.toByteArray();
            this.body = byArray;
            this.streamOffset = byArray.length;
        } else if (bytesMessageImpl.bais == null) {
            this.body = bytesMessageImpl.getBytesBody();
            this.streamOffset = 0;
        } else {
            this.body = bytesMessageImpl.body;
            this.streamOffset = bytesMessageImpl.body.length - bytesMessageImpl.bais.available();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        MessageImpl messageImpl = MessageImpl.construct(this.msgType);
        messageImpl.readOnly = this.readOnly;
        messageImpl.propertiesReadOnly = this.propertiesReadOnly;
        switch (this.msgType) {
            case 3: {
                try {
                    this.restoreBytesMessageState((BytesMessageImpl)messageImpl);
                    break;
                }
                catch (IOException iOException) {
                    throw new NotSerializableException(iOException.getMessage());
                }
            }
            case 4: {
                messageImpl.setTextBody((String)((Object)this.body));
                break;
            }
            case 2: {
                messageImpl.setObjectRaw((byte[])this.body);
                break;
            }
            case 5: {
                messageImpl.setFields((Vector)this.body);
                ((StreamMessageImpl)messageImpl).fields = (Vector)this.body;
                ((StreamMessageImpl)messageImpl).lastField = this.streamOffset;
                break;
            }
            case 6: {
                messageImpl.setNamedFields((Dictionary)((Object)this.body));
                ((MapMessageImpl)messageImpl).fields = (Dictionary)((Object)this.body);
            }
        }
        messageImpl.setProperties(this.properties);
        messageImpl.props = this.properties;
        messageImpl.setCorrelationID(this.correlationID);
        messageImpl.messageId = this.messageID;
        messageImpl.setPriority(this.priority);
        messageImpl.setTimestamp(this.timestamp);
        messageImpl.setJMSTypeField(this.typeField);
        messageImpl.setReplyString(this.replyTopic);
        if (this.topic != null) {
            messageImpl.setTopicString(this.topic);
        }
        messageImpl.expiration = this.expiration;
        messageImpl.redelivered = this.redelivered;
        messageImpl.setPersistent(this.persistent);
        return messageImpl;
    }

    private void restoreBytesMessageState(BytesMessageImpl bytesMessageImpl) throws IOException {
        byte[] byArray = (byte[])this.body;
        if (!this.readOnly) {
            bytesMessageImpl.baos = new ByteArrayOutputStream();
            bytesMessageImpl.dos = new DataOutputStream(bytesMessageImpl.baos);
            bytesMessageImpl.dos.write(byArray, 0, this.streamOffset);
        } else {
            bytesMessageImpl.setBytesBody(byArray);
            if (this.streamOffset > 0) {
                bytesMessageImpl.body = byArray;
                bytesMessageImpl.bais = new ByteArrayInputStream(byArray);
                bytesMessageImpl.dis = new DataInputStream(bytesMessageImpl.bais);
                bytesMessageImpl.dis.skipBytes(this.streamOffset);
            }
        }
    }
}

