/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQQueueSender;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.MQTopicSubscriber;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MQTopicSession
extends MQSession
implements TopicSession {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/MQTopicSession.java, jms, j600, j600-101-060328 1.150.1.2 05/07/05 13:08:21";

    MQTopicSession(MQTopicConnection mQTopicConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        super(mQTopicConnection, mQQueueManager, bl, n);
    }

    MQTopicSession(MQQueueManager mQQueueManager, String string, String string2) throws JMSException {
        super(mQQueueManager, string, string2);
    }

    public void commit() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "commit");
            }
            super.commitT();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commit");
            }
        }
    }

    public void rollback() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "rollback");
            }
            super.rollbackT();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "rollback");
            }
        }
    }

    public void recover() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recover");
            }
            super.recoverT();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recover");
            }
        }
    }

    public void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            super.close();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (destination instanceof MQTopic) {
            return this.createSubscriber((Topic)destination);
        }
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string = "MQJMS0003";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (destination instanceof MQTopic) {
            TopicSubscriber topicSubscriber = this.createSubscriber((Topic)destination, string, false);
            return topicSubscriber;
        }
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string2 = "MQJMS0003";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (destination instanceof MQTopic) {
            TopicSubscriber topicSubscriber = this.createSubscriber((Topic)destination, string, bl);
            return topicSubscriber;
        }
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string2 = "MQJMS0003";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
        throw invalidDestinationException;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null || destination instanceof Topic) {
            TopicPublisher topicPublisher = this.createPublisher((Topic)destination);
            return topicPublisher;
        }
        JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
        throw jMSException;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public Queue createQueue(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    MQQueue getQueueForBrowse(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    MQQueue getOutputQueue(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    protected JMSException getQueueOpenException(MQException mQException) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void removeSender(MQQueueSender mQQueueSender) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void checkQueueAccess(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        MQTopicPublisher mQTopicPublisher = super.createTPublisher(topic);
        this.addProducer(mQTopicPublisher);
        return mQTopicPublisher;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        MQTopicSubscriber mQTopicSubscriber = super.createTSubscriber(topic, null, false);
        this.addConsumer(mQTopicSubscriber);
        return mQTopicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        MQTopicSubscriber mQTopicSubscriber = super.createTSubscriber(topic, string, bl);
        this.addConsumer(mQTopicSubscriber);
        return mQTopicSubscriber;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return super.createTemporaryTopic();
    }

    public Topic createTopic(String string) throws JMSException {
        return super.createTopic(string);
    }

    public int getBrokerTimeout() {
        try {
            return super.getBrokerTimeout();
        }
        catch (Exception exception) {
            throw new RuntimeException("MQJMS1016");
        }
    }

    public byte[] getSessionName() {
        return this.sessionName;
    }
}

