/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.MQXid;
import com.ibm.mqservices.Trace;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MQXAResource
implements XAResource {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQXAResource.java, java, j600, j600-101-060328 1.22.1.1 05/05/25 15:38:45";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int nextRMID = 0;
    private String qmgrName;
    private int rmid;
    private MQXAVerbs session = null;
    private boolean debugXA = false;
    private boolean impEndFlag = false;
    private boolean closed = false;

    public MQXAResource(MQXAVerbs mQXAVerbs, String string) throws XAException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(2, this, sccsid);
            }
            this.qmgrName = string;
            this.session = mQXAVerbs;
            this.rmid = MQXAResource.getNextRMID();
            try {
                n = mQXAVerbs.XAOPEN(string, this.rmid, 0);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n != 0) {
                String string2 = MQException.getNLSMsg(113);
                XAException xAException = new XAException(string2);
                xAException.errorCode = n;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    public void finalize() throws Throwable {
        if (this.debugXA) {
            System.out.println(this.toString() + ".finalize()");
        }
        try {
            this.close();
        }
        catch (XAException xAException) {
            // empty catch block
        }
        super.finalize();
    }

    public void close() throws XAException {
        block15: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "close()");
                }
                if (this.debugXA) {
                    System.out.println(this + " close()");
                }
                if (!this.closed) {
                    int n;
                    try {
                        n = this.session.XACLOSE(this.qmgrName, this.rmid, 0);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw (XAException)exception;
                    }
                    if (n != 0) {
                        String string = MQException.getNLSMsg(114);
                        XAException xAException = new XAException(string);
                        xAException.errorCode = n;
                        throw xAException;
                    }
                    this.closed = true;
                    this.session = null;
                    break block15;
                }
                if (this.debugXA) {
                    System.out.println(this + " was already closed");
                }
                Trace.trace(this, " already closed");
            }
            catch (XAException xAException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + xAException);
                    Trace.trace(this, "errorCode=" + xAException.errorCode);
                }
                throw xAException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "close()");
                }
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "prepare()");
                Trace.trace(this, "xid: " + xid);
            }
            if (this.debugXA) {
                System.out.println(this + " prepare(" + xid + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            try {
                n = this.session.XAPREPARE(xid, this.rmid, 0);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n != 0 && n != 3) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n;
                throw xAException;
            }
            int n2 = n;
            return n2;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "prepare()");
            }
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "commit");
                Trace.trace(this, "xid: " + xid);
            }
            if (this.debugXA) {
                System.out.println(this + " commit(" + xid + ", " + bl + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            int n2 = bl ? 0x40000000 : 0;
            try {
                n = this.session.XACOMMIT(xid, this.rmid, n2);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n != 0 && n != 3) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commit");
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "rollback");
                Trace.trace(this, "xid: " + xid);
            }
            if (this.debugXA) {
                System.out.println(this + " rollback(" + xid + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            try {
                n = this.session.XAROLLBACK(xid, this.rmid, 0);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n != 0) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "rollback");
            }
        }
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            int n2;
            if (Trace.isOn) {
                Trace.entry(this, "start");
                Trace.trace(this, "xid: " + xid);
            }
            if (this.debugXA) {
                System.out.println(this + " start(" + xid + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            try {
                n2 = this.session.XASTART(xid, this.rmid, n);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n2 != 0) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n2;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "start");
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            int n2;
            if (Trace.isOn) {
                Trace.entry(this, "end");
                Trace.trace(this, "xid: " + xid);
            }
            if (this.debugXA) {
                System.out.println(this + " end(" + xid + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            try {
                n2 = this.session.XAEND(xid, this.rmid, n);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n2 != 0) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n2;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "end");
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "forget");
            }
            if (this.debugXA) {
                System.out.println(this + " forget(" + xid + ")");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            try {
                n = this.session.XAFORGET(xid, this.rmid, 0);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n != 0) {
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n;
                throw xAException;
            }
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "forget");
            }
        }
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = new MQXid[10];
        try {
            Xid[] xidArray2;
            int n2;
            if (Trace.isOn) {
                Trace.entry(this, "recover");
            }
            if (this.debugXA) {
                System.out.println(this + " recover()");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            boolean bl = this.impEndFlag;
            this.impEndFlag = false;
            try {
                n2 = this.session.XARECOVER(xidArray, this.rmid, n);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (XAException)exception;
            }
            if (n2 < 0) {
                if (bl && n2 == -5 && n == 0) {
                    Xid[] xidArray3 = new MQXid[]{};
                    return xidArray3;
                }
                String string = MQException.getNLSMsg(114);
                XAException xAException = new XAException(string);
                xAException.errorCode = n2;
                throw xAException;
            }
            if (n2 != xidArray.length) {
                xidArray2 = new MQXid[n2];
                System.arraycopy(xidArray, 0, xidArray2, 0, n2);
                if ((n & 0x800000) == 0) {
                    this.impEndFlag = true;
                }
            } else {
                xidArray2 = xidArray;
            }
            Xid[] xidArray4 = xidArray2;
            return xidArray4;
        }
        catch (XAException xAException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
            }
            throw xAException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recover");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isSameRM");
            }
            if (this.debugXA) {
                System.out.println(this + " isSameRM()");
            }
            if (this.closed) {
                String string = MQException.getNLSMsg(115);
                XAException xAException = new XAException(string);
                xAException.errorCode = -6;
                throw xAException;
            }
            if (xAResource instanceof MQXAResource) {
                boolean bl = this.qmgrName.equals(((MQXAResource)xAResource).qmgrName);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isSameRM");
            }
        }
    }

    public void setDebugXA(boolean bl) {
        this.debugXA = bl;
    }

    public String getResourceString() {
        return this.qmgrName;
    }

    static Exception createXAException(int n, String string) {
        XAException xAException = new XAException(string);
        xAException.errorCode = n;
        return xAException;
    }

    private static synchronized int getNextRMID() {
        return nextRMID++;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }
}

