/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivePorts {
    private static final int MAX_PORT = 65535;
    private int[] passivePorts;
    private boolean[] reservedPorts;
    private String passivePortsString;
    private boolean checkIfBound;

    private static int[] parse(String portsString) {
        ArrayList<Integer> passivePortsList = new ArrayList<Integer>();
        boolean inRange = false;
        Integer lastPort = 1;
        StringTokenizer st = new StringTokenizer(portsString, ",;-", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (",".equals(token) || ";".equals(token)) {
                if (inRange) {
                    PassivePorts.fillRange(passivePortsList, lastPort, 65535);
                }
                lastPort = 1;
                inRange = false;
                continue;
            }
            if ("-".equals(token)) {
                inRange = true;
                continue;
            }
            if (token.length() == 0) continue;
            Integer port = Integer.valueOf(token);
            PassivePorts.verifyPort(port);
            if (inRange) {
                PassivePorts.fillRange(passivePortsList, lastPort, port);
                inRange = false;
            }
            PassivePorts.addPort(passivePortsList, port);
            lastPort = port;
        }
        if (inRange) {
            PassivePorts.fillRange(passivePortsList, lastPort, 65535);
        }
        int[] passivePorts = new int[passivePortsList.size()];
        Iterator iter = passivePortsList.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            Integer port = (Integer)iter.next();
            passivePorts[counter] = port;
            ++counter;
        }
        return passivePorts;
    }

    private static void fillRange(List<Integer> passivePortsList, Integer beginPort, Integer endPort) {
        for (int i = beginPort.intValue(); i <= endPort; ++i) {
            PassivePorts.addPort(passivePortsList, i);
        }
    }

    private static void addPort(List<Integer> passivePortsList, Integer rangePort) {
        if (!passivePortsList.contains(rangePort)) {
            passivePortsList.add(rangePort);
        }
    }

    private static void verifyPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Port can not be negative: " + port);
        }
        if (port > 65535) {
            throw new IllegalArgumentException("Port too large: " + port);
        }
    }

    public PassivePorts(String passivePorts, boolean checkIfBound) {
        this(PassivePorts.parse(passivePorts), checkIfBound);
        this.passivePortsString = passivePorts;
    }

    public PassivePorts(int[] passivePorts, boolean checkIfBound) {
        this.passivePorts = (int[])(passivePorts != null ? (int[])passivePorts.clone() : null);
        this.reservedPorts = new boolean[passivePorts.length];
        this.checkIfBound = checkIfBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPortUnbound(int port) {
        if (!this.checkIfBound) {
            return true;
        }
        if (port == 0) {
            return true;
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
    }

    public int reserveNextPort() {
        for (int i = 0; i < this.passivePorts.length; ++i) {
            if (this.reservedPorts[i] || !this.checkPortUnbound(this.passivePorts[i])) continue;
            if (this.passivePorts[i] != 0) {
                this.reservedPorts[i] = true;
            }
            return this.passivePorts[i];
        }
        return -1;
    }

    public void releasePort(int port) {
        for (int i = 0; i < this.passivePorts.length; ++i) {
            if (this.passivePorts[i] != port) continue;
            this.reservedPorts[i] = false;
            break;
        }
    }

    public String toString() {
        if (this.passivePortsString != null) {
            return this.passivePortsString;
        }
        StringBuffer sb = new StringBuffer();
        for (int port : this.passivePorts) {
            sb.append(port);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

