/*
 * E2E technologies Ltd
 * Project:
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * $Id: e2eheader.java,v 1.3 2006/01/18 10:44:45 tzimber Exp $
 */
package ch.e2e.examples.ftpservice;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.BridgeJavaService;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Ftplet;

import java.util.HashMap;

/**
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 *
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public class FtpService implements BridgeJavaService<FtpServerCallback> {
	private FtpServer server;

	public void initialize(FtpServerCallback ftpServerCallback) {
		FtpServerFactory serverFactory = new FtpServerFactory();
		serverFactory.setUserManager(new BridgeUserManager(ftpServerCallback));
		HashMap<String, Ftplet> ftplets = new HashMap<String, Ftplet>();
		FtpServiceCallbackFtplet callbackFtplet = new FtpServiceCallbackFtplet(ftpServerCallback);
		ftplets.put("FtpServiceCallbackFtplet", callbackFtplet);
		serverFactory.setFtplets(ftplets);
		try {
			server = serverFactory.createServer();
			server.start();
		} catch (FtpException e) {
			throw new BridgeException(e);
		}
	}

	public void shutDown() {
		server.stop();
	}

	public static void main(String[] args) {
		FtpServerFactory serverFactory = new FtpServerFactory();
		HashMap<String, Ftplet> ftplets = new HashMap<String, Ftplet>();
		FtpServerCallback callback = new FtpServerCallback() {
			public CallbackReply afterCommand(BridgeUser user, String command, String argument, CallbackReply reply) {
				return new CallbackReply();
			}

			public CallbackReply beforeCommand(BridgeUser user, String command, String argument) {
				return new CallbackReply();
			}

			public CallbackReply onAppendEnd(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onAppendStart(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onConnect(String ipAddress, String hostname, int port) {
				return new CallbackReply();
			}

			public CallbackReply onDisconnect(String ipAddress, String hostname, int port) {
				return new CallbackReply();
			}

			public CallbackReply onDeleteEnd(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onDeleteStart(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onDownloadEnd(BridgeUser user, String downloadFile) {
				return new CallbackReply();
			}

			public CallbackReply onDownloadStart(BridgeUser user, String downloadFile) {
				return new CallbackReply();
			}

			public CallbackReply onLogin(BridgeUser user) {
				return new CallbackReply();
			}

			public CallbackReply onMkdirEnd(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onMkdirStart(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onRenameEnd(BridgeUser user, String renameFrom, String renameTo) {
				return new CallbackReply();
			}

			public CallbackReply onRenameStart(BridgeUser user, String renameFrom, String renameTo) {
				return new CallbackReply();
			}

			public CallbackReply onRmdirEnd(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onRmdirStart(BridgeUser user, String absolutePath) {
				return new CallbackReply();
			}

			public CallbackReply onUploadEnd(BridgeUser user, String uploadFile) {
				return new CallbackReply();
			}

			public CallbackReply onUploadStart(BridgeUser user, String uploadFile) {
				return new CallbackReply();
			}

			// UserManager operation callbacks
			public boolean doesExists(String username) {
				return true;
			}

			public BridgeUser login(String username, String password) {
				BridgeUser user = null;
				if (username.equalsIgnoreCase("admin") && password.equals("admin")) {
					user = new BridgeUser();
					user.setName("admin");
					user.setPassword("admin");
					user.setWritePermission(true);
				}
				return user;
			}
		};
		ftplets.put("MyFtplet", new FtpServiceCallbackFtplet(callback));
//		URL url = ClassLoader.getSystemClassLoader().getResource("ch/e2e/examples/ftpservice/users.properties");
//		PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
//		userManagerFactory.setUrl(url);
//		serverFactory.setUserManager(userManagerFactory.createUserManager());
		serverFactory.setUserManager(new BridgeUserManager(callback));
		serverFactory.setFtplets(ftplets);
		try {
			FtpServer server = serverFactory.createServer();
			server.start();
		} catch (FtpException e) {
			e.printStackTrace();
		}
	}
}
