/*
 * E2E technologies Ltd
 * Project:
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * $Id: e2eheader.java,v 1.3 2006/01/18 10:44:45 tzimber Exp $
 */
package ch.e2e.examples.ftpservice;

import ch.e2e.io.FileUtilities;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftplet.User;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;

/**
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 *
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public class FtpServiceCallbackFtplet extends DefaultFtplet {
	private FtpServerCallback serverCallback;

	public FtpServiceCallbackFtplet(FtpServerCallback serverCallback) {
		this.serverCallback = serverCallback;
	}

	public FtpletResult afterCommand(FtpSession ftpSession, FtpRequest ftpRequest, FtpReply reply) throws FtpException, IOException {
		FtpletResult ftpletResult;
		CallbackReply callbackReply = new CallbackReply();
		callbackReply.setError(reply.getCode());
		callbackReply.setErrorMessage(reply.getMessage());
		callbackReply.setOk(reply.getCode() < 400);
		callbackReply = serverCallback.afterCommand(createCallbackUser(ftpSession), ftpRequest.getCommand(), ftpRequest.getArgument(), callbackReply);
		if (callbackReply.isOk()) {
			ftpletResult = super.afterCommand(ftpSession, ftpRequest, reply);
		} else {
			ftpSession.write(new DefaultFtpReply(callbackReply.getError(), callbackReply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult beforeCommand(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.beforeCommand(createCallbackUser(ftpSession), ftpRequest.getCommand(), ftpRequest.getArgument());
		if (reply.isOk()) {
			ftpletResult = super.beforeCommand(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onAppendEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onAppendEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onAppendEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onAppendStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		FtpletResult ftpletResult;
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		CallbackReply reply = serverCallback.onAppendStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onAppendStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onConnect(FtpSession ftpSession) throws FtpException, IOException {
		FtpletResult ftpletResult;
		InetSocketAddress client = ftpSession.getClientAddress();
		CallbackReply reply = serverCallback.onConnect(client.getAddress().getHostAddress(), client.getHostName(), client.getPort());
		if (reply.isOk()) {
			ftpletResult = super.onConnect(ftpSession);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onDisconnect(FtpSession ftpSession) throws FtpException, IOException {
		FtpletResult ftpletResult;
		InetSocketAddress client = ftpSession.getClientAddress();
		CallbackReply reply = serverCallback.onDisconnect(client.getAddress().getHostAddress(), client.getHostName(), client.getPort());
		if (reply.isOk()) {
			ftpletResult = super.onConnect(ftpSession);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onDownloadEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onDownloadEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onDownloadEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onDownloadStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onDownloadStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onDownloadStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onDeleteEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onDeleteEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onDeleteEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onDeleteStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onDeleteStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onDeleteStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onLogin(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onLogin(createCallbackUser(ftpSession));
		if (reply.isOk()) {
			ftpletResult = super.onLogin(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onMkdirEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onMkdirEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onMkdirEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onMkdirStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onMkdirStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onMkdirStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onRenameEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File renameFrom = createFile(ftpSession.getRenameFrom().getName(), ftpSession);
		File renameTo = getRequestedFile(ftpSession, ftpRequest);
		CallbackReply reply = serverCallback.onRenameEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(renameFrom), FileUtilities.getAbsolutePath(renameTo));
		FtpletResult ftpletResult;
		if (reply.isOk()) {
			ftpletResult = super.onRenameEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onRenameStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File renameFrom = createFile(ftpSession.getRenameFrom().getName(), ftpSession);
		File renameTo = getRequestedFile(ftpSession, ftpRequest);
		CallbackReply reply = serverCallback.onRenameStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(renameFrom), FileUtilities.getAbsolutePath(renameTo));
		FtpletResult ftpletResult;
		if (reply.isOk()) {
			ftpletResult = super.onRenameStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onRmdirEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onRmdirEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onRmdirEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onRmdirStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onRmdirStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onRmdirStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onUploadEnd(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onUploadEnd(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onUploadEnd(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	public FtpletResult onUploadStart(FtpSession ftpSession, FtpRequest ftpRequest) throws FtpException, IOException {
		File requestedFile = getRequestedFile(ftpSession, ftpRequest);
		FtpletResult ftpletResult;
		CallbackReply reply = serverCallback.onUploadStart(createCallbackUser(ftpSession), FileUtilities.getAbsolutePath(requestedFile));
		if (reply.isOk()) {
			ftpletResult = super.onUploadStart(ftpSession, ftpRequest);
		} else {
			ftpSession.write(new DefaultFtpReply(reply.getError(), reply.getErrorMessage()));
			ftpletResult = FtpletResult.SKIP;
		}
		return ftpletResult;
	}

	private BridgeUser createCallbackUser(FtpSession ftpSession) {
		User user = ftpSession.getUser();
		BridgeUser result = new BridgeUser();
		if (user != null) {
			result.setName(user.getName());
			result.setPassword(user.getPassword());
			result.setHomeDirectory(user.getHomeDirectory());
			result.setMaxIdleTime(user.getMaxIdleTime());
			result.setEnabled(user.getEnabled());
		}
		return result;
	}

	private File getRequestedFile(FtpSession ftpSession, FtpRequest ftpRequest) {
		String filename = ftpRequest.getArgument();
		return createFile(filename, ftpSession);
	}

	private File createFile(String filename, FtpSession ftpSession) {
		String home = ftpSession.getUser().getHomeDirectory();
		File homeDirectory = new File(home);
		return new File(homeDirectory, filename);
	}
}
