import {Component, Input, OnInit} from '@angular/core';
import {AbstractFormComponent, PasForm} from '@pas/app-core';
import {FormControl, FormGroup} from '@angular/forms';
import {MyForm} from './my-form.interface';

@PasForm({
    name: 'MyForm',
    events: [
        'submit'
    ]
})
@Component({
    templateUrl: './my-form.component.html'
})
export class MyFormComponent extends AbstractFormComponent<MyForm> implements OnInit {
    @Input() override formGroup: FormGroup  = new FormGroup({});
    constructor() {
        super();
    }

    test_form_rootProperties = {
        columns: 3,
        rows: 3
      };
  
      FormTextBoxProperties = {
        label: 'FormTextBox',
        readonly: false,
        mandatory: false,
        cssClass: '',
        verticalAlign: 0,
        placeholder: 'Input text here',
        regex: '',
        validationNote: 'Your input is invalid',
        maxLength: 0
    };
  
    FormTextBoxFormControl = new FormControl(
        ''
    );
  
    FormButtonProperties = {
        label: 'Submit',
        readonly: false,
        cssClass: '',
        verticalAlign: 0,
        primary: false
    };
  
    FormButtonFormControl = new FormControl(
        false
    );
  
    FormLabelProperties = {
        label: 'MyForm',
        cssClass: '',
        verticalAlign: 0,
        format: {
            htmlTag: 'h3',
            cssStyle: {
                bold: false,
                italic: false,
                underline: false,
                color: '#707270',
                alignment: '2',
                fontSize: 'unset',
                fontFamily: 'unset'
            }
        }
    };

    ngOnInit(): void {
        if (this.formGroup == null) {
            this.formGroup = new FormGroup({});
        }
  
        this.formGroup.addControl('someTextField', this.FormTextBoxFormControl);
        this.formGroup.addControl('FormButton', this.FormButtonFormControl);

        if(this.data) {
          this.formGroup.patchValue(this.data);
        }
    }

    submit(): void {
        this.formEvent.emit({
            key: 'submit',
            data: ''
        });
    }
}
