


Ext.define('JsonExemple.controller.Users', {
    extend: 'Ext.app.Controller',
	
	stores: [
        'Users'
    ],
	
	
    models: ['User'],
	
	views: [
		'MainPanel',
		'AddWindow',
		'EditWindow'
	],

    init: function() {
        
		
		
		
		this.control({
			'#UsersGridPanel' : {
				itemdblclick: this.showEditWindow
			},
			'#AddButton': {
				click: this.showAddWindow
			},
			'#DeleteButton': {
				click: this.deleteRecord
			}
		});
		
		
    },
	
	showAddWindow: function(button){
	
	
		this.addWindow = Ext.widget('addwindow',{modal: true});
				
		this.control({
			'#AddWindow #AddAddButton' : {
				click: this.addUser
			},
			'#AddWindow #CancelButton': {
				click: this.cancelAdd
			}
		});
		
		
		this.addWindow.show();
	},
	
	showEditWindow: function(grid, record) {
		this.editWindow = Ext.widget('editwindow',{modal: true});
		
		var form = this.editWindow.down("#EditForm").getForm();
		
		form.loadRecord(record);	
		
		
		this.control({
            '#EditWindow #EditButton': {
                click: this.updateUser
            }
        });
		
		
		this.editWindow.show();
    },
	
	updateUser: function(button) {
		var win    = button.up('window'),
			form   = win.down('form'),
			record = form.getRecord(),
			values = form.getValues();

		record.set(values);
		this.getUsersStore().sync();
		
		win.close();
	},
	
	addUser: function(button){
		if(this.addWindow){
		
			var form = this.addWindow.down("#AddForm");
			var user = new JsonExemple.model.User(form.getValues());
					
			this.getUsersStore().add(user);			
			this.getUsersStore().sync();		
			
			this.addWindow.close();
		}
	},
	
	cancelAdd: function(button){
		if(this.addWindow){
			this.addWindow.close();
		}
	},
	
	deleteRecord: function(button){
		var main = button.up('#MainPanel');
		var grid = main.down('#UsersGridPanel');
		var users = grid.getSelectionModel( ).getSelection();
		var usersStore = this.getUsersStore();
		
		Ext.each(users, function (user) {
			usersStore.remove(user);
			
		});
		
		usersStore.sync();
	}
	
});

