#!/usr/bin/perl -w

use Getopt::Std;

# -i ARG, -o ARG -e ARG, sets $args{i}, $args{o}
getopt("ioe", \%args);

my $i = $args{i};
my $o = $args{o};
my $e = $args{e};


open (INFILE, $i) || die "cannot open $i for reading: $!";

while (<INFILE>) {      # read a line from file $i into $_  # like "while(defined($_ = <INFILE>)) {"
	$input = $input.$_;
}

close(INFILE) || die "can't close  $i: $!";

open (OUTFILE1, ">$o") || die "cannot create $o: $!";
print OUTFILE1 ("Input copied to Output1 by Perl: $input");

open (OUTFILE2, ">$e") || die "cannot create $e: $!";
print OUTFILE2 ("Input copied to Output2 by Perl: $input");


close(OUTFILE1) || die "can't close  $o: $!";
close(OUTFILE2) || die "can't close  $o: $!";
