/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.multicast.PeerId;
import com.ibm.disthub2.impl.util.FastHashtable;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.SubscriptionInfoImpl;
import java.util.Enumeration;

public class MulticastConnectionReceiver {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MulticastConnectionReceiver.java, disthub, j600, j600-101-060328 1.6.1.2 05/06/27 17:19:31";
    private PeerId peerId = null;
    private ConnectionImpl connection;
    private FastVector multicastTopics;
    private FastHashtable matches;

    public MulticastConnectionReceiver(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.multicastTopics = new FastVector();
        this.matches = new FastHashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopics(SubscriptionInfoImpl subscriptionInfoImpl) {
        Enumeration enumeration = subscriptionInfoImpl.multicastTopics.elements();
        while (enumeration.hasMoreElements()) {
            MulticastTopic multicastTopic = (MulticastTopic)enumeration.nextElement();
            if (!this.multicastTopics.contains((Object)multicastTopic)) {
                // empty if block
            }
            this.multicastTopics.addElement((Object)multicastTopic);
            FastVector fastVector = null;
            if (this.matches.containsKey((Object)multicastTopic.topic)) {
                fastVector = (FastVector)this.matches.get((Object)multicastTopic.topic);
            } else {
                fastVector = new FastVector();
                this.matches.put((Object)multicastTopic.topic, (Object)fastVector);
            }
            if (fastVector.indexOf((Object)multicastTopic) >= 0) continue;
            FastVector fastVector2 = fastVector;
            synchronized (fastVector2) {
                fastVector.addElement((Object)multicastTopic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTopic(SubscriptionInfoImpl subscriptionInfoImpl, MulticastTopic multicastTopic) {
        if (this.multicastTopics.contains((Object)multicastTopic)) {
            this.multicastTopics.removeElementAt(this.multicastTopics.indexOf((Object)multicastTopic));
            if (this.multicastTopics.indexOf((Object)multicastTopic) < 1) {
                // empty if block
            }
        }
        if (this.matches.containsKey((Object)multicastTopic.topic)) {
            FastVector fastVector;
            FastVector fastVector2 = fastVector = (FastVector)this.matches.get((Object)multicastTopic.topic);
            synchronized (fastVector2) {
                if (fastVector.indexOf((Object)multicastTopic) > -1) {
                    fastVector.removeElementAt(fastVector.indexOf((Object)multicastTopic));
                }
            }
        }
    }

    public void deregisterAllTopics(SubscriptionInfoImpl subscriptionInfoImpl) {
        Enumeration enumeration = subscriptionInfoImpl.multicastTopics.elements();
        while (enumeration.hasMoreElements()) {
            MulticastTopic multicastTopic = (MulticastTopic)enumeration.nextElement();
            this.deregisterTopic(subscriptionInfoImpl, multicastTopic);
        }
    }

    public void updateTopic(MulticastTopic multicastTopic) {
        if (this.multicastTopics.contains((Object)multicastTopic)) {
            MulticastTopic multicastTopic2 = (MulticastTopic)this.multicastTopics.elementAt(this.multicastTopics.indexOf((Object)multicastTopic));
            multicastTopic2.timeStamp = multicastTopic.timeStamp;
            multicastTopic2.key = multicastTopic.key;
        }
    }

    public void sendControlMessage(byte[] byArray) {
    }
}

