/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQException;
import com.ibm.mq.MQInternalCommunications;
import com.ibm.mq.PeerName;
import com.ibm.mq.SSLCRLHelper;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class SSLHelper
implements HandshakeCompletedListener {
    public static final String CLSNAME = "SSLHelper";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/SSLHelper.java, java, j600, j600-101-060328 1.29.1.6 06/01/06 08:51:59";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    X509Certificate serverCert = null;
    boolean certSet = false;
    static X509Certificate[] certs;

    static Socket createSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, MQInternalCommunications mQInternalCommunications) throws MQException {
        try {
            if (Trace.isOn()) {
                Trace.entry(CLSNAME, "createSSLSocket");
                Trace.trace(CLSNAME, "peername = '" + string3 + "'");
                Trace.trace(CLSNAME, "certStores = " + collection);
                Trace.trace(CLSNAME, "sslSocketFactory = " + object);
            }
            SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "creating SSL socket");
            }
            SSLSocket sSLSocket = SSLHelper.createSSLSocketInstance(string, n, sSLSocketFactory, false, null, 0);
            boolean bl = MQInternalCommunications.inFipsMode;
            mQInternalCommunications.channelDefinition.sslPeerName = SSLHelper.configureSSLSocket(sSLSocket, string2, string3, collection, bl);
            SSLSocket sSLSocket2 = sSLSocket;
            return sSLSocket2;
        }
        catch (BindException bindException) {
            throw new MQException(2, 2059, "static method in SSL code", 54, string);
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(CLSNAME, "createSSLSocket");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocket createSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, Socket socket, boolean bl, boolean bl2) throws MQException {
        try {
            SSLSocket sSLSocket;
            if (Trace.isOn()) {
                Trace.entry(CLSNAME, "createSSLSocket");
                Trace.trace(CLSNAME, "peername = '" + string3 + "'");
                Trace.trace(CLSNAME, "certStores = " + collection);
                Trace.trace(CLSNAME, "sslSocketFactory = " + object);
                Trace.trace(CLSNAME, "clientAuth = " + bl);
                Trace.trace(CLSNAME, "asServer = " + bl2);
            }
            SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "creating SSL socket from non-SSL one");
            }
            try {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, false);
            }
            catch (IOException iOException) {
                MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 71);
                mQException.initCause(iOException);
                throw mQException;
            }
            sSLSocket.setNeedClientAuth(bl);
            sSLSocket.setUseClientMode(!bl2);
            boolean bl3 = MQInternalCommunications.inFipsMode;
            SSLHelper.configureSSLSocket(sSLSocket, string2, string3, collection, bl3);
            SSLSocket sSLSocket2 = sSLSocket;
            return sSLSocket2;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(CLSNAME, "createSSLSocket");
            }
        }
    }

    static Socket createExplicitSSLSocket(String string, int n, String string2, String string3, Collection collection, Object object, MQInternalCommunications mQInternalCommunications, InetAddress inetAddress, int n2, int n3, int n4) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(CLSNAME, "createExplicitSSLSocket");
        }
        SSLSocketFactory sSLSocketFactory = SSLHelper.chooseSocketFactory(object);
        for (int i = 0; i <= n3 - n2; ++i) {
            try {
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "Try to create SSL socket bound locally to " + inetAddress + ", port " + n4);
                }
                FWHelper.debug("Try to create SSL socket bound locally to " + inetAddress + ", port " + n4);
                SSLSocket sSLSocket = SSLHelper.createSSLSocketInstance(string, n, sSLSocketFactory, true, inetAddress, n4);
                if (sSLSocket != null) {
                    String string4 = "SSLSocket created OK: " + inetAddress + ", local port " + sSLSocket.getLocalPort();
                    if (Trace.isOn()) {
                        Trace.trace(2, CLSNAME, string4);
                    }
                    FWHelper.debug(string4);
                    boolean bl = MQInternalCommunications.inFipsMode;
                    mQInternalCommunications.channelDefinition.sslPeerName = SSLHelper.configureSSLSocket(sSLSocket, string2, string3, collection, bl);
                } else {
                    String string5 = "SSLSocket create failed - null returned.";
                    if (Trace.isOn()) {
                        Trace.trace(2, CLSNAME, string5);
                    }
                }
                if (Trace.isOn()) {
                    Trace.exit(CLSNAME, "createExplicitSSLSocket (success)");
                }
                return sSLSocket;
            }
            catch (BindException bindException) {
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "Socket created failed due to bind exception (see below): " + inetAddress + ", port " + n4);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, CLSNAME, "BindException: " + bindException.getMessage());
                }
                FWHelper.debug("BindException: " + inetAddress + ", port " + n4);
                if (++n4 <= n3) continue;
                n4 = n2;
                continue;
            }
        }
        FWHelper.debug("Failed to create socket matching firewall properties.");
        MQInternalException mQInternalException = new MQInternalException(2, 2059, 125);
        if (Trace.isOn()) {
            Trace.exit(CLSNAME, "createExplicitSSLSocket (failed)");
        }
        throw mQInternalException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SSLSocketFactory chooseSocketFactory(Object object) throws MQException {
        SSLSocketFactory sSLSocketFactory = null;
        if (MQInternalCommunications.inFipsMode.booleanValue()) {
            if (Trace.isOn) {
                Trace.trace(2, CLSNAME, "FIPS mode has been selected");
            }
            System.setProperty("com.ibm.jsse2.JSSEFIPS", "true");
            try {
                Class.forName("com.ibm.jsse2.IBMJSSEProvider2");
                Package package_ = Package.getPackage("com.ibm.jsse2");
                String string = package_.getImplementationVersion();
                int n = string.indexOf("_");
                String string2 = null;
                if (n != -1) {
                    string2 = string.substring(n + 1);
                }
                int n2 = 0;
                if (string2 != null && !string2.equals("")) {
                    n2 = Integer.parseInt(string2);
                }
                if (Trace.isOn) {
                    Trace.trace(2, CLSNAME, "JSSE VERSION: " + n2);
                }
                if (n2 >= 20041026) {
                    if (Trace.isOn) {
                        Trace.trace(2, CLSNAME, "SR1a or greater available");
                    }
                    Class<?> clazz = Class.forName("com.ibm.crypto.fips.provider.IBMJCEFIPS");
                    Provider provider = (Provider)clazz.newInstance();
                    Security.insertProviderAt(provider, 1);
                    clazz = Class.forName("com.ibm.jsse2.SSLSocketFactoryImpl");
                    sSLSocketFactory = (SSLSocketFactory)clazz.newInstance();
                    if (!Trace.isOn) return sSLSocketFactory;
                    Trace.trace(2, CLSNAME, "Using JSSE2 for FIPS");
                    return sSLSocketFactory;
                }
                if (Trace.isOn) {
                    Trace.trace(2, CLSNAME, "1.4.2 or lower available");
                }
                try {
                    Class<?> clazz = Class.forName("com.ibm.fips.jsse.JSSESocketFactory");
                    sSLSocketFactory = (SSLSocketFactory)clazz.newInstance();
                    if (!Trace.isOn) return sSLSocketFactory;
                    Trace.trace(2, CLSNAME, "Using old JSSE for FIPS");
                    return sSLSocketFactory;
                }
                catch (Exception exception) {
                    if (!Trace.isOn) throw new MQException(2, 2393, CLSNAME);
                    Trace.trace(2, CLSNAME, "JVM does not contain a FIPS compliant JSSE");
                    throw new MQException(2, 2393, CLSNAME);
                }
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.trace(2, CLSNAME, "1.4.2 or lower available");
                }
                try {
                    Class<?> clazz = Class.forName("com.ibm.fips.jsse.JSSESocketFactory");
                    sSLSocketFactory = (SSLSocketFactory)clazz.newInstance();
                    if (!Trace.isOn) return sSLSocketFactory;
                    Trace.trace(2, CLSNAME, "Using old JSSE for FIPS");
                    return sSLSocketFactory;
                }
                catch (Exception exception2) {
                    if (!Trace.isOn) throw new MQException(2, 2393, CLSNAME);
                    Trace.trace(2, CLSNAME, "JVM does not contain a FIPS compliant JSSE");
                    throw new MQException(2, 2393, CLSNAME);
                }
            }
        } else {
            if (object == null) {
                if (!Trace.isOn()) return (SSLSocketFactory)SSLSocketFactory.getDefault();
                Trace.trace(2, CLSNAME, "using default SSLSocketFactory");
                return (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            if (!(object instanceof SSLSocketFactory)) throw new MQException(2, 2046, Thread.currentThread(), 120, "sslSocketFactory");
            if (!Trace.isOn()) return (SSLSocketFactory)object;
            Trace.trace(2, CLSNAME, "using supplied SSLSocketFactory");
            return (SSLSocketFactory)object;
        }
    }

    private static SSLSocket createSSLSocketInstance(String string, int n, SSLSocketFactory sSLSocketFactory, boolean bl, InetAddress inetAddress, int n2) throws MQException, BindException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = !bl ? (SSLSocket)sSLSocketFactory.createSocket(string, n) : (SSLSocket)sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        catch (SSLProtocolException sSLProtocolException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 52);
            mQException.initCause(sSLProtocolException);
            throw mQException;
        }
        catch (SSLException sSLException) {
            MQException mQException = new MQException(2, 2397, "static method in SSL code.");
            mQException.initCause(sSLException);
            throw mQException;
        }
        catch (UnknownHostException unknownHostException) {
            throw new MQException(2, 2059, "static method in SSL code", 53, string);
        }
        catch (BindException bindException) {
            if (bl) {
                throw bindException;
            }
            throw new MQException(2, 2059, "static method in SSL code", 54, string);
        }
        catch (IOException iOException) {
            throw new MQException(2, 2059, "static method in SSL code", 54, string);
        }
        return sSLSocket;
    }

    private static String configureSSLSocket(SSLSocket sSLSocket, String string, String string2, Collection collection, boolean bl) throws MQException {
        Object object;
        Object object2;
        if (Trace.isOn()) {
            Trace.trace(CLSNAME, "setting enabled cipher suites to '" + string + "'");
        }
        String[] stringArray = new String[]{string};
        try {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MQException(2, 2400, (Object)"static method in SSL code", 52);
        }
        String string3 = string.substring(0, 3);
        String[] stringArray2 = new String[1];
        if (bl || string3.equals("TLS")) {
            stringArray2[0] = "TLSv1";
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Setting protocol to TLSv1");
            }
        } else {
            stringArray2[0] = "SSLv3";
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "Setting protocol to SSLv3");
            }
        }
        if (Trace.isOn) {
            object2 = sSLSocket.getSupportedProtocols();
            object = new String();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = (String)object + (String)object2[i] + ", ";
            }
            Trace.trace(CLSNAME, "Supported Protocols are " + (String)object);
        }
        sSLSocket.setEnabledProtocols(stringArray2);
        object2 = new SSLHelper();
        sSLSocket.addHandshakeCompletedListener((HandshakeCompletedListener)object2);
        if (Trace.isOn()) {
            Trace.trace(CLSNAME, "calling startHandshake");
        }
        try {
            sSLSocket.startHandshake();
        }
        catch (SSLException sSLException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 98);
            mQException.initCause(sSLException);
            throw mQException;
        }
        catch (IOException iOException) {
            MQException mQException = new MQException(2, 2397, (Object)"static method in SSL code", 71);
            mQException.initCause(iOException);
            throw mQException;
        }
        object = super.getServerCert();
        Principal principal = ((X509Certificate)object).getSubjectDN();
        String string4 = principal.getName();
        if (string2 != null && !string2.equals("")) {
            PeerName peerName;
            PeerName peerName2;
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "checking peername");
            }
            if ((peerName2 = new PeerName(string2, true)).isMatchingPeerName(peerName = new PeerName(string4, false))) {
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "peerName matches");
                }
            } else {
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "peerName " + peerName2.getDN() + " doesn't match " + peerName.getDN());
                }
                try {
                    sSLSocket.close();
                }
                catch (IOException iOException) {
                    throw new MQException(2, 2059, (Object)"static method in SSL code", 54);
                }
                throw new MQException(2, 2398, "static method in SSL code", 121, peerName2.getDN(), peerName.getDN());
            }
        }
        if (collection != null) {
            SSLCRLHelper.check(certs[0], collection);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "handshakeCompleted");
                Trace.trace(this, "event: " + handshakeCompletedEvent);
            }
            if ((certs = handshakeCompletedEvent.getPeerCertificateChain()) != null && certs.length > 0) {
                this.setServerCert(certs[0]);
                String string = certs[0].getIssuerDN().getName();
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "Remote peer name = " + certs[0].getSubjectDN());
                    Trace.trace(CLSNAME, "Remote issuer    = " + certs[0].getIssuerDN());
                }
            } else {
                if (Trace.isOn()) {
                    Trace.trace(this, "no peer certificates");
                }
                this.setServerCert(null);
            }
        }
        catch (Exception exception) {
            if (Trace.isOn()) {
                Trace.trace(this, "problem: " + exception);
            }
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "handshakeCompleted");
            }
        }
    }

    private synchronized void setServerCert(X509Certificate x509Certificate) {
        this.serverCert = x509Certificate;
        this.certSet = true;
        this.notifyAll();
    }

    private synchronized X509Certificate getServerCert() {
        while (!this.certSet) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.serverCert;
    }

    public static void renegotiateKey(SSLSocket sSLSocket) throws MQException {
        try {
            SSLSession sSLSession = sSLSocket.getSession();
            sSLSession.invalidate();
            sSLSocket.startHandshake();
        }
        catch (SSLException sSLException) {
            MQException mQException = new MQException(2, 2397, (Object)"static renegotiation method in SSL code", 98);
            mQException.initCause(sSLException);
            throw mQException;
        }
        catch (IOException iOException) {
            MQException mQException = new MQException(2, 2397, (Object)"static renegotiation method in SSL code", 71);
            mQException.initCause(iOException);
            throw mQException;
        }
    }

    static String translate(String string, int n) {
        String string2 = "";
        if (string != null) {
            String[][] stringArrayArray = new String[][]{{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA"}, {"DES_SHA_EXPORT", "DES_SHA_EXPORT1024", "NULL_MD5", "NULL_SHA", "RC2_MD5_EXPORT", "RC4_56_SHA_EXPORT1024", "RC4_MD5_US", "RC4_MD5_EXPORT", "RC4_SHA_US", "TRIPLE_DES_SHA_US", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "FIPS_WITH_DES_CBC_SHA", "FIPS_WITH_3DES_EDE_CBC_SHA"}};
            String[] stringArray = stringArrayArray[1];
            String[] stringArray2 = stringArrayArray[0];
            if (n == 0) {
                stringArray = stringArrayArray[0];
                stringArray2 = stringArrayArray[1];
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                string2 = stringArray2[i];
                break;
            }
        }
        return string2;
    }
}

