/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APCLS
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APCLS.java, jms, j600, j600-101-060328 1.7.1.1 05/05/25 15:54:51";
    private static final String CLASSNAME = "APCLS";
    public static final String LONGNAME = "CLONESUPP";
    public static final String SHORTNAME = "CLS";
    public static final String CLONE_ENABLED = "ENABLED";
    public static final String CLONE_DISABLED = "DISABLED";

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block13: {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = APCLS.getProperty(SHORTNAME, hashtable)) == null) break block13;
                int n = APCLS.objToInt(object2);
                if (object instanceof MQTopicConnectionFactory || object instanceof MQConnectionFactory) {
                    try {
                        ((MQConnectionFactory)object).setCloneSupport(n);
                        break block13;
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                        throw bAOException;
                    }
                }
                String string = "object supplied as an unexpected type " + object.getClass();
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            catch (BAOException bAOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + bAOException);
                }
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQTopicConnectionFactory) && !(object instanceof MQConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQConnectionFactory)object).getCloneSupport();
            String string = APCLS.valToString(n);
            hashtable.put(LONGNAME, string);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(CLONE_ENABLED)) {
            n = 1;
        } else if (string2.equals(CLONE_DISABLED)) {
            n = 0;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    public static String valToString(int n) throws JMSException {
        String string;
        if (n == 1) {
            string = CLONE_ENABLED;
        } else if (n == 0) {
            string = CLONE_DISABLED;
        } else {
            String string2 = "broker version unexpected value " + n;
            String string3 = "MQJMS1016";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
            JMSException jMSException = new JMSException(string4, string3);
            throw jMSException;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int objToInt(Object object) throws BAOException, JMSException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "objToInt");
            }
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof String) {
                String string = (String)object;
                n = APCLS.stringToVal(string);
            } else {
                String string = "value supplied as an unexpected object type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "objToInt");
            }
        }
    }
}

