/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.Logger;
import com.ibm.disthub2.impl.util.ExceptionWrapper;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.SessionImpl;

public class SessionDispatcher
implements Runnable,
ClientLogConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SessionDispatcher.java, disthub, j600, j600-101-060328 1.16.1.1 05/05/25 15:44:11";
    private static final DebugObject debug = new DebugObject("SessionDispatcher");
    private SessionImpl session;
    private MessageQueue messageQueue;
    private volatile boolean alive = true;
    private boolean stopped = true;
    private Thread dispatchThread = null;

    SessionDispatcher(MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"SessionDispatcher", (Object)messageQueue);
        }
        this.messageQueue = messageQueue;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"SessionDispatcher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"run");
        }
        while (this.alive) {
            try {
                MessageQueue messageQueue;
                Object var7_8;
                Object var1_1 = null;
                MessageImpl messageImpl = null;
                boolean bl = false;
                MessageQueue messageQueue2 = this.messageQueue;
                synchronized (messageQueue2) {
                    messageImpl = this.messageQueue.dequeue();
                    if (messageImpl == null) {
                        break;
                    }
                    this.dispatchThread = Thread.currentThread();
                }
                try {
                    try {
                        messageImpl.dispatch();
                    }
                    catch (RuntimeException runtimeException) {
                        if (Logger.logIt((long)613844851112205L)) {
                            Logger.log((long)613844851112205L, (String)"SessionDispatcher.run", (Object)new ExceptionWrapper((Throwable)runtimeException));
                        }
                        var7_8 = null;
                        messageQueue = this.messageQueue;
                        synchronized (messageQueue) {
                            this.dispatchThread = null;
                            this.messageQueue.notifyAll();
                            continue;
                        }
                    }
                    var7_8 = null;
                    messageQueue = this.messageQueue;
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    messageQueue = this.messageQueue;
                    synchronized (messageQueue) {
                        this.dispatchThread = null;
                        this.messageQueue.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (messageQueue) {
                    this.dispatchThread = null;
                    this.messageQueue.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (JMSWrappedException jMSWrappedException) {
                // empty catch block
                break;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"run");
        }
    }

    public void close(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)exception, (Object)new Boolean(bl));
        }
        this.alive = false;
        if (this.messageQueue != null) {
            this.messageQueue.close(exception, bl);
        }
        this.messageQueue = null;
        this.session = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        MessageQueue messageQueue = this.messageQueue;
        synchronized (messageQueue) {
            this.stopped = true;
            this.messageQueue.stop();
            while (this.dispatchThread != null && this.dispatchThread != Thread.currentThread()) {
                try {
                    this.messageQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        MessageQueue messageQueue = this.messageQueue;
        synchronized (messageQueue) {
            this.stopped = false;
            this.messageQueue.start();
            this.messageQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
    }
}

