/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQCrlInformation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class MQChannelHeader {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQChannelHeader.java, jms, j600, j600-101-060328 1.17.1.1 05/05/25 15:58:50";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String qmName;
    private long offset;
    private String shortConName;
    private long maxMsgL;
    private static byte[] Key = new byte[]{-33, 92, -12, 35, 66, -11, 106, 46};
    public static String crlKey = "{000SSL_CRL_DATA000}";
    private static byte[] IP = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    private static byte[] IP_1 = new byte[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
    private static byte[][] KS = new byte[16][48];
    private static byte[] PC_1C = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36};
    private static byte[] PC_1D = new byte[]{62, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static byte[] PC_2C = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2};
    private static byte[] PC_2D = new byte[]{41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static byte[] Shifts = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    private static byte[] E = new byte[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
    private static int[] P = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    private static byte[][][] S = new byte[][][]{new byte[][]{{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7}, {0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8}, {4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0}, {15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13}}, new byte[][]{{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10}, {3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5}, {0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15}, {13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9}}, new byte[][]{{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8}, {13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1}, {13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7}, {1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12}}, new byte[][]{{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15}, {13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9}, {10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4}, {3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14}}, new byte[][]{{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9}, {14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6}, {4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14}, {11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3}}, new byte[][]{{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11}, {10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8}, {9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6}, {4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13}}, new byte[][]{{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1}, {13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6}, {1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2}, {6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12}}, new byte[][]{{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7}, {1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2}, {7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8}, {2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11}}};

    public MQChannelHeader(String string, long l, String string2, long l2) {
        this.qmName = string;
        this.offset = l;
        this.shortConName = string2;
        this.maxMsgL = l2;
    }

    public static SortedMap prepareURL(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        long l = 4L;
        long l2 = 0L;
        long l3 = 0L;
        String string = MQChannelHeader.stringRead(inputStream, 0L, 4L);
        TreeMap<String, Object> treeMap = null;
        if (string.equals("AMQR")) {
            treeMap = new TreeMap<String, Object>();
            while (true) {
                int n = 0;
                l2 = MQChannelHeader.longRead(inputStream, 0L);
                n += 4;
                if (l2 <= 0L) break;
                l3 = MQChannelHeader.longRead(inputStream, 0L);
                n += 4;
                if (l3 == 0L) {
                    MQChannelHeader.stringRead(inputStream, l2 - 8L, 0L);
                } else {
                    long l4;
                    String string2 = MQChannelHeader.stringRead(inputStream, 12L, 20L).trim();
                    n += 32;
                    if (string2.equals(crlKey)) {
                        Vector<MQCrlInformation> vector = new Vector<MQCrlInformation>();
                        MQCrlInformation mQCrlInformation = null;
                        long l5 = MQChannelHeader.longRead(inputStream, 0L);
                        n += 4;
                        if (l5 == 3L) {
                            l4 = MQChannelHeader.longRead(inputStream, 1612L);
                            n += 1616;
                            String string3 = null;
                            String string4 = null;
                            String string5 = null;
                            byte[] byArray = null;
                            long l6 = 0L;
                            while (l6 + 4L < l4) {
                                long l7 = MQChannelHeader.longRead(inputStream, 0L);
                                n += 4;
                                if ((l6 += 4L) + l7 > l4) break;
                                string3 = MQChannelHeader.stringRead(inputStream, 0L, l7);
                                n = (int)((long)n + l7);
                                if ((l6 += l7) + 12L > l4) break;
                                l7 = MQChannelHeader.longRead(inputStream, 8L);
                                n += 12;
                                if ((l6 += 12L) + l7 > l4) break;
                                byArray = MQChannelHeader.bytesRead(inputStream, 0L, l7);
                                if (byArray != null) {
                                    byArray = MQChannelHeader.restoreData(byArray);
                                    string4 = new String(byArray);
                                }
                                n = (int)((long)n + l7);
                                if ((l6 += l7) + 4L > l4) break;
                                l7 = MQChannelHeader.longRead(inputStream, 0L);
                                n += 4;
                                if ((l6 += 4L) + l7 > l4) break;
                                byArray = MQChannelHeader.bytesRead(inputStream, 0L, l7);
                                if (byArray != null) {
                                    byArray = MQChannelHeader.restoreData(byArray);
                                    string5 = new String(byArray);
                                }
                                l6 += l7;
                                n = (int)((long)n + l7);
                                mQCrlInformation = new MQCrlInformation(string3, string4, string5);
                                vector.add(mQCrlInformation);
                            }
                            if (l6 < l4) {
                                MQChannelHeader.stringRead(inputStream, 0L, l4 - l6);
                            }
                            if (!vector.isEmpty()) {
                                treeMap.put(crlKey, vector);
                            }
                            n = (int)((long)n + (l4 - l6));
                            MQChannelHeader.stringRead(inputStream, l2 - (long)n, 0L);
                        }
                    } else {
                        long l8 = MQChannelHeader.longRead(inputStream, 8L);
                        if (l8 == 2L) {
                            String string6 = MQChannelHeader.stringRead(inputStream, 64L, 48L).trim();
                            String string7 = MQChannelHeader.stringRead(inputStream, 48L, 20L).trim();
                            l4 = 0x400000L;
                            l4 = MQChannelHeader.longRead(inputStream, 632L);
                            treeMap.put(string2, new MQChannelHeader(string6, l, string7, l4));
                            MQChannelHeader.stringRead(inputStream, l2 - 868L, 0L);
                        } else {
                            MQChannelHeader.stringRead(inputStream, l2 - 52L, 0L);
                        }
                    }
                }
                l += l2;
            }
        }
        inputStream.close();
        return treeMap;
    }

    public static long longRead(InputStream inputStream, long l) throws IOException {
        long l2;
        byte[] byArray = new byte[4];
        while (l > 0L) {
            l2 = inputStream.skip(l);
            l -= l2;
        }
        l2 = inputStream.read(byArray);
        if (l2 < 4L) {
            return 0L;
        }
        return MQChannelHeader.unsign(byArray, 0) + MQChannelHeader.unsign(byArray, 1) * 256L + MQChannelHeader.unsign(byArray, 2) * 65536L + MQChannelHeader.unsign(byArray, 3) * 0x1000000L;
    }

    public static byte[] bytesRead(InputStream inputStream, long l, long l2) throws IOException {
        long l3;
        while (l > 0L) {
            l3 = inputStream.skip(l);
            l -= l3;
        }
        if (l2 <= 0L) {
            return null;
        }
        byte[] byArray = new byte[(int)l2];
        l3 = inputStream.read(byArray);
        if (l3 < l2) {
            return null;
        }
        return byArray;
    }

    public static String stringRead(InputStream inputStream, long l, long l2) throws IOException {
        long l3;
        while (l > 0L) {
            l3 = inputStream.skip(l);
            l -= l3;
        }
        if (l2 <= 0L) {
            return null;
        }
        byte[] byArray = new byte[(int)l2];
        l3 = inputStream.read(byArray);
        if (l3 < l2) {
            return null;
        }
        return new String(byArray);
    }

    private static long unsign(byte[] byArray, int n) {
        long l = byArray[n];
        if (l < 0L) {
            l += 256L;
        }
        return l;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getQmName() {
        return this.qmName;
    }

    public String getShortConName() {
        return this.shortConName;
    }

    private static byte[] restoreData(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n = byArray.length;
        if (n % 8 == 0) {
            byArray3 = new byte[n];
            for (int i = 0; i < n; i += 8) {
                int n2;
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray2[n2] = byArray[i + n2];
                }
                byArray4 = MQChannelHeader.Decrypt(Key, byArray2);
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray3[i + n2] = byArray4[n2];
                }
            }
        }
        return byArray3;
    }

    private static byte[] Decrypt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = MQChannelHeader.convByteToBit(byArray);
        MQChannelHeader.KeySchedule(byArray3);
        byArray3 = MQChannelHeader.convByteToBit(byArray2);
        byte[] byArray4 = MQChannelHeader.Decipher(byArray3);
        return MQChannelHeader.convBitToByte(byArray4);
    }

    static byte[] Decipher(byte[] byArray) {
        int n;
        int n2;
        byte[] byArray2 = new byte[64];
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = null;
        int[] nArray = new int[32];
        for (n2 = 0; n2 < 64; ++n2) {
            byArray3[n2] = byArray[IP[n2] - 1];
        }
        for (n = 0; n < 32; ++n) {
            byArray4[n] = byArray3[n + 32];
            byArray5[n] = byArray3[n];
        }
        for (n2 = 15; n2 >= 0; --n2) {
            byArray6 = MQChannelHeader.f(byArray4, KS[n2]);
            for (n = 0; n < 32; ++n) {
                byArray3[n] = (byte)(byArray5[n] ^ byArray6[n]);
                byArray3[n + 32] = byArray4[n];
            }
            for (n = 0; n < 32; ++n) {
                byArray4[n] = byArray3[n];
                byArray5[n] = byArray3[n + 32];
            }
            for (n = 0; n < 32; ++n) {
                byArray3[n] = byArray4[n];
                byArray3[n + 32] = byArray5[n];
            }
        }
        for (n2 = 0; n2 < 64; ++n2) {
            byArray2[n2] = byArray3[IP_1[n2] - 1];
        }
        return byArray2;
    }

    static byte[] KeySchedule(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[28];
        byte[] byArray3 = new byte[28];
        for (n = 0; n < 28; ++n) {
            byArray2[n] = byArray[PC_1C[n] - 1];
            byArray3[n] = byArray[PC_1D[n] - 1];
        }
        for (n = 0; n < 16; ++n) {
            int n2;
            for (n2 = 0; n2 < Shifts[n]; ++n2) {
                byte by = byArray2[0];
                byte by2 = byArray3[0];
                for (int i = 0; i < 27; ++i) {
                    byArray2[i] = byArray2[i + 1];
                    byArray3[i] = byArray3[i + 1];
                }
                byArray2[27] = by;
                byArray3[27] = by2;
            }
            for (n2 = 0; n2 < 24; ++n2) {
                MQChannelHeader.KS[n][n2] = byArray2[PC_2C[n2] - 1];
                MQChannelHeader.KS[n][n2 + 24] = byArray3[PC_2D[n2] - 28 - 1];
            }
        }
        return byArray;
    }

    static byte[] f(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = new byte[48];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        for (n = 0; n < 48; ++n) {
            byArray3[n] = (byte)(byArray[E[n] - 1] ^ byArray2[n]);
        }
        for (n = 0; n < 8; ++n) {
            int n2 = n * 6;
            int n3 = byArray3[n2] * 2 + byArray3[n2 + 5];
            int n4 = byArray3[n2 + 1] * 8 + byArray3[n2 + 2] * 4 + byArray3[n2 + 3] * 2 + byArray3[n2 + 4];
            int n5 = n * 4;
            byte by = S[n][n3][n4];
            byArray4[n5] = (by & 8) > 0 ? (byte)1 : 0;
            byArray4[n5 + 1] = (by & 4) > 0 ? (byte)1 : 0;
            byArray4[n5 + 2] = (by & 2) > 0 ? (byte)1 : 0;
            byArray4[n5 + 3] = (by & 1) > 0 ? (byte)1 : 0;
        }
        for (n = 0; n < 32; ++n) {
            byArray5[n] = byArray4[P[n] - 1];
        }
        return byArray5;
    }

    private static byte[] convByteToBit(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        for (int i = 0; i < 64; i += 8) {
            int n = byArray[i / 8];
            if (n < 0) {
                n += 256;
            }
            int n2 = 0;
            int n3 = 128;
            while (n2 < 8) {
                if ((n & n3) > 0) {
                    byArray2[i + n2] = 1;
                }
                ++n2;
                n3 /= 2;
            }
        }
        return byArray2;
    }

    private static byte[] convBitToByte(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[8];
        for (n = 0; n < 8; ++n) {
            int n2 = n * 8;
            byArray2[n] = (byte)(byArray[n2] << 7 | byArray[n2 + 1] << 6 | byArray[n2 + 2] << 5 | byArray[n2 + 3] << 4 | byArray[n2 + 4] << 3 | byArray[n2 + 5] << 2 | byArray[n2 + 6] << 1 | byArray[n2 + 7]);
        }
        return byArray2;
    }

    public long getMaxMessageLength() {
        return this.maxMsgL;
    }
}

