/*
 * e2e technologies Ltd.
 * Project: JavaAddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Numbers.java,v 1.1 2008/11/15 10:50:18 tzimber Exp $
 */
package ch.e2e.examples.simple;

import java.util.Arrays;

/**
 * Shows you how to handle with numbers in the E2E Bridge.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the method:<br>
 * <ul>
 * <code><li><a href="#squareRoot(double)">public double squareRoot(double value)</a></li></code>
 * <code><li><a href="#max(int, int)">public max max(int value1, int value2)</a></li></code>
 * <code><li><a href="#toHex(int)">public String toHex(int value)</a></li></code>
 * <code><li><a href="#isGreater(int, int)">public boolean isGreater(int value1, int value2)</a></li></code>
 * <code><li><a href="#sortAscending(double[])">public double[] sortAscending(double[] values)</a></li></code>
 * <code><li><a href="#sortDescending(double[])">public double[] sortDescending(double[] values)</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Numbers {
	/**
	 * Returns the correctly rounded positive square root of a <code>double</code> value.
	 * @param value a value.
	 * @return the positive square root of a. If the argument is NaN or less than zero, the result is NaN.
	 */
	public static double squareRoot(double value) {
		return Math.sqrt(value);
	}

	/**
	 * Returns the greater of two int values.
	 * @param value1 an argument.
	 * @param value2 another argument.
	 * @return the larger of value1 and value2.
	 */
	public static int max(int value1, int value2) {
		return Math.max(value1, value2);
	}

	/**
	 * Returns a string representation of the integer argument as an unsigned integer in base 16.
	 * @param value an integer to be converted to a string.
	 * @return the string representation of the unsigned integer value represented by the argument in hexadecimal (base 16).
	 */
	public static String toHex(int value) {
		return Integer.toHexString(value).toUpperCase();
	}

	/**
	 * Returns <code>true</code> if value1 is larger then value2.
	 * @param value1
	 * @param value2
	 * @return <code>true</code> if value1 is larger then value2.
	 */
	public static boolean isGreater(int value1, int value2) {
		return value1 > value2;
	}

	/**
	 * Sorts the given values in descending order.
	 * @param values The values to sort.
	 * @return the sorted values.
	 */
	public static double[] sortDescending(double[] values) {
		Arrays.sort(values);
		double[] result = new double[values.length];
		int i;
		int j;
		for (i = 0, j = values.length - 1; i < values.length; i++, j--) {
			result[i] = values[j];
		}
		return result;
	}

	/**
	 * Sorts the given values in ascending order.
	 * @param values The values to sort.
	 * @return the sorted values.
	 */
	public static double[] sortAscending(double[] values) {
		Arrays.sort(values);
		return values;
	}
}
