/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.impl.PassivePorts;
import org.apache.ftpserver.ssl.SslConfiguration;

public class DefaultDataConnectionConfiguration
implements DataConnectionConfiguration {
    private int idleTime;
    private SslConfiguration ssl;
    private boolean activeEnabled;
    private String activeLocalAddress;
    private int activeLocalPort;
    private boolean activeIpCheck;
    private String passiveAddress;
    private String passiveExternalAddress;
    private PassivePorts passivePorts;
    private final boolean implicitSsl;

    public DefaultDataConnectionConfiguration(int idleTime, SslConfiguration ssl, boolean activeEnabled, boolean activeIpCheck, String activeLocalAddress, int activeLocalPort, String passiveAddress, PassivePorts passivePorts, String passiveExternalAddress, boolean implicitSsl) {
        this.idleTime = idleTime;
        this.ssl = ssl;
        this.activeEnabled = activeEnabled;
        this.activeIpCheck = activeIpCheck;
        this.activeLocalAddress = activeLocalAddress;
        this.activeLocalPort = activeLocalPort;
        this.passiveAddress = passiveAddress;
        this.passivePorts = passivePorts;
        this.passiveExternalAddress = passiveExternalAddress;
        this.implicitSsl = implicitSsl;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public boolean isActiveEnabled() {
        return this.activeEnabled;
    }

    public boolean isActiveIpCheck() {
        return this.activeIpCheck;
    }

    public String getActiveLocalAddress() {
        return this.activeLocalAddress;
    }

    public int getActiveLocalPort() {
        return this.activeLocalPort;
    }

    public String getPassiveAddress() {
        return this.passiveAddress;
    }

    public String getPassiveExernalAddress() {
        return this.passiveExternalAddress;
    }

    public synchronized int requestPassivePort() {
        int dataPort = -1;
        int loopTimes = 2;
        Thread currThread = Thread.currentThread();
        while (dataPort == -1 && --loopTimes >= 0 && !currThread.isInterrupted()) {
            dataPort = this.passivePorts.reserveNextPort();
            if (dataPort != -1) continue;
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        return dataPort;
    }

    public String getPassivePorts() {
        return this.passivePorts.toString();
    }

    public synchronized void releasePassivePort(int port) {
        this.passivePorts.releasePort(port);
        this.notify();
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }
}

