/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.util.HashMap;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.impl.OPTS_MLST;
import org.apache.ftpserver.command.impl.OPTS_UTF8;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPTS
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(OPTS.class);
    private static final HashMap<String, Command> COMMAND_MAP = new HashMap(16);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String argument = request.getArgument();
        if (argument == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "OPTS", null));
            return;
        }
        int spaceIndex = argument.indexOf(32);
        if (spaceIndex != -1) {
            argument = argument.substring(0, spaceIndex);
        }
        argument = argument.toUpperCase();
        String optsRequest = "OPTS_" + argument;
        Command command = COMMAND_MAP.get(optsRequest);
        try {
            if (command != null) {
                command.execute(session, context, request);
            } else {
                session.resetState();
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 502, "OPTS.not.implemented", argument));
            }
        }
        catch (Exception ex) {
            this.LOG.warn("OPTS.execute()", (Throwable)ex);
            session.resetState();
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 500, "OPTS", null));
        }
    }

    static {
        COMMAND_MAP.put("OPTS_MLST", new OPTS_MLST());
        COMMAND_MAP.put("OPTS_UTF8", new OPTS_UTF8());
    }
}

