/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUser
implements User {
    private String name = null;
    private String password = null;
    private int maxIdleTimeSec = 0;
    private String homeDir = null;
    private boolean isEnabled = true;
    private List<Authority> authorities = new ArrayList<Authority>();

    public BaseUser() {
    }

    public BaseUser(User user) {
        this.name = user.getName();
        this.password = user.getPassword();
        this.authorities = user.getAuthorities();
        this.maxIdleTimeSec = user.getMaxIdleTime();
        this.homeDir = user.getHomeDirectory();
        this.isEnabled = user.getEnabled();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public List<Authority> getAuthorities() {
        if (this.authorities != null) {
            return Collections.unmodifiableList(this.authorities);
        }
        return null;
    }

    public void setAuthorities(List<Authority> authorities) {
        this.authorities = authorities != null ? Collections.unmodifiableList(authorities) : null;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTimeSec;
    }

    public void setMaxIdleTime(int idleSec) {
        this.maxIdleTimeSec = idleSec;
        if (this.maxIdleTimeSec < 0) {
            this.maxIdleTimeSec = 0;
        }
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enb) {
        this.isEnabled = enb;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    public void setHomeDirectory(String home) {
        this.homeDir = home;
    }

    public String toString() {
        return this.name;
    }

    public AuthorizationRequest authorize(AuthorizationRequest request) {
        if (this.authorities == null) {
            return null;
        }
        boolean someoneCouldAuthorize = false;
        for (Authority authority : this.authorities) {
            if (!authority.canAuthorize(request)) continue;
            someoneCouldAuthorize = true;
            if ((request = authority.authorize(request)) != null) continue;
            return null;
        }
        if (someoneCouldAuthorize) {
            return request;
        }
        return null;
    }

    public List<Authority> getAuthorities(Class<? extends Authority> clazz) {
        ArrayList<Authority> selected = new ArrayList<Authority>();
        for (Authority authority : this.authorities) {
            if (!authority.getClass().equals(clazz)) continue;
            selected.add(authority);
        }
        return selected;
    }
}

