/*
 * E2E technologies Ltd
 * Project:
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * $Id: e2eheader.java,v 1.3 2006/01/18 10:44:45 tzimber Exp $
 */
package ch.e2e.examples.ftpservice;

import ch.e2e.bridge.server.BridgeJavaCallback;

/**
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 *
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public interface FtpServerCallback extends BridgeJavaCallback {
	public CallbackReply afterCommand(BridgeUser user, String command, String argument, CallbackReply reply);
	public CallbackReply beforeCommand(BridgeUser user, String command, String argument);
	public CallbackReply onAppendEnd(BridgeUser user, String absolutePath);
	public CallbackReply onAppendStart(BridgeUser user, String absolutePath);
	public CallbackReply onConnect(String ipAddress, String hostname, int port);
	public CallbackReply onDisconnect(String ipAddress, String hostname, int port);
	public CallbackReply onDeleteEnd(BridgeUser user, String absolutePath);
	public CallbackReply onDeleteStart(BridgeUser user, String absolutePath);
	public CallbackReply onDownloadEnd(BridgeUser user, String downloadFile);
	public CallbackReply onDownloadStart(BridgeUser user, String downloadFile);
	public CallbackReply onLogin(BridgeUser user);
	public CallbackReply onMkdirEnd(BridgeUser user, String absolutePath);
	public CallbackReply onMkdirStart(BridgeUser user, String absolutePath);
	public CallbackReply onRenameEnd(BridgeUser user, String renameFrom, String renameTo);
	public CallbackReply onRenameStart(BridgeUser user, String renameFrom, String renameTo);
	public CallbackReply onRmdirEnd(BridgeUser user, String absolutePath);
	public CallbackReply onRmdirStart(BridgeUser user, String absolutePath);
	public CallbackReply onUploadEnd(BridgeUser user, String uploadFile);
	public CallbackReply onUploadStart(BridgeUser user, String uploadFile);
	// UserManager operation callbacks
	public boolean doesExists(String username);
	public BridgeUser login(String username, String password);
}
