/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.examples.service;

import ch.e2e.bridge.server.BridgeJavaService;
import ch.e2e.bridge.server.BridgeJavaServiceStartStopInterface;

import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.JTextField;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;

public class HelloWorldService implements BridgeJavaService<HelloWorldCallback>, BridgeJavaServiceStartStopInterface {
	private JFrame callbackFrame;
	private boolean sendText;
    private HelloWorldCallback callback;

    /**
     * initialize service, should not access other components or may cause race conditions
     * @param callback parameter with one or more member functions having an activity diagram
     */
    @Override
	public void initialize(final HelloWorldCallback callback) {
        this.callback = callback;
    }

    /**
     * start serving requests. From this point on all components can be freely accessed
     */
    @Override
    public void start() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                callbackFrame = new JFrame("BridgeJavaCallback Window");
                final JTextField textField = new JTextField();
                JButton sendButton = new JButton("Send to bridge");
                sendButton.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        callback.sendText(textField.getText());
                    }
                });
                callbackFrame.getContentPane().add(textField, BorderLayout.NORTH);
                callbackFrame.getContentPane().add(sendButton, BorderLayout.SOUTH);
                callbackFrame.setSize(400, 200);
                callbackFrame.setVisible(true);
                callbackFrame.toFront();
            }
        });
    }

    /**
     * stop accepting new requests
     */
    @Override
	public void shutDown() {
		callbackFrame.setVisible(false);
		callbackFrame.dispose();
	}

    /**
     * wait for active requests to finish and do some necessary cleanup
     */
    @Override
    public void stop() {

    }
}
