/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.config.spring.SpringUtil;
import org.apache.ftpserver.message.MessageResource;
import org.apache.ftpserver.message.MessageResourceFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<? extends FtpServer> getBeanClass(Element element) {
        return null;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder factoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(FtpServerFactory.class);
        List<Element> childs = SpringUtil.getChildElements(element);
        for (Element childElm : childs) {
            String childName = childElm.getLocalName();
            if ("listeners".equals(childName)) {
                Map listeners = this.parseListeners(childElm, parserContext, builder);
                if (listeners.size() <= 0) continue;
                factoryBuilder.addPropertyValue("listeners", (Object)listeners);
                continue;
            }
            if ("ftplets".equals(childName)) {
                Map ftplets = this.parseFtplets(childElm, parserContext, builder);
                factoryBuilder.addPropertyValue("ftplets", (Object)ftplets);
                continue;
            }
            if ("file-user-manager".equals(childName) || "db-user-manager".equals(childName)) {
                BeanDefinition userManager = parserContext.getDelegate().parseCustomElement(childElm, (BeanDefinition)builder.getBeanDefinition());
                factoryBuilder.addPropertyValue("userManager", (Object)userManager);
                continue;
            }
            if ("user-manager".equals(childName)) {
                factoryBuilder.addPropertyValue("userManager", SpringUtil.parseSpringChildElement(childElm, parserContext, builder));
                continue;
            }
            if ("native-filesystem".equals(childName)) {
                BeanDefinition fileSystem = parserContext.getDelegate().parseCustomElement(childElm, (BeanDefinition)builder.getBeanDefinition());
                factoryBuilder.addPropertyValue("fileSystem", (Object)fileSystem);
                continue;
            }
            if ("filesystem".equals(childName)) {
                factoryBuilder.addPropertyValue("fileSystem", SpringUtil.parseSpringChildElement(childElm, parserContext, builder));
                continue;
            }
            if ("commands".equals(childName)) {
                BeanDefinition commandFactory = parserContext.getDelegate().parseCustomElement(childElm, (BeanDefinition)builder.getBeanDefinition());
                factoryBuilder.addPropertyValue("commandFactory", (Object)commandFactory);
                continue;
            }
            if ("messages".equals(childName)) {
                MessageResource mr = this.parseMessageResource(childElm, parserContext, builder);
                factoryBuilder.addPropertyValue("messageResource", (Object)mr);
                continue;
            }
            throw new FtpServerConfigurationException("Unknown configuration name: " + childName);
        }
        ConnectionConfigFactory connectionConfig = new ConnectionConfigFactory();
        if (StringUtils.hasText((String)element.getAttribute("max-logins"))) {
            connectionConfig.setMaxLogins(SpringUtil.parseInt(element, "max-logins"));
        }
        if (StringUtils.hasText((String)element.getAttribute("max-anon-logins"))) {
            connectionConfig.setMaxAnonymousLogins(SpringUtil.parseInt(element, "max-anon-logins"));
        }
        if (StringUtils.hasText((String)element.getAttribute("anon-enabled"))) {
            connectionConfig.setAnonymousLoginEnabled(SpringUtil.parseBoolean(element, "anon-enabled", true));
        }
        if (StringUtils.hasText((String)element.getAttribute("max-login-failures"))) {
            connectionConfig.setMaxLoginFailures(SpringUtil.parseInt(element, "max-login-failures"));
        }
        if (StringUtils.hasText((String)element.getAttribute("login-failure-delay"))) {
            connectionConfig.setLoginFailureDelay(SpringUtil.parseInt(element, "login-failure-delay"));
        }
        factoryBuilder.addPropertyValue("connectionConfig", (Object)connectionConfig.createConnectionConfig());
        AbstractBeanDefinition factoryDefinition = factoryBuilder.getBeanDefinition();
        String factoryName = parserContext.getReaderContext().generateBeanName((BeanDefinition)factoryDefinition);
        BeanDefinitionHolder factoryHolder = new BeanDefinitionHolder((BeanDefinition)factoryDefinition, factoryName);
        this.registerBeanDefinition(factoryHolder, parserContext.getRegistry());
        builder.getRawBeanDefinition().setFactoryBeanName(factoryName);
        builder.getRawBeanDefinition().setFactoryMethodName("createServer");
    }

    private MessageResource parseMessageResource(Element childElm, ParserContext parserContext, BeanDefinitionBuilder builder) {
        MessageResourceFactory mr = new MessageResourceFactory();
        if (StringUtils.hasText((String)childElm.getAttribute("languages"))) {
            String langString = childElm.getAttribute("languages");
            String[] languages = langString.split("[\\s,]+");
            mr.setLanguages(Arrays.asList(languages));
        }
        if (StringUtils.hasText((String)childElm.getAttribute("directory"))) {
            mr.setCustomMessageDirectory(new File(childElm.getAttribute("directory")));
        }
        return mr.createMessageResource();
    }

    private Map parseFtplets(Element childElm, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Element> childs = SpringUtil.getChildElements(childElm);
        if (childs.size() > 0 && childs.get(0).getLocalName().equals("map")) {
            return parserContext.getDelegate().parseMapElement(childs.get(0), (BeanDefinition)builder.getBeanDefinition());
        }
        ManagedMap ftplets = new ManagedMap();
        for (Element ftpletElm : childs) {
            ftplets.put((Object)ftpletElm.getAttribute("name"), SpringUtil.parseSpringChildElement(ftpletElm, parserContext, builder));
        }
        return ftplets;
    }

    private Map parseListeners(Element listenersElm, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap listeners = new ManagedMap();
        List<Element> childs = SpringUtil.getChildElements(listenersElm);
        for (Element listenerElm : childs) {
            Object listener = null;
            String ln = listenerElm.getLocalName();
            if ("nio-listener".equals(ln)) {
                listener = parserContext.getDelegate().parseCustomElement(listenerElm, (BeanDefinition)builder.getBeanDefinition());
            } else if ("listener".equals(ln)) {
                listener = SpringUtil.parseSpringChildElement(listenerElm, parserContext, builder);
            } else {
                throw new FtpServerConfigurationException("Unknown listener element " + ln);
            }
            String name = listenerElm.getAttribute("name");
            listeners.put((Object)name, listener);
        }
        return listeners;
    }
}

