/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.util.HashMap;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.impl.SITE_DESCUSER;
import org.apache.ftpserver.command.impl.SITE_HELP;
import org.apache.ftpserver.command.impl.SITE_STAT;
import org.apache.ftpserver.command.impl.SITE_WHO;
import org.apache.ftpserver.command.impl.SITE_ZONE;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SITE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(SITE.class);
    private static final HashMap<String, Command> COMMAND_MAP = new HashMap(16);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        String argument = request.getArgument();
        if (argument != null) {
            int spaceIndex = argument.indexOf(32);
            if (spaceIndex != -1) {
                argument = argument.substring(0, spaceIndex);
            }
            argument = argument.toUpperCase();
        }
        if (argument == null) {
            session.resetState();
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 200, "SITE", null));
            return;
        }
        String siteRequest = "SITE_" + argument;
        Command command = COMMAND_MAP.get(siteRequest);
        try {
            if (command != null) {
                command.execute(session, context, request);
            } else {
                session.resetState();
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 502, "SITE", argument));
            }
        }
        catch (Exception ex) {
            this.LOG.warn("SITE.execute()", (Throwable)ex);
            session.resetState();
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 500, "SITE", null));
        }
    }

    static {
        COMMAND_MAP.put("SITE_DESCUSER", new SITE_DESCUSER());
        COMMAND_MAP.put("SITE_HELP", new SITE_HELP());
        COMMAND_MAP.put("SITE_STAT", new SITE_STAT());
        COMMAND_MAP.put("SITE_WHO", new SITE_WHO());
        COMMAND_MAP.put("SITE_ZONE", new SITE_ZONE());
    }
}

