/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramSession
extends NioSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("nio", "datagram", true, false, InetSocketAddress.class, DatagramSessionConfig.class, IoBuffer.class);
    private final IoService service;
    private final DatagramSessionConfig config;
    private final IoFilterChain filterChain = new DefaultIoFilterChain(this);
    private final DatagramChannel ch;
    private final IoHandler handler;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final IoProcessor<NioSession> processor;
    private SelectionKey key;

    NioDatagramSession(IoService service, DatagramChannel ch, IoProcessor<NioSession> processor, SocketAddress remoteAddress) {
        this.service = service;
        this.ch = ch;
        this.config = new NioDatagramSessionConfig(ch);
        this.handler = service.getHandler();
        this.processor = processor;
        this.remoteAddress = (InetSocketAddress)remoteAddress;
        this.localAddress = (InetSocketAddress)ch.socket().getLocalSocketAddress();
    }

    NioDatagramSession(IoService service, DatagramChannel ch, IoProcessor<NioSession> processor) {
        this(service, ch, processor, ch.socket().getRemoteSocketAddress());
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    @Override
    public IoProcessor<NioSession> getProcessor() {
        return this.processor;
    }

    @Override
    public DatagramSessionConfig getConfig() {
        return this.config;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    DatagramChannel getChannel() {
        return this.ch;
    }

    @Override
    SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getServiceAddress() {
        return (InetSocketAddress)super.getServiceAddress();
    }
}

