/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Serializer.java,v 1.1 2008/12/01 11:13:14 tzimber Exp $
 */
package ch.e2e.examples.blob;

import java.io.ObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

/**
 *
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Serializer {
	public static SerializedObject serialize(SerializableObject object) {
		SerializedObject result = new SerializedObject();
		ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
		try {
			ObjectOutputStream out = new ObjectOutputStream(byteStream);
			out.writeObject(object);
			byte[] bytes = byteStream.toByteArray();
			Byte[] byteArray = new Byte[bytes.length];
			for (int i = 0; i < bytes.length; i++) {
				byteArray[i] = bytes[i];
			}
			result.setSerializedStream(new ByteArrayInputStream(bytes));
			result.setSerializedByteArray(byteArray);
			result.setSerializedBytes(bytes);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		return result;
	}

	public static SerializableObject createObject(byte[] bytes) {
		SerializableObject result;
		try {
			ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
			ObjectInputStream in = new ObjectInputStream(bytesIn);
			result = (SerializableObject)in.readObject();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}

	public static SerializableObject createObject(Byte[] byteArray) {
		SerializableObject result;
		try {
			byte[] bytes = new byte[byteArray.length];
			for (int i = 0; i < bytes.length; i++) {
				bytes[i] = byteArray[i];
			}
			ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
			ObjectInputStream in = new ObjectInputStream(bytesIn);
			result = (SerializableObject)in.readObject();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}

	public static SerializableObject createObject(ByteArrayInputStream bytesIn) {
		SerializableObject result;
		try {
			ObjectInputStream in = new ObjectInputStream(bytesIn);
			result = (SerializableObject)in.readObject();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}
}
