/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Vector;
import javax.jms.JMSException;

public class MQSubAdmin {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQSubAdmin.java, jms, j600, j600-101-060328 1.29.1.1 05/05/25 15:58:50";
    private MQQueue adminQueue = null;
    private int dbSize = -1;

    public MQSubAdmin(MQQueueManager mQQueueManager) throws JMSException {
        int n = 0;
        block7: while (true) {
            try {
                this.adminQueue = mQQueueManager.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", 60);
            }
            catch (MQException mQException) {
                switch (mQException.reasonCode) {
                    case 2042: {
                        if (++n < 20) {
                            if (Trace.isOn) {
                                Trace.trace(this, "admin queue locked, suppressing exception and retrying");
                            }
                            try {
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block7;
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.trace(this, "Obtaining the admin queue lock required " + n + " retries");
        }
        this.dbSize = this.getNumRecords();
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    void clearAll() {
        if (Trace.isOn) {
            Trace.entry(this, "clearAll");
        }
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        boolean bl = true;
        while (bl) {
            try {
                MQMessage mQMessage = new MQMessage();
                this.adminQueue.get(mQMessage, mQGetMessageOptions);
            }
            catch (MQException mQException) {
                bl = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "clearAll");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            if (this.adminQueue != null) {
                this.adminQueue.close();
                this.adminQueue = null;
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + mQException);
                Trace.exit(this, "close");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    int getNumRecords() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getNumRecords");
        }
        int n = -1;
        try {
            n = this.adminQueue.getCurrentDepth();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2011");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "getNumRecords");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getNumRecords");
        }
        return n;
    }

    public Vector getAll() {
        if (Trace.isOn) {
            Trace.entry(this, "getAll");
        }
        Vector<MQSubEntry> vector = new Vector<MQSubEntry>();
        MQSubEntry mQSubEntry = null;
        Object var3_3 = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 16;
        boolean bl = true;
        while (bl) {
            try {
                MQMessage mQMessage = new MQMessage();
                this.adminQueue.get(mQMessage, mQGetMessageOptions);
                mQSubEntry = new MQSubEntry(mQMessage);
                vector.addElement(mQSubEntry);
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                bl = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAll");
        }
        return vector;
    }

    boolean contains(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "contains");
        }
        if (Trace.isOn) {
            Trace.exit(this, "contains");
        }
        return this.get(string) != null;
    }

    MQSubEntry get(String string) throws JMSException {
        return this.get(string, null, null, false);
    }

    MQSubEntry get(String string, byte[] byArray, byte[] byArray2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "get");
        }
        MQSubEntry mQSubEntry = null;
        MQSubEntry mQSubEntry2 = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = bl ? 32 : 16;
        boolean bl2 = true;
        while (bl2) {
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                }
                if (byArray2 != null) {
                    mQMessage.correlationId = byArray2;
                }
                this.adminQueue.get(mQMessage, mQGetMessageOptions);
                mQSubEntry = new MQSubEntry(mQMessage);
                if (string == null && mQSubEntry.isValid()) {
                    mQSubEntry2 = mQSubEntry;
                    bl2 = false;
                    continue;
                }
                if (string != null && mQSubEntry.isValid() && mQSubEntry.getName().equals(string)) {
                    mQSubEntry2 = mQSubEntry;
                    bl2 = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                bl2 = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "get");
        }
        return mQSubEntry2;
    }

    MQSubEntry getResolved(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, String string, byte[] byArray, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getResolved");
        }
        MQSubEntry mQSubEntry = null;
        MQSubEntry mQSubEntry2 = null;
        mQSubEntry = this.get(string, null, byArray, bl);
        if (mQSubEntry != null && mQSubEntry.getVersion() > 1) {
            if (Trace.isOn) {
                Trace.trace(this, "Matching subscriber found. Checking for a second record.");
            }
            mQSubEntry2 = this.get(null, mQSubEntry.getSubscriberId(), null, true);
        }
        if (mQSubEntry2 != null) {
            if (Trace.isOn) {
                Trace.trace(this, "Second record found: earlier problem must have occurred.");
            }
            if (this.get(null, mQSubEntry.getSubscriberId(), null, false) == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "getResolved ERROR: couldn't reset browse cursor position");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
                throw jMSException;
            }
            if (mQSubEntry.getSubscriberState() == 't' || mQSubEntry2.getSubscriberState() == 't') {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry);
                this.remove(mQSubEntry);
                this.remove(mQSubEntry2);
                if (byArray != null) {
                    mQSubEntry.setSubscriberState('i');
                } else {
                    mQSubEntry = null;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier re-create or close.");
                }
                MQSubEntry mQSubEntry3 = mQSubEntry;
                mQSubEntry.setSubscriberState('i');
                mQSubEntry.setStatusMgrId(MQC.MQCI_NONE);
                this.remove(mQSubEntry);
                this.add(mQSubEntry3, false);
                this.remove(mQSubEntry2);
                mQSubEntry = mQSubEntry3;
            }
        } else if (mQSubEntry != null && mQSubEntry.getSubscriberState() == 't') {
            block21: {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                try {
                    SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block21;
                    Trace.trace(this, "cleanup ERROR: deleteSubscriber encountered error " + (Object)((Object)jMSException));
                }
            }
            this.remove(mQSubEntry);
            if (byArray != null) {
                mQSubEntry.setSubscriberState('i');
            } else {
                mQSubEntry = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getResolved");
        }
        return mQSubEntry;
    }

    public MQSubEntry remove(MQSubEntry mQSubEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "remove");
        }
        MQSubEntry mQSubEntry2 = null;
        MQSubEntry mQSubEntry3 = null;
        byte[] byArray = mQSubEntry.getSubscriberId();
        String string = mQSubEntry.getName();
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        if (byArray == null) {
            mQGetMessageOptions.options = 16;
        }
        boolean bl = true;
        while (bl) {
            Object object;
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                }
                this.adminQueue.get(mQMessage, mQGetMessageOptions);
                mQSubEntry2 = new MQSubEntry(mQMessage);
                if (byArray != null) {
                    mQSubEntry3 = mQSubEntry2;
                    bl = false;
                    continue;
                }
                if (mQSubEntry2.isValid() && mQSubEntry2.getName().equals(string)) {
                    mQSubEntry3 = mQSubEntry2;
                    mQGetMessageOptions.options = 256;
                    object = new MQMessage();
                    this.adminQueue.get((MQMessage)object, mQGetMessageOptions);
                    bl = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                object = ConfigEnvironment.newException("MQJMS3013");
                object.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "In remove() - cannot remove msg!");
                }
                throw object;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "remove");
        }
        return mQSubEntry3;
    }

    public boolean removeByQueueName(String string) {
        boolean bl = false;
        MQSubEntry mQSubEntry = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 16;
        boolean bl2 = true;
        while (bl2) {
            try {
                MQMessage mQMessage = new MQMessage();
                this.adminQueue.get(mQMessage, mQGetMessageOptions);
                mQSubEntry = new MQSubEntry(mQMessage);
                if (mQSubEntry.isValid() && mQSubEntry.getQName().trim().equals(string)) {
                    mQGetMessageOptions.options = 256;
                    MQMessage mQMessage2 = new MQMessage();
                    this.adminQueue.get(mQMessage2, mQGetMessageOptions);
                    bl2 = false;
                    bl = true;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                bl2 = false;
                bl = false;
            }
        }
        return bl;
    }

    public byte[] add(MQSubEntry mQSubEntry, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "add");
            Trace.trace(this, "add was passed:" + mQSubEntry);
        }
        byte[] byArray = null;
        if (bl && this.contains(mQSubEntry.getName())) {
            if (Trace.isOn) {
                Trace.trace(this, "In add() - entry already exists!");
                Trace.exit(this, "add");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            throw jMSException;
        }
        MQMessage mQMessage = mQSubEntry.toMessage();
        if (Trace.isOn) {
            Trace.trace(this, "MQPUT with messageId '" + Utils.bytesToHex(mQMessage.messageId) + "'");
        }
        try {
            this.adminQueue.put(mQMessage, new MQPutMessageOptions());
            byArray = mQMessage.messageId;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(this, "In add() - unable to MQPUT new entry");
                Trace.exit(this, "add");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)mQException);
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "add");
        }
        return byArray;
    }

    public byte[] add(MQSubEntry mQSubEntry) throws JMSException {
        return this.add(mQSubEntry, true);
    }

    public MQQueue checkInactive(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkInactive");
        }
        MQQueue mQQueue = null;
        boolean bl = false;
        if (mQSubEntry.getSubscriberState() == 'i') {
            bl = true;
        } else if (mQSubEntry.getSubscriberState() != 'u') {
            if (Trace.isOn) {
                Trace.trace(this, "checkInactive: state is neither unknown or inactive!");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3005");
            throw jMSException;
        }
        try {
            if (mQSubEntry.getSharedQueue() && !bl) {
                int n = 10;
                MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = mQSubEntry.getStatusMgrId();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 16;
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "attempting MQGET for jvm reference msg.");
                    }
                    mQQueue2.get(mQMessage, mQGetMessageOptions);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.trace(this, "shared subscriber assumed active. Throwing ex.");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3023");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                    throw mQException;
                }
                mQQueue2.close();
            }
            if (Trace.isOn) {
                Trace.trace(this, "opening subscription queue");
            }
            mQQueue = !mQSubEntry.getSharedQueue() ? mQQueueManager.accessQueue(mQSubEntry.getQName(), 36) : mQQueueManager.accessQueue(mQSubEntry.getQName(), 1);
        }
        catch (MQException mQException) {
            JMSException jMSException = mQException.reasonCode == 2042 ? ConfigEnvironment.newException("MQJMS3023") : ConfigEnvironment.newException("MQJMS3005");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + mQException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "checkInactive");
            }
        }
        return mQQueue;
    }

    public static byte[] addND(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQSubAdmin", "addNDRecord");
        }
        MQMessage mQMessage = mQSubEntry.toMessage();
        try {
            MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 16);
            mQQueue.put(mQMessage);
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace("MQSubAdmin", "Create and Throwing " + (Object)((Object)jMSException));
                Trace.trace("MQSubAdmin", "Linked Exception " + mQException);
                Trace.exit("MQSubAdmin", "addNDRecord");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit("MQSubAdmin", "addNDRecord");
        }
        return mQMessage.messageId;
    }

    /*
     * Loose catch block
     */
    public static void removeND(MQQueueManager mQQueueManager, byte[] byArray) throws JMSException {
        block14: {
            MQQueue mQQueue;
            block12: {
                if (Trace.isOn) {
                    Trace.entry("MQSubAdmin", "removeNDRecord");
                }
                mQQueue = null;
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = byArray;
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 2);
                mQQueue.get(mQMessage);
                mQQueue.close();
                mQQueue = null;
                Object var7_4 = null;
                if (mQQueue == null) break block12;
                try {
                    mQQueue.close();
                }
                catch (Exception exception) {
                    if (!Trace.isOn) break block12;
                    Trace.trace("MQSubAdmin", "closing statusQueue in finally clause generated " + exception);
                }
            }
            if (Trace.isOn) {
                Trace.exit("MQSubAdmin", "removeNDRecord");
            }
            break block14;
            {
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
                    jMSException.setLinkedException((Exception)mQException);
                    if (Trace.isOn) {
                        Trace.trace("MQSubAdmin", "Create and Throwing " + (Object)((Object)jMSException));
                        Trace.trace("MQSubAdmin", "Linked Exception " + mQException);
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var7_5 = null;
                    if (mQQueue != null) {
                        try {
                            mQQueue.close();
                        }
                        catch (Exception exception) {
                            if (!Trace.isOn) break block13;
                            Trace.trace("MQSubAdmin", "closing statusQueue in finally clause generated " + exception);
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.exit("MQSubAdmin", "removeNDRecord");
                }
                throw throwable;
            }
        }
    }
}

