/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQObjectRecord;
import com.ibm.mq.MQResponseRecord;
import com.ibm.mq.MQSESSION;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MQOD {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQOD.java, java, j600, j600-101-060328 1.28.1.4 05/11/23 14:32:18";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int StrucId = 1329864736;
    protected int Version = 1;
    public int ObjectType = 1;
    public String ObjectName = "";
    public String ObjectQMgrName = "";
    public String DynamicQName = MQSESSION.getProductPrefix() + ".*";
    public String AlternateUserId = "";
    protected static final int sizeOfMQODv1 = 168;
    protected static final int sizeOfMQODv2 = 200;
    protected MQObjectRecord[] objectRecords = null;
    protected MQResponseRecord[] responseRecords = null;
    private MQDistributionListItem[] ditems = null;
    protected int KnownDestCount = 0;
    protected int UnknownDestCount = 0;
    protected int InvalidDestCount = 0;
    protected int browseMarkTimeout = 0;

    public MQOD() {
        if (Trace.isOn) {
            Trace.entry(this, "MQOD constructor");
            Trace.trace(2, this, sccsid);
        }
        this.Version = 1;
        if (Trace.isOn) {
            Trace.exit(this, "MQOD constructor");
        }
    }

    public MQOD(MQDistributionListItem[] mQDistributionListItemArray) {
        if (Trace.isOn) {
            Trace.entry(this, "MQOD v2 constructor");
            Trace.trace(2, this, sccsid);
        }
        this.Version = 2;
        this.ditems = mQDistributionListItemArray;
        this.objectRecords = new MQObjectRecord[mQDistributionListItemArray.length];
        this.responseRecords = new MQResponseRecord[mQDistributionListItemArray.length];
        for (int i = 0; i < mQDistributionListItemArray.length; ++i) {
            this.objectRecords[i] = new MQObjectRecord();
            this.objectRecords[i].objectQMgrName = mQDistributionListItemArray[i].queueManagerName;
            this.objectRecords[i].objectName = mQDistributionListItemArray[i].queueName;
            this.responseRecords[i] = new MQResponseRecord();
        }
        this.getBrowseMarkTimeout();
        if (Trace.isOn) {
            Trace.exit(this, "MQOD constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBrowseMarkTimeout() {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "getBrowseMarkTimeout");
            }
            if (null == (string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("com.ibm.mq.browsemarktimeout");
                    }
                    catch (AccessControlException accessControlException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "AccessControlException: " + accessControlException.getMessage() + " -> returning null");
                        }
                        return null;
                    }
                }
            }))) {
                if (Trace.isOn) {
                    Trace.trace(this, "BrowseMarkTimeout was not set");
                }
                this.browseMarkTimeout = 0;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "BrowseMarkTimeout was specified as " + string);
                }
                try {
                    this.browseMarkTimeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Couldn't parse timeout as int. Ignoring");
                    }
                    this.browseMarkTimeout = 0;
                }
            }
            return;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getBrowseMarkTimeout");
            }
        }
    }

    protected final int sizeOfMQOD() {
        if (this.Version == 1) {
            return 168;
        }
        int n = 0;
        if (this.objectRecords != null) {
            n += this.objectRecords.length * (MQObjectRecord.sizeOfMQObjectRecord + MQResponseRecord.sizeOfMQResponseRecord);
        }
        return 200 + n;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeTo");
        }
        dataOutputStream.writeBytes("OD  ");
        dataOutputStream.writeInt(this.Version);
        dataOutputStream.writeInt(this.ObjectType);
        String string = MQSESSION.setStringToLength(this.ObjectName, 48);
        dataOutputStream.writeBytes(string);
        String string2 = MQSESSION.setStringToLength(this.ObjectQMgrName, 48);
        dataOutputStream.writeBytes(string2);
        String string3 = MQSESSION.setStringToLength(this.DynamicQName, 48);
        dataOutputStream.writeBytes(string3);
        String string4 = MQSESSION.setStringToLength(this.AlternateUserId, 12);
        dataOutputStream.writeBytes(string4);
        if (this.Version > 1) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.objectRecords != null) {
                n = this.objectRecords.length;
                n2 = 200;
                n3 = n2 + n * MQObjectRecord.sizeOfMQObjectRecord;
            }
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(this.browseMarkTimeout);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            if (n > 0) {
                int n4;
                if (this.responseRecords == null || this.responseRecords.length != this.objectRecords.length) {
                    if (Trace.isOn) {
                        Trace.exit(this, "writeTo (via exception");
                    }
                    throw new MQInternalException(2, 2154, 24);
                }
                for (n4 = 0; n4 < n; ++n4) {
                    dataOutputStream = this.objectRecords[n4].writeTo(dataOutputStream);
                }
                for (n4 = 0; n4 < n; ++n4) {
                    dataOutputStream = this.responseRecords[n4].writeTo(dataOutputStream);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "writeTo");
        }
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "readFrom");
        }
        if (dataInputStream.available() < 168) {
            if (Trace.isOn) {
                Trace.exit(this, "readFrom (via exception)");
            }
            throw new MQInternalException(2, 2195, 84);
        }
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray, 0, 4);
        String string = MQEnvironment.stringFromBytes(byArray);
        if (!string.equals("OD  ")) {
            if (Trace.isOn) {
                Trace.exit(this, "readFrom (via exception)");
            }
            throw new MQInternalException(2, 2195, 83, string);
        }
        this.Version = dataInputStream.readInt();
        this.ObjectType = dataInputStream.readInt();
        byte[] byArray2 = new byte[48];
        dataInputStream.read(byArray2, 0, 48);
        this.ObjectName = MQEnvironment.stringFromBytes(byArray2);
        byte[] byArray3 = new byte[48];
        dataInputStream.read(byArray3, 0, 48);
        this.ObjectQMgrName = MQEnvironment.stringFromBytes(byArray3);
        byte[] byArray4 = new byte[48];
        dataInputStream.read(byArray4, 0, 48);
        this.DynamicQName = MQEnvironment.stringFromBytes(byArray4);
        byte[] byArray5 = new byte[12];
        dataInputStream.read(byArray5, 0, 12);
        this.AlternateUserId = MQEnvironment.stringFromBytes(byArray5);
        if (this.Version > 1) {
            int n;
            int n2 = dataInputStream.readInt();
            this.KnownDestCount = dataInputStream.readInt();
            this.UnknownDestCount = dataInputStream.readInt();
            this.InvalidDestCount = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readInt();
            if (n2 > 0) {
                if (this.objectRecords == null || this.responseRecords == null || this.objectRecords.length != n2 || this.responseRecords.length != n2) {
                    if (Trace.isOn) {
                        Trace.exit(this, "readFrom (via exception)");
                    }
                    throw new MQInternalException(2, 2154, 100);
                }
                for (n = 0; n < n2; ++n) {
                    dataInputStream = this.objectRecords[n].readFrom(dataInputStream);
                }
                for (n = 0; n < n2; ++n) {
                    dataInputStream = this.responseRecords[n].readFrom(dataInputStream);
                }
            }
            if (this.ditems != null) {
                for (n = 0; n < this.ditems.length; ++n) {
                    this.ditems[n].queueManagerName = this.objectRecords[n].objectQMgrName;
                    this.ditems[n].queueName = this.objectRecords[n].objectName;
                    this.ditems[n].completionCode = this.responseRecords[n].completionCode;
                    this.ditems[n].reasonCode = this.responseRecords[n].reason;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "readFrom");
        }
        return dataInputStream;
    }

    protected int GetNumberofRecords() {
        int n = 0;
        if (this.objectRecords != null) {
            n = this.objectRecords.length;
        }
        return n;
    }

    public void updateDistributionListItems() {
        if (Trace.isOn) {
            Trace.entry(this, "updateDistributionListItems");
        }
        if (this.ditems != null && this.Version > 1) {
            for (int i = 0; i < this.ditems.length; ++i) {
                this.ditems[i].queueManagerName = this.objectRecords[i].objectQMgrName;
                this.ditems[i].queueName = this.objectRecords[i].objectName;
                this.ditems[i].completionCode = this.responseRecords[i].completionCode;
                this.ditems[i].reasonCode = this.responseRecords[i].reason;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "updateDistributionListItems");
        }
    }
}

