/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSNullMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMigrateSubscriptionEngine;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;

public class MQPubSubServices {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQPubSubServices.java, jms, j600, j600-101-060328 1.17.1.2 05/08/30 13:51:10";
    protected byte[] sessionName;
    private static final int DEFAULT_BROKER_TIMEOUT = 120000;
    private static final int MIN_CLEANUP_TIME = 59000;
    static final int REGISTER_PUBLISHER = 0;
    static final int DEREGISTER_PUBLISHER = 1;
    static final int REGISTER_SUBSCRIBER = 2;
    static final int DEREGISTER_SUBSCRIBER = 3;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 4;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 5;
    protected static final String REGPUB_CMD_PREFIX = "MQPSCommand RegPub MQPSTopic ";
    protected static final String DEREGPUB_CMD_PREFIX = "MQPSCommand DeregPub MQPSTopic ";
    protected static final String REGSUB_CMD_PREFIX = "MQPSCommand RegSub MQPSTopic ";
    protected static final String DEREGSUB_CMD_PREFIX = "MQPSCommand DeregSub MQPSTopic ";
    protected static final String REGSUB_CORREL_CMD_PREFIX = "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String DEREGSUB_CORREL_CMD_PREFIX = "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    protected static final String MQPS_Q_NAME_B = " MQPSQName ";
    protected static final String MQPS_REGISTRATION_OPTIONS_B = " MQPSRegOpts ";
    protected static final String MQPS_NON_PERSISTENT = "NonPers";
    protected static final String MQPS_DUPLICATES_OK = "DupsOK";
    protected BrokerConnectionInfo brk = new BrokerConnectionInfo(null, null, null);
    protected MQQueue replyQ = null;
    MQGetMessageOptions brokerReponseGmo;
    protected byte[] responseCorrelId = new byte[24];
    protected int brkOptLevel;
    protected boolean wait_for_reply = true;
    protected int brokerTimeout = 120000;
    protected int brokerVersion = 0;
    protected String nondur_subscribeQ;
    public String SUBSCRIBE_CMD_POSTFIX;
    boolean spiGetSupported = false;

    MQPubSubServices() {
    }

    MQPubSubServices(MQConnection mQConnection, boolean bl, int n, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.initialisePubSub(mQConnection, bl, n, mQSession);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    protected void initialisePubSub(MQConnection mQConnection, boolean bl, int n, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "initialisePubSub");
        }
        MQSubscriptionEngine mQSubscriptionEngine = mQConnection.getSubscriptionEngine();
        this.sessionName = null;
        if (mQSubscriptionEngine instanceof MQBrokerSubscriptionEngine) {
            this.sessionName = ((MQBrokerSubscriptionEngine)mQSubscriptionEngine).createSessionName(mQSession);
        } else if (mQSubscriptionEngine instanceof MQMigrateSubscriptionEngine) {
            this.sessionName = ((MQMigrateSubscriptionEngine)mQSubscriptionEngine).createSessionName(mQSession);
        }
        mQSession.sessionName = this.sessionName;
        this.brk.controlQ = mQConnection.getBrkControlQueue();
        this.brk.streamQ = mQConnection.getBrkPubQueue();
        this.brk.qmName = mQConnection.getBrkQueueManager();
        mQSession.brk = this.brk;
        this.brokerVersion = mQConnection.getBrkVersion();
        mQSession.brkOptLevel = this.brkOptLevel = mQConnection.getBrkOptLevel();
        mQSession.nondur_subscribeQ = this.nondur_subscribeQ = mQConnection.getBrkSubQueue();
        mQSession.SUBSCRIBE_CMD_POSTFIX = this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        mQSession.responseInterval = mQConnection.getPubAckInterval();
        mQSession.checkInterval = mQSession.responseInterval / 2;
        Integer n2 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger("com.ibm.mq.jms.tuning.brokerResponseTimeout");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (null != n2 && n2 > 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Setting brokerResponseTimeout from System property = " + n2);
            }
            this.brokerTimeout = n2;
        } else {
            if (Trace.isOn) {
                Trace.trace(this, "cannot read brokerResponseTimeout System property. Using default = 120000");
            }
            this.brokerTimeout = 120000;
        }
        try {
            int n3 = 1;
            if (mQConnection.getFailIfQuiesce() == 1) {
                n3 |= 0x2000;
            }
            mQSession.replyQ = this.replyQ = mQSession.getQM().accessQueue("SYSTEM.JMS.REPORT.QUEUE", n3);
            this.brokerReponseGmo = new MQGetMessageOptions();
            this.brokerReponseGmo.options = 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (mQConnection.getFailIfQuiesce() == 1) {
                this.brokerReponseGmo.options |= 0x2000;
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1111"));
            jMSException.setLinkedException((Exception)mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "initialisePubSub");
            }
        }
    }

    protected void closePubSub(MQSession mQSession) throws JMSException {
        Throwable throwable;
        block11: {
            if (mQSession.isStarted() && mQSession.usingAsyncMode()) {
                try {
                    mQSession.stop();
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block11;
                    Trace.trace(this, "implicit stop failed with " + (Object)((Object)jMSException));
                    throwable = jMSException.getLinkedException();
                    if (throwable == null) break block11;
                    Trace.trace(this, "linked exception " + throwable);
                }
            }
        }
        if (this.replyQ != null) {
            if (mQSession.responseRequested) {
                try {
                    MQMsg2 mQMsg2 = new MQMsg2();
                    this.getBrokerResponse(mQSession, mQMsg2, false);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "caught " + (Object)((Object)jMSException));
                        throwable = jMSException.getLinkedException();
                        if (throwable != null) {
                            Trace.trace(this, "linked exception " + throwable);
                        }
                    }
                    throw jMSException;
                }
            }
            try {
                this.replyQ.close();
                this.replyQ = null;
            }
            catch (MQException mQException) {
                throwable = ConfigEnvironment.newException("MQJMS2000");
                throwable.setLinkedException((Exception)mQException);
                throw throwable;
            }
        }
    }

    MQQueue getResponseQueue(MQSession mQSession) throws JMSException {
        if (mQSession.replyQ == null) {
            try {
                int n = 1;
                if (mQSession.connection.getFailIfQuiesce() == 1) {
                    n |= 0x2000;
                }
                mQSession.replyQ = this.replyQ = mQSession.getQM().accessQueue("SYSTEM.JMS.REPORT.QUEUE", n);
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1111"));
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        return mQSession.replyQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getBrokerResponse(MQSession mQSession, MQMsg2 mQMsg2, boolean bl) throws NoBrokerResponseException {
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerResponse");
        }
        int n = 0;
        if (bl) {
            mQMsg2.setCorrelationId(mQMsg2.getMessageId());
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
        } else {
            mQMsg2.setCorrelationId(mQSession.responseCorrelId);
            mQSession.responseRequested = false;
            long l = System.currentTimeMillis();
            n = (int)(l - mQSession.responsePutTime);
            if (Trace.isOn) {
                Trace.trace(this, "elapsed time is " + n);
            }
            if (n < this.brokerTimeout) {
                this.brokerReponseGmo.waitInterval = this.brokerTimeout - n;
            } else {
                this.brokerReponseGmo.options &= 0xFFFFFFFE;
                this.brokerReponseGmo.waitInterval = 0;
            }
        }
        mQMsg2.setMessageId(MQC.MQMI_NONE);
        try {
            try {
                mQSession.replyQ.getMsg2(mQMsg2, this.brokerReponseGmo);
            }
            catch (MQException mQException) {
                if (bl) {
                    String string = "MQJMS5053";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string3);
                    noBrokerResponseException.setLinkedException(mQException);
                    throw noBrokerResponseException;
                }
                if (mQException.reasonCode == 2033 && n > 59000) {
                    Object var10_8 = null;
                    this.brokerReponseGmo.options |= 1;
                    this.brokerReponseGmo.waitInterval = this.brokerTimeout;
                    if (!Trace.isOn) return;
                    Trace.exit(this, "getBrokerResponse");
                    return;
                }
                String string = "MQJMS5053";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                noBrokerResponseException.setLinkedException(mQException);
                throw noBrokerResponseException;
            }
            Object var10_7 = null;
            this.brokerReponseGmo.options |= 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.brokerReponseGmo.options |= 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getBrokerResponse");
            throw throwable;
        }
        Trace.exit(this, "getBrokerResponse");
    }

    boolean getSparseSubscriptions(MQSession mQSession) {
        if (mQSession.connection != null) {
            return mQSession.connection.getSparseSubscriptions();
        }
        if (Trace.isOn) {
            Trace.trace(this, "getSparseSubscriptions, connection null, returning false");
        }
        return false;
    }

    protected void setBrokerTimeout(int n) {
        if (Trace.isOn) {
            Trace.trace(this, "setBrokerTimeout to " + n);
        }
        this.brokerTimeout = n;
        this.wait_for_reply = this.brokerTimeout > 0;
    }

    protected int getBrokerTimeout() {
        return this.brokerTimeout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl, boolean bl2, MQSession mQSession) throws JMSException {
        String string3 = null;
        Object var10_9 = null;
        MQMsg2 mQMsg2 = null;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        String string4 = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendCommand");
        }
        if ((n == 2 || n == 4) && bl2 && this.brk.qmName.equals(mQSession.connection.qmgrName) && !mQSession.persistenceFromMD) {
            bl5 = true;
        }
        if (mQSession.acknowledgeMode == 3 && (n == 2 || n == 4)) {
            bl6 = true;
        }
        try {
            while (bl4) {
                int n2;
                MQJMSMessage mQJMSMessage = new MQJMSMessage();
                StringBuffer stringBuffer = new StringBuffer();
                bl4 = false;
                switch (n) {
                    case 0: {
                        stringBuffer.append(REGPUB_CMD_PREFIX);
                        break;
                    }
                    case 2: {
                        stringBuffer.append(REGSUB_CMD_PREFIX);
                        break;
                    }
                    case 4: {
                        stringBuffer.append(REGSUB_CORREL_CMD_PREFIX);
                        bl3 = true;
                        break;
                    }
                    case 1: {
                        stringBuffer.append(DEREGPUB_CMD_PREFIX);
                        break;
                    }
                    case 3: {
                        stringBuffer.append(DEREGSUB_CMD_PREFIX);
                        break;
                    }
                    case 5: {
                        stringBuffer.append(DEREGSUB_CORREL_CMD_PREFIX);
                        bl3 = true;
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "unknown value of command: " + n);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", "unknown command value " + n);
                        throw jMSException;
                    }
                }
                try {
                    stringBuffer.append(string);
                    if (Trace.isOn) {
                        Trace.trace(this, "Current brkOptLevel: " + this.brkOptLevel);
                    }
                    if (bl5 && this.brkOptLevel > 0) {
                        stringBuffer.append(" MQPSRegOpts NonPers");
                    }
                    if (bl6 && this.brkOptLevel > 0) {
                        stringBuffer.append(" MQPSRegOpts DupsOK");
                    }
                    stringBuffer.append(string2);
                    string3 = stringBuffer.toString();
                    JMSNullMessage jMSNullMessage = (JMSNullMessage)mQSession.createMessage();
                    jMSNullMessage.setJMSDeliveryMode(2);
                    mQJMSMessage.writeRFH(string3, jMSNullMessage, false, 0);
                    mQJMSMessage.setFormat("MQHRF   ");
                    mQJMSMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    if (bl3) {
                        mQJMSMessage.setCorrelationId(byArray);
                    }
                    if (bl) {
                        mQJMSMessage.setReport(3);
                    }
                    if (string4 != null) {
                        mQJMSMessage.setUserId(string4);
                    }
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3008");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    SubscriptionHelper.MQPUT1(mQSession.qm, this.brk.qmName, this.brk.controlQ, mQJMSMessage);
                }
                catch (JMSException jMSException) {
                    n2 = 0;
                    Exception exception = jMSException.getLinkedException();
                    if (exception instanceof MQException) {
                        MQException mQException = (MQException)exception;
                        if (mQException.completionCode == 1 && mQException.reasonCode == 2104) {
                            n2 = 1;
                        }
                    }
                    if (n2 == 0) {
                        JMSException jMSException2 = ConfigEnvironment.newException("MQJMS3009");
                        jMSException2.setLinkedException((Exception)((Object)jMSException));
                        throw jMSException2;
                    }
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3009");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                if (!bl) continue;
                mQMsg2 = new MQMsg2();
                mQMsg2.setMessageId(mQJMSMessage.getMessageId());
                this.getBrokerResponse(mQSession, mQMsg2, true);
                try {
                    SubscriptionHelper.checkResponse(mQMsg2);
                }
                catch (BrokerCommandFailedException brokerCommandFailedException) {
                    n2 = brokerCommandFailedException.getReason();
                    switch (n2) {
                        case 3083: {
                            if (this.brkOptLevel <= 0) break;
                            if (bl6) {
                                --this.brkOptLevel;
                                bl4 = true;
                            } else if (bl5) {
                                --this.brkOptLevel;
                                bl4 = true;
                            }
                            if (!bl4) break;
                            mQSession.connection.setBrkOptLevel(this.brkOptLevel);
                            break;
                        }
                        case 3078: {
                            if (string4 != null) break;
                            string4 = brokerCommandFailedException.getUserId();
                            bl4 = true;
                            break;
                        }
                    }
                    if (bl4) continue;
                    if (!Trace.isOn) throw brokerCommandFailedException;
                    Trace.trace(this, "Failed to reregister due to " + (Object)((Object)brokerCommandFailedException));
                    throw brokerCommandFailedException;
                    return;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendCommand");
            }
        }
    }

    boolean requestResponse(MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "requestResponse");
        }
        ++mQSession.publishCount;
        if (Trace.isOn) {
            Trace.trace(this, "publishCount is " + mQSession.publishCount);
        }
        if (!mQSession.responseRequested && !mQSession.responseOnCommit && mQSession.publishCount >= mQSession.responseInterval) {
            if (Trace.isOn) {
                Trace.trace(this, "requestResponse returning true");
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.trace(this, "requestResponse returning false");
        }
        return false;
    }

    boolean checkForResponse(MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "checkForResponse");
            Trace.trace(this, "publishCount is " + mQSession.publishCount);
            Trace.trace(this, "checkInterval is " + mQSession.checkInterval);
        }
        if (mQSession.responseRequested) {
            if (mQSession.publishCount >= mQSession.checkInterval) {
                if (Trace.isOn) {
                    Trace.trace(this, "checkForResponse returning true");
                }
                return true;
            }
            if (System.currentTimeMillis() - mQSession.responsePutTime > 59000L) {
                if (Trace.isOn) {
                    Trace.trace(this, "checkForResponse returning true");
                }
                return true;
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, "checkForResponse returning false");
        }
        return false;
    }
}

