/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;

public class MQManagedObject {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQManagedObject.java, java, j600, j600-101-060328 1.32.1.1 05/05/25 15:35:04";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Pint Hobj;
    protected Pint Hconn;
    protected String pszName;
    protected boolean connected;
    protected boolean resourceOpen;
    protected static final int MQCA_Q_DESC = 2013;
    protected static final int MQCA_Q_MGR_DESC = 2014;
    protected static final int MQCA_PROCESS_DESC = 2011;
    protected static final int MQ_DESC_LENGTH = 64;
    protected MQSESSION osession = null;
    MQQueueManager parentQmgr = null;
    protected int mqca_description = 2014;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    public String alternateUserId = "";
    public String name = "";
    public int openOptions = 32;
    public boolean isOpen = false;
    protected boolean openStatus = false;
    public MQQueueManager connectionReference = null;
    public int closeOptions = 0;

    public boolean isOpen() {
        return this.openStatus;
    }

    public String getDescription() throws MQException {
        return this.getString(this.mqca_description, 64);
    }

    protected MQManagedObject() {
        if (Trace.isOn) {
            Trace.entry(this, "MQManagedObject constructor");
            Trace.trace(2, this, sccsid);
        }
        this.resourceOpen = false;
        this.connected = false;
        this.Hconn = new Pint(-1);
        this.Hobj = new Pint(-1);
        if (Trace.isOn) {
            Trace.exit(this, "MQManagedObject constructor");
        }
    }

    public void inquire(int[] nArray, int[] nArray2, byte[] byArray) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "inquire");
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "inquire (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "inquire (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 16);
        }
        if (nArray == null || nArray.length == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "inquire (via exception)");
            }
            throw new MQException(2, 2067, (Object)this, 17);
        }
        int n = 0;
        if (nArray2 != null) {
            n = nArray2.length;
        }
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        this.osession.MQINQ(this.Hconn.x, this.Hobj.x, nArray.length, nArray, n, nArray2, n2, byArray, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "inquire (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "inquire");
        }
    }

    public synchronized void set(int[] nArray, int[] nArray2, byte[] byArray) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "set");
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "set (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "set (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 16);
        }
        if (nArray == null || nArray.length == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "set (via exception)");
            }
            throw new MQException(2, 2067, (Object)this, 17);
        }
        int n = 0;
        if (nArray2 != null) {
            n = nArray2.length;
        }
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        this.osession.MQSET(this.Hconn.x, this.Hobj.x, nArray.length, nArray, n, nArray2, n2, byArray, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            Trace.exit(this, "set (via exception)");
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "set");
        }
    }

    public synchronized void close() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "close - not connected to queue manager");
            }
            return;
        }
        if (this.resourceOpen) {
            this.osession.MQCLOSE(this.Hconn.x, this.Hobj, this.closeOptions, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.parentQmgr.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "close (via exception)");
                }
                throw mQException;
            }
            this.resourceOpen = false;
        }
        this.isOpen = false;
        this.openStatus = false;
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    protected void finalize() {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        if (this.resourceOpen) {
            try {
                this.close();
            }
            catch (MQException mQException) {
                // empty catch block
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    protected final int getInt(int n) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "getInt");
            Trace.trace(2, this, "selector = " + n);
        }
        int[] nArray = new int[]{n};
        int[] nArray2 = new int[1];
        this.inquire(nArray, nArray2, null);
        if (Trace.isOn) {
            Trace.exit(this, "getInt");
        }
        return nArray2[0];
    }

    protected final void setInt(int n, int n2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "setInt");
            Trace.trace(2, this, "selector = " + n);
            Trace.trace(2, this, "value    = " + n2);
        }
        int[] nArray = new int[]{n};
        int[] nArray2 = new int[]{n2};
        this.set(nArray, nArray2, null);
        if (Trace.isOn) {
            Trace.exit(this, "setInt");
        }
    }

    protected final String getString(int n, int n2) throws MQException {
        String string;
        if (Trace.isOn()) {
            Trace.entry(this, "getString");
            Trace.trace(2, this, "selector = " + n);
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "getString (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        int n3 = this.osession.getCharEncoding();
        if (n3 == 1) {
            int[] nArray = new int[]{n};
            byte[] byArray = new byte[n2];
            this.inquire(nArray, null, byArray);
            string = MQEnvironment.stringFromBytes(byArray);
        } else {
            if (!this.resourceOpen) {
                if (Trace.isOn) {
                    Trace.exit(this, "getString (via exception)");
                }
                throw new MQException(2, 2019, (Object)this, 16);
            }
            string = this.osession.MQINQ(this.Hconn.x, this.Hobj.x, n, n2, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.parentQmgr.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "getString (via exception)");
                }
                throw mQException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getString");
        }
        return string;
    }

    public final String getAttributeString(int n, int n2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "getAttributeString");
            Trace.trace(2, this, "selector = " + n);
        }
        String string = this.getString(n, n2);
        if (Trace.isOn) {
            Trace.exit(this, "getAttributeString");
        }
        return string;
    }

    protected final void setString(int n, String string, int n2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "setString");
            Trace.trace(2, this, "selector = " + n);
            Trace.trace(2, this, "value    = " + string);
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "getString (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        int n3 = this.osession.getCharEncoding();
        if (n3 == 1) {
            int[] nArray = new int[]{n};
            int n4 = -1;
            byte[] byArray = new byte[n2];
            if (string != null) {
                block18: {
                    byte[] byArray2 = MQEnvironment.bytesFromString(string);
                    try {
                        System.arraycopy(byArray2, 0, byArray, 0, Math.min(n2, string.length()));
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block18;
                        Trace.trace(1, this, "Arraycopy exception : " + exception);
                    }
                }
                if (string.length() < n2) {
                    n4 = string.length();
                }
            } else {
                n4 = 0;
            }
            if (n4 != -1) {
                for (int i = n4; i < n2; ++i) {
                    byArray[i] = 32;
                }
            }
            this.set(nArray, null, byArray);
        } else {
            if (!this.resourceOpen) {
                if (Trace.isOn) {
                    Trace.exit(this, "setString (via exception)");
                }
                throw new MQException(2, 2019, (Object)this, 16);
            }
            this.osession.MQSET(this.Hconn.x, this.Hobj.x, n, string, n2, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
                this.parentQmgr.errorOccurred(mQException);
                if (Trace.isOn) {
                    Trace.exit(this, "setString (via exception)");
                }
                throw mQException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setString");
        }
    }

    public final void setAttributeString(int n, String string, int n2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "setAttributeString");
            Trace.trace(2, this, "selector = " + n);
            Trace.trace(2, this, "value    = " + string);
        }
        this.setString(n, string, n2);
        if (Trace.isOn) {
            Trace.exit(this, "setAttributeString");
        }
    }
}

