/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQCrlInformation;
import com.ibm.mq.MQException;
import com.ibm.mqservices.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class SSLCRLHelper {
    public static final String CLSNAME = "SSLCRLHelper";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/SSLCRLHelper.java, java, j600, j600-101-060328 1.10.1.1 05/05/25 15:42:25";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static void check(X509Certificate x509Certificate, Collection collection) throws MQException {
        Object object;
        if (collection.size() == 0) {
            return;
        }
        CertStore certStore = null;
        Exception exception = null;
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !bl) {
            try {
                certStore = (CertStore)iterator.next();
            }
            catch (ClassCastException classCastException) {
                if (exception != null) continue;
                exception = classCastException;
                continue;
            }
            if (certStore == null) {
                if (exception != null) continue;
                exception = new NullPointerException();
                continue;
            }
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "Searching CRL server");
            }
            object = new X509CRLSelector();
            Principal principal = x509Certificate.getIssuerDN();
            String string = principal.getName();
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "Setting issuer to " + string);
            }
            try {
                ((X509CRLSelector)object).addIssuerName(new X500Principal(string).getName("CANONICAL"));
            }
            catch (IOException iOException) {
                throw new MQException(2, 2397, (Object)"static method in SSLCRL code", 54);
            }
            Collection<Object> collection2 = new Vector();
            try {
                Certificate certificate;
                Object object2;
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "Retrieving CRLs");
                }
                try {
                    collection2 = certStore.getCRLs((CRLSelector)object);
                }
                catch (CertStoreException certStoreException) {
                    if (certStoreException.getCause() instanceof NamingException) {
                        object2 = (NamingException)certStoreException.getCause();
                        if (((NamingException)object2).getRootCause() instanceof NameNotFoundException) {
                            if (Trace.isOn()) {
                                Trace.trace(CLSNAME, "Caught Sun NameNotFoundException - ignoring");
                            }
                        }
                        throw certStoreException;
                    }
                    throw certStoreException;
                }
                try {
                    object2 = CertificateFactory.getInstance("X509");
                    certificate = ((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(x509Certificate.getEncoded()));
                }
                catch (java.security.cert.CertificateException certificateException) {
                    throw new MQException(2, 2195, x509Certificate);
                }
                catch (CertificateException certificateException) {
                    throw new MQException(2, 2195, x509Certificate);
                }
                if (collection2.size() == 0) {
                    if (Trace.isOn()) {
                        Trace.trace(CLSNAME, "Issuer has no revoked certificates - accepting");
                    }
                    bl = true;
                    continue;
                }
                if (Trace.isOn()) {
                    Trace.trace(CLSNAME, "Validating certificate against CRL");
                }
                object2 = collection2.iterator();
                while (object2.hasNext()) {
                    CRL cRL = (CRL)object2.next();
                    if (cRL.isRevoked(certificate)) {
                        throw new MQException(2, 2401, (Object)Thread.currentThread(), 122);
                    }
                    if (Trace.isOn()) {
                        Trace.trace(CLSNAME, "Not revoked - accepting");
                    }
                    bl = true;
                }
            }
            catch (CertStoreException certStoreException) {
                if (exception != null) continue;
                exception = certStoreException;
            }
        }
        if (!bl) {
            object = new MQException(2, 2402, (Object)"static method in SSLCRL code", 123);
            ((MQException)object).initCause(exception);
            throw object;
        }
    }

    public static void addCertStoreAsString(String string, Collection collection) throws MQException {
        String string2;
        int n = 389;
        int n2 = string.indexOf(58, 7);
        if (n2 != -1) {
            string2 = string.substring(7, n2);
            n = Integer.parseInt(string.substring(n2 + 1));
        } else {
            string2 = string.substring(7);
        }
        try {
            collection.add(CertStore.getInstance("LDAP", new LDAPCertStoreParameters(string2, n)));
        }
        catch (Exception exception) {
            throw new MQException(2, 2195, string);
        }
    }

    public static void addMQCrlCertStore(Object object, Collection collection) throws MQException {
        MQCrlInformation mQCrlInformation = null;
        if (!(object instanceof MQCrlInformation)) {
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "Invalid CRL Object passed into method ");
            }
            throw new MQException(2, 2393, CLSNAME);
        }
        mQCrlInformation = (MQCrlInformation)object;
        try {
            collection.add(CertStore.getInstance("LDAP", mQCrlInformation));
        }
        catch (Exception exception) {
            if (Trace.isOn()) {
                Trace.trace(CLSNAME, "Exception building certStore " + mQCrlInformation.getServerName() + ":" + mQCrlInformation.getPort());
                Trace.exceptionTrace(5, CLSNAME, exception);
            }
            throw new MQException(2, 2393, exception);
        }
    }
}

