/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnection;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class MQBindingsManagedConnectionFactoryJ11
implements MQManagedConnectionFactory {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQBindingsManagedConnectionFactoryJ11.java, java, j600, j600-101-060328 1.21.1.2 05/06/27 17:07:03";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String fieldQMGR = "";
    PrintWriter logWriter = null;

    MQBindingsManagedConnectionFactoryJ11(String string, Hashtable hashtable) {
        if (Trace.isOn) {
            Trace.entry(this, "MQBindingsManagedConnectionFactoryJ11 constructor");
        }
        this.setQMGR(string);
        if (Trace.isOn) {
            Trace.exit(this, "MQBindingsManagedConnectionFactoryJ11 constructor");
        }
    }

    public void setQMGR(String string) {
        this.fieldQMGR = string;
    }

    public String getQMGR() {
        return this.fieldQMGR;
    }

    public Object createConnectionFactory(MQConnectionManager mQConnectionManager) throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "createConnectionFactory");
            Trace.exit(this, "createConnectionFactory (via exception)");
        }
        throw new NotSupportedException("createConnectionFactory not supported by Websphere MQ");
    }

    public Object createConnectionFactory() throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "createConnectionFactory");
            Trace.exit(this, "createConnectionFactory (via exception)");
        }
        throw new NotSupportedException("createConnectionFactory not supported by Websphere MQ");
    }

    MQManagedConnectionJ11 _createManagedConnection(ConnectionRequestInfo connectionRequestInfo, boolean bl) throws ResourceException {
        MQManagedConnectionJ11 mQManagedConnectionJ11;
        if (Trace.isOn) {
            Trace.entry(this, "_createManagedConnection");
        }
        if (!(connectionRequestInfo instanceof BindingsConnectionRequestInfo)) {
            if (Trace.isOn) {
                Trace.exit(this, "_createManagedConnection (via exception)");
            }
            String string = MQException.getNLSMsg(105);
            throw new ResourceException(string);
        }
        BindingsConnectionRequestInfo bindingsConnectionRequestInfo = (BindingsConnectionRequestInfo)connectionRequestInfo;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("transport", "MQSeries Bindings");
        hashtable.put("connectOptions", new Integer(bindingsConnectionRequestInfo.connectOptions));
        if (bindingsConnectionRequestInfo.multiThread != null) {
            hashtable.put("Thread access", bindingsConnectionRequestInfo.multiThread);
        }
        if (bindingsConnectionRequestInfo.spi != null) {
            hashtable.put("SPI", bindingsConnectionRequestInfo.spi);
        }
        if (bindingsConnectionRequestInfo.inheritTx != null) {
            if (Trace.isOn) {
                Trace.trace(this, "put inheritTx = " + bindingsConnectionRequestInfo.inheritTx);
            }
            hashtable.put("SPI_INHERIT_TX", bindingsConnectionRequestInfo.inheritTx);
        }
        if (bindingsConnectionRequestInfo.asyncCmt != null) {
            if (Trace.isOn) {
                Trace.trace(this, "put asyncCmt  = " + bindingsConnectionRequestInfo.asyncCmt);
            }
            hashtable.put("SPI_ASYNC_CMIT", bindingsConnectionRequestInfo.asyncCmt);
        }
        if (bindingsConnectionRequestInfo.threadAffinity != null) {
            hashtable.put("Thread affinity", bindingsConnectionRequestInfo.threadAffinity);
        }
        if (bindingsConnectionRequestInfo.userName != null) {
            hashtable.put("userID", bindingsConnectionRequestInfo.userName);
        }
        if (bindingsConnectionRequestInfo.password != null) {
            hashtable.put("password", bindingsConnectionRequestInfo.password);
        }
        if (bindingsConnectionRequestInfo.authenticateBindings != null) {
            hashtable.put("Bindings Authentication", bindingsConnectionRequestInfo.authenticateBindings);
        }
        if (bindingsConnectionRequestInfo.connTag != null) {
            hashtable.put("ConnTag Property", bindingsConnectionRequestInfo.connTag);
        }
        try {
            if (bl) {
                mQManagedConnectionJ11 = new MQManagedConnectionJ11(this.fieldQMGR, hashtable, connectionRequestInfo, this);
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                mQManagedConnectionJ11.authenticate(pint, pint2);
            } else {
                mQManagedConnectionJ11 = new MQManagedConnection(this.fieldQMGR, hashtable, connectionRequestInfo, this);
            }
            mQManagedConnectionJ11.setLogWriter(this.logWriter);
        }
        catch (MQException mQException) {
            ResourceException resourceException = mQException.getResourceException();
            if (Trace.isOn) {
                Trace.exit(this, "_createManagedConnection (via exception)");
            }
            throw resourceException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "_createManagedConnection");
        }
        return mQManagedConnectionJ11;
    }

    public MQManagedConnectionJ11 createManagedConnection(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return this._createManagedConnection(connectionRequestInfo, true);
    }

    public MQManagedConnectionJ11 matchManagedConnections(Vector vector, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "matchManagedConnections");
        }
        MQManagedConnectionJ11 mQManagedConnectionJ11 = null;
        if (!(connectionRequestInfo instanceof BindingsConnectionRequestInfo)) {
            String string = MQException.getNLSMsg(105);
            throw new ResourceException(string);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && mQManagedConnectionJ11 == null) {
            try {
                MQManagedConnectionJ11 mQManagedConnectionJ112 = (MQManagedConnectionJ11)enumeration.nextElement();
                if (!mQManagedConnectionJ112.isSuitable(connectionRequestInfo, this)) continue;
                mQManagedConnectionJ11 = mQManagedConnectionJ112;
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (Trace.isOn()) {
            if (mQManagedConnectionJ11 == null) {
                Trace.trace(2, this, "No suitable MQManagedConnection found");
            } else {
                Trace.trace(2, this, "Suitable MQManagedConnection found: " + mQManagedConnectionJ11);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "matchManagedConnections");
        }
        return mQManagedConnectionJ11;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MQBindingsManagedConnectionFactoryJ11 mQBindingsManagedConnectionFactoryJ11 = (MQBindingsManagedConnectionFactoryJ11)object;
        return MQBindingsManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, mQBindingsManagedConnectionFactoryJ11.fieldQMGR);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalAccessError();
        }
    }

    static boolean twoStringsEqual(String string, String string2) {
        boolean bl = string == null && string2 == null ? true : (string == null || string2 == null ? false : string.equals(string2));
        return bl;
    }
}

