/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQQueueManager;
import com.ibm.mqservices.Trace;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;

public class MQManagedConnection
extends MQManagedConnectionJ11
implements ManagedConnection {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQManagedConnection.java, java, j600, j600-101-060328 1.15.1.1 05/05/25 15:39:00";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Vector listeners = new Vector();

    MQManagedConnection(String string, Hashtable hashtable, ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) throws MQException {
        super(string, hashtable, connectionRequestInfo, mQManagedConnectionFactory);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return this.getConnection(connectionRequestInfo);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (Trace.isOn) {
            Trace.entry(this, "addConnectionEventListener");
        }
        if (connectionEventListener == null) {
            if (Trace.isOn) {
                Trace.exit(this, "addMQConnectionEventListener (via exception)");
            }
            throw new NullPointerException();
        }
        this.listeners.addElement(connectionEventListener);
        if (Trace.isOn) {
            Trace.exit(this, "addConnectionEventListener");
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (Trace.isOn) {
            Trace.entry(this, "removeConnectionEventListener");
        }
        if (connectionEventListener == null) {
            if (Trace.isOn) {
                Trace.exit(this, "addMQConnectionEventListener (via exception)");
            }
            throw new NullPointerException();
        }
        this.listeners.removeElement(connectionEventListener);
        if (Trace.isOn) {
            Trace.exit(this, "removeConnectionEventListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionClosedEvent(MQQueueManager mQQueueManager) {
        Vector vector;
        if (Trace.isOn) {
            Trace.entry(this, "fireConnectionClosedEvent");
        }
        super.fireConnectionClosedEvent(mQQueueManager);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)mQQueueManager);
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)object.nextElement();
            connectionEventListener.connectionClosed(connectionEvent);
        }
        if (Trace.isOn) {
            Trace.exit(this, "fireConnectionClosedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionErrorEvent(MQQueueManager mQQueueManager, Exception exception) {
        if (Trace.isOn) {
            Trace.entry(this, "fireConnectionErrorEvent");
        }
        super.fireConnectionErrorEvent(mQQueueManager, exception);
        if (this.allowErrorEvents) {
            Vector vector;
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
            if (mQQueueManager != null) {
                connectionEvent.setConnectionHandle((Object)mQQueueManager);
            }
            Object object = this;
            synchronized (object) {
                vector = (Vector)this.listeners.clone();
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)object.nextElement();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "fireConnectionErrorEvent");
        }
    }
}

