/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQException;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mqservices.Trace;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.ConnectionManager;

public class MQEnvironment {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQEnvironment.java, java, j600, j600-101-060328 1.82.1.4 06/02/02 15:17:13";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2004 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String version_notice = "Websphere MQ classes for Java V6.0.0";
    static final String CLASSNAME = "MQEnvironment";
    public static MQSecurityExit securityExit;
    public static MQSendExit sendExit;
    public static MQReceiveExit receiveExit;
    public static String hostname;
    public static int port;
    public static String channel;
    public static String userID;
    public static String password;
    public static int CCSID;
    public static Collection hdrCompList;
    public static Collection msgCompList;
    public static String sslCipherSuite;
    public static String sslPeerName;
    public static Collection sslCertStores;
    public static Object sslSocketFactory;
    public static int sslResetCount;
    public static boolean sslFipsRequired;
    public static String localAddressSetting;
    public static byte[] connTag;
    public static int connOptions;
    public static Hashtable properties;
    static Vector poolTokenSet;
    static Vector poolServices;
    static MQConnectionManager defaultMQCxManager;
    static ConnectionManager defaultCxManager;
    static boolean xaClientEnabled;
    static int xaLicenseMsg;
    protected static boolean runningInWebSphere;
    protected static boolean forceAllowClient;

    public static final String getVersionNotice() {
        return version_notice;
    }

    public static void enableTracing(int n) {
        Trace.notInCICS();
        Trace.setTraceLevel(n);
        Trace.turnTracingOn();
        if (n >= 5) {
            Trace.turnMethodTracingOn();
        }
        MQEnvironment.traceSystemProperties();
    }

    public static void enableTracing(int n, OutputStream outputStream) {
        Trace.setWasBaseJavaTrace(true);
        Trace.notInCICS();
        if (outputStream != null) {
            Trace.setTraceStream(new PrintWriter(outputStream, true));
        }
        Trace.setTraceLevel(n);
        Trace.turnTracingOn();
        if (n >= 5) {
            Trace.turnMethodTracingOn();
        }
        MQEnvironment.traceSystemProperties();
    }

    public static void disableTracing() {
        Trace.setWasBaseJavaTrace(false);
        Trace.turnMethodTracingOff();
        Trace.turnTracingOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConnectionManager(MQConnectionManager mQConnectionManager) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "setDefaultConnectionManager (MQ)");
        }
        if (mQConnectionManager == null) {
            if (Trace.isOn) {
                Trace.exit("MQEnvrironment", "setDefaultConnectionManager (via exception)");
            }
            throw new NullPointerException("");
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultMQCxManager = mQConnectionManager;
            defaultCxManager = null;
            poolTokenSet.removeAllElements();
        }
        vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireDefaultConnectionManagerChanged();
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "setDefaultConnectionManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConnectionManager(ConnectionManager connectionManager) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "setDefaultConnectionManager");
        }
        if (connectionManager == null) {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "setDefaultConnectionManager (via exception)");
            }
            throw new NullPointerException("");
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultCxManager = connectionManager;
            defaultMQCxManager = null;
            poolTokenSet.removeAllElements();
        }
        vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireDefaultConnectionManagerChanged();
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "setDefaultConnectionManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getDefaultConnectionManager() {
        Vector vector = poolTokenSet;
        synchronized (vector) {
            return defaultCxManager;
        }
    }

    public static void addConnectionPoolToken(MQPoolToken mQPoolToken) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "addConnectionPoolToken");
        }
        if (mQPoolToken == null) {
            Trace.exit(CLASSNAME, "addConnectionPoolToken (via exception)");
            throw new NullPointerException("");
        }
        poolTokenSet.addElement(mQPoolToken);
        Vector vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireTokenAdded(mQPoolToken);
        }
        if (Trace.isOn) {
            Trace.exit("MQEnvironnment", "addConnectionPoolToken");
        }
    }

    public static MQPoolToken addConnectionPoolToken() {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "addConnectionPoolToken");
        }
        MQPoolToken mQPoolToken = new MQPoolToken();
        poolTokenSet.addElement(mQPoolToken);
        Vector vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireTokenAdded(mQPoolToken);
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "addConnectionPoolToken");
        }
        return mQPoolToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionPoolToken(MQPoolToken mQPoolToken) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "removeConnectionPoolToken");
        }
        if (mQPoolToken == null) {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "removeConnectionPoolToken (via exception)");
            }
            throw new NullPointerException("");
        }
        boolean bl = false;
        Vector vector = poolTokenSet;
        synchronized (vector) {
            int n = poolTokenSet.size();
            poolTokenSet.removeElement(mQPoolToken);
            if (poolTokenSet.size() < n) {
                bl = true;
            }
        }
        if (bl) {
            vector = (Vector)poolServices.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
                mQPoolServices.fireTokenRemoved(mQPoolToken);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "removeConnectionPoolToken");
        }
    }

    public static Thread createThread(Runnable runnable, boolean bl) throws SecurityException {
        return MQEnvironment.createThread(runnable, null, bl);
    }

    public static Thread createThread(final Runnable runnable, final String string, final boolean bl) throws SecurityException {
        Thread thread = null;
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "createThread");
            }
            thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = new Thread(runnable, string);
                    thread.setDaemon(bl);
                    return thread;
                }
            });
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "returning " + thread);
            }
            Thread thread2 = thread;
            return thread2;
        }
        catch (SecurityException securityException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "throwing " + securityException);
            }
            throw securityException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "createThread");
            }
        }
    }

    public static boolean runningInWS() {
        return runningInWebSphere;
    }

    public static boolean forceAllowClientConnection() {
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "forceAllowClient = " + forceAllowClient);
        }
        return forceAllowClient;
    }

    public static MQQueueManager getQueueManagerReference(int n) {
        return MQEnvironment.getQueueManagerReference(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQQueueManager getQueueManagerReference(int n, Object object) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getQueueManagerReference(...)");
        }
        MQQueueManager mQQueueManager = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            if (n != 8 && n != 32 && n != 0) {
                if (Trace.isOn) {
                    Trace.trace(1, CLASSNAME, "warning, bad scope value: " + n);
                }
                MQQueueManager mQQueueManager2 = null;
                return mQQueueManager2;
            }
            hashtable.put("QMgr_Association", new Integer(~n));
            if (object == null) {
                mQQueueManager = new MQQueueManager(null, hashtable);
            } else if (object instanceof String) {
                mQQueueManager = new MQQueueManager((String)object, hashtable);
            } else if (Trace.isOn) {
                Trace.trace(5, CLASSNAME, "warning, invalid context supplied: " + object);
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(5, CLASSNAME, "warning, caught exception: " + mQException);
                Trace.trace(5, CLASSNAME, "returning null");
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getQueueManagerReference(...)");
            }
        }
        return mQQueueManager;
    }

    protected static final String stringFromBytes(byte[] byArray) {
        String string;
        try {
            string = new String(byArray, "819");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Could not convert string using 819. Using default locale");
            }
            string = new String(byArray);
        }
        return string;
    }

    protected static final byte[] bytesFromString(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("819");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Could not convert string using 819. Using default locale");
            }
            byArray = string.getBytes();
        }
        return byArray;
    }

    static void registerPoolServices(MQPoolServices mQPoolServices) {
        poolServices.addElement(mQPoolServices);
    }

    static void deregisterPoolServices(MQPoolServices mQPoolServices) {
        poolServices.removeElement(mQPoolServices);
    }

    static Object getDefaultProperty(Object object) {
        Object object2 = properties.get(object);
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getDefaultProperty - " + object);
        }
        if (object2 == null) {
            if (object.equals("CCSID")) {
                object2 = new Integer(CCSID);
            }
            if (object.equals("channel")) {
                object2 = channel;
            }
            if (object.equals("connectOptions")) {
                object2 = new Integer(connOptions);
            }
            if (object.equals("hostname")) {
                object2 = hostname;
            }
            if (object.equals("password")) {
                object2 = password;
            }
            if (object.equals("port")) {
                object2 = new Integer(port);
            }
            if (object.equals("receiveExit")) {
                object2 = receiveExit;
            }
            if (object.equals("securityExit")) {
                object2 = securityExit;
            }
            if (object.equals("sendExit")) {
                object2 = sendExit;
            }
            if (object.equals("transport")) {
                object2 = "MQSeries";
            }
            if (object.equals("userID")) {
                object2 = userID;
            }
            if (object.equals("SSL Cipher Suite")) {
                object2 = sslCipherSuite;
            }
            if (object.equals("SSL Peer Name")) {
                object2 = sslPeerName;
            }
            if (object.equals("SSL CertStores")) {
                object2 = sslCertStores;
            }
            if (object.equals("SSL Socket Factory")) {
                object2 = sslSocketFactory;
            }
            if (object.equals("Local Address Property")) {
                object2 = localAddressSetting;
            }
            if (object.equals("Header Compression Property")) {
                object2 = hdrCompList;
            }
            if (object.equals("Message Compression Property")) {
                object2 = msgCompList;
            }
            if (object.equals("ConnTag Property")) {
                object2 = connTag;
            }
            if (object.equals("KeyResetCount")) {
                object2 = new Integer(sslResetCount);
            }
            if (object.equals("SSL Fips Required")) {
                object2 = new Boolean(sslFipsRequired);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getDefaultProperty - " + object);
        }
        return object2;
    }

    static Object getObjectProperty(String string, Hashtable hashtable) {
        Object object = null;
        if (hashtable != null) {
            object = hashtable.get(string);
        }
        if (object == null) {
            object = MQEnvironment.getDefaultProperty(string);
        }
        return object;
    }

    static String getStringProperty(String string, Hashtable hashtable) {
        Object object = MQEnvironment.getObjectProperty(string, hashtable);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    static int getIntegerProperty(String string, Hashtable hashtable) {
        Object object = MQEnvironment.getObjectProperty(string, hashtable);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    static boolean getXaClientEnabled() {
        return xaClientEnabled;
    }

    static int getXaLicenseMsg() {
        return xaLicenseMsg;
    }

    static void setXaLicenseMsg(int n) {
        xaLicenseMsg = n;
    }

    public static void traceSystemProperties() {
        block8: {
            if (Trace.isOn) {
                try {
                    Object t = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return System.getProperties();
                            }
                            catch (AccessControlException accessControlException) {
                                return null;
                            }
                        }
                    });
                    Properties properties = null;
                    if (t == null || !(t instanceof Properties)) {
                        if (Trace.isOn) {
                            Trace.trace("", "Failed to obtain system properties!");
                        }
                        return;
                    }
                    properties = (Properties)t;
                    Enumeration<?> enumeration = properties.propertyNames();
                    String string = System.getProperty("line.separator");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string + "        System Properties" + string);
                    stringBuffer.append("          =================" + string + string);
                    stringBuffer.append("Key                                    Value" + string);
                    stringBuffer.append("---                                    -----" + string + string);
                    String string2 = "";
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        stringBuffer.append(string2 + ":");
                        int n = 40 - string2.length();
                        while (n-- > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(properties.getProperty(string2) + string);
                    }
                    stringBuffer.append(string);
                    if (Trace.isOn) {
                        Trace.trace("", stringBuffer.toString());
                    }
                }
                catch (Throwable throwable) {
                    if (!Trace.isOn) break block8;
                    Trace.trace("", "Failed to obtain system properties!");
                }
            }
        }
    }

    static {
        block5: {
            securityExit = null;
            sendExit = null;
            receiveExit = null;
            hostname = "";
            port = 1414;
            channel = "";
            userID = "";
            password = "";
            CCSID = 819;
            hdrCompList = null;
            msgCompList = null;
            sslCipherSuite = null;
            sslPeerName = null;
            sslCertStores = null;
            sslSocketFactory = null;
            sslResetCount = 0;
            sslFipsRequired = false;
            localAddressSetting = null;
            connTag = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            connOptions = 0;
            properties = new Hashtable();
            poolTokenSet = new Vector();
            poolServices = new Vector();
            defaultMQCxManager = new MQSimpleConnectionManager();
            defaultCxManager = null;
            xaClientEnabled = false;
            xaLicenseMsg = 0;
            runningInWebSphere = false;
            forceAllowClient = false;
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, sccsid);
            }
            try {
                Class.forName("com.ibm.mq.OSE");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "OSE loaded");
                }
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block5;
                Trace.trace(CLASSNAME, "OSE not found");
            }
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.localAddress");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string != null && !string.trim().equals("")) {
            localAddressSetting = string;
        }
    }
}

