/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.mq.MQException;
import com.ibm.mq.SSLHelper;
import com.ibm.mq.jms.ISSL;
import com.ibm.mq.jms.ISSLException;
import com.ibm.mq.jms.ISSLSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class JsseImpl
implements ISSL {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/JsseImpl.java, disthub, j600, j600-101-060328 1.7.1.2 05/06/02 09:30:28";
    protected String[] cipherSuites = null;

    public Object createCredentials(Object object) throws ISSLException {
        Object object2;
        if (Trace.isOn) {
            Trace.entry(this, "createCredentials");
        }
        if ((object2 = BaseConfig.getBaseConfig().SSL_SOCKET_FACTORY) == null) {
            if (Trace.isOn) {
                Trace.trace(this, "createCredentials returning default SSLSocketFactory");
            }
            return SSLSocketFactory.getDefault();
        }
        if (!(object2 instanceof SSLSocketFactory)) {
            if (Trace.isOn) {
                Trace.trace(this, "createCredentials identified invalid SSLSocketFactory object");
            }
            throw new ISSLException(ConfigEnvironment.getMessage("MQJMS4131"));
        }
        if (Trace.isOn) {
            Trace.trace(this, "createCredentials returning user-specified SSLSocketFactory");
        }
        return object2;
    }

    public ISSLSession createSession(Socket socket, Object object, boolean bl, boolean bl2) throws ISSLException {
        if (!(object instanceof SSLSocketFactory)) {
            if (Trace.isOn) {
                Trace.trace(this, "createSession identified invalid SSLSocketFactory object");
            }
            throw new ISSLException(ConfigEnvironment.getMessage("MQJMS4131"));
        }
        try {
            if (Trace.isOn) {
                Trace.entry(this, "JsseImpl.createSession");
            }
            if (Trace.isOn) {
                Trace.trace(this, "Running SSL handshake over existing socket");
            }
            SSLSocket sSLSocket = SSLHelper.createSSLSocket("alreadydecided", 443, this.cipherSuites[0], BaseConfig.getBaseConfig().SSL_PEER_NAME, BaseConfig.getBaseConfig().SSL_CERT_STORES, (SSLSocketFactory)object, socket, bl2, bl);
            if (Trace.isOn) {
                Trace.trace(this, "Post-configuring socket");
            }
            if (Trace.isOn) {
                Trace.exit(this, "JsseImpl.createSession");
            }
            return new JsseImplSession(sSLSocket);
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(this, "MQException thrown in SSL Handshake");
                Trace.exit(this, "JsseImpl.createSession");
            }
            throw new ISSLException(mQException.getMessage());
        }
    }

    public String[] getEnabledCipherSuites() {
        return this.cipherSuites;
    }

    public void setEnabledCipherSuites(String string) throws ISSLException {
        if (Trace.isOn) {
            Trace.entry(this, "setEnabledCipherSuites");
        }
        if (Trace.isOn) {
            Trace.trace(this, "Setting ciphersuites to '" + string + "' Only first one used");
        }
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("")) continue;
                vector.add(string2);
            }
            this.cipherSuites = new String[vector.size()];
            vector.copyInto(this.cipherSuites);
        }
        if (Trace.isOn) {
            Trace.exit(this, "setEnabledCipherSuites");
        }
    }

    public void setProperty(String string, String string2) {
    }

    public String getProperty(String string) {
        return null;
    }

    class JsseImplSession
    implements ISSLSession {
        SSLSocket sessSock;

        public JsseImplSession(SSLSocket sSLSocket) {
            this.sessSock = sSLSocket;
        }

        public Socket getSocket() {
            return this.sessSock;
        }

        public byte[] getMasterSecret() {
            return null;
        }

        public String extractUserID() {
            block6: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "extractUserID");
                    }
                    X509Certificate[] x509CertificateArray = this.sessSock.getSession().getPeerCertificateChain();
                    if (Trace.isOn) {
                        Trace.trace(this, "Cert string: " + ((Object)x509CertificateArray[0].getSubjectDN()).toString());
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(((Object)x509CertificateArray[0].getSubjectDN()).toString(), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                        String string = stringTokenizer2.nextToken();
                        if (!string.equals("EmailAddress")) continue;
                        String string2 = stringTokenizer2.nextToken();
                        if (Trace.isOn) {
                            Trace.trace(this, "Returning email address " + string2);
                            Trace.exit(this, "extractUserID");
                        }
                        return string2;
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isOn) break block6;
                    Trace.trace(this, "Something went wrong parsing certificate");
                    Trace.exit(this, "extractUserID");
                }
            }
            return "";
        }
    }
}

