/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: ProductDB.java,v 1.3 2010/12/20 09:40:40 pmuessig Exp $
 */
package ch.e2e.examples.list;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Holds the list of all products.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public class ProductDB {
	/**
	 * The one and only instance of this class.
	 */
	private static ProductDB db = new ProductDB();
	/**
	 * The map of products, using the product id as key.
	 */
	private HashMap<String, Product> products = new HashMap<String, Product>();

	/**
	 * Reads the product informations from the file <code>ch/e2e/examples/list/products.xml</code>
	 */
	private ProductDB() {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(getClass().getClassLoader().getResourceAsStream("ch/e2e/examples/list/products.xml"));
			NodeList customerList = document.getDocumentElement().getElementsByTagName("product");
			int length = customerList.getLength();
			for (int i = 0; i < length; i++) {
				Element customerNode = (Element)customerList.item(i);
				addProduct(customerNode);
			}
		} catch (Exception e) {
			// ignore
		}
	}

	/**
	 * Adds a product, defined by its xml element.
	 * @param productNode The xml element defining the product.
	 */
	private void addProduct(Element productNode) {
		Product product = new Product();
		NodeList idList = productNode.getElementsByTagName("id");
		String id = idList.item(0).getFirstChild().getNodeValue();
		product.setId(id);
		NodeList priceList = productNode.getElementsByTagName("price");
		double price = Double.parseDouble(priceList.item(0).getFirstChild().getNodeValue());
		product.setPrice(price);
		Description description = new Description();
		NodeList nameList = productNode.getElementsByTagName("name");
		String name = nameList.item(0).getFirstChild().getNodeValue();
		description.setName(name);
		NodeList shortDescriptionList = productNode.getElementsByTagName("shortDescription");
		String shortDescription = shortDescriptionList.item(0).getFirstChild().getNodeValue();
		description.setShortDescription(shortDescription);
		NodeList detailedDescriptionList = productNode.getElementsByTagName("detailedDescription");
		String detailedDescription = detailedDescriptionList.item(0).getFirstChild().getNodeValue();
		description.setDetailedDescription(detailedDescription);
		product.setDescription(description);
		products.put(id, product);
	}

	/**
	 * Returns the instance of this class.
	 * @return The instance of this class.
	 */
	public static ProductDB getInstance() {
		return db;
	}

	/**
	 * Returns the product for a given product id.
	 * @param productID
	 * @return The customer for a given product id, or <code>null</code> if
	 * no such product exsits.
	 */
	public synchronized Product findProduct(String productID) {
		return products.get(productID);
	}

	/**
	 * Returns all existing product ids.
	 * @return All existing product ids.
	 */
	public synchronized List<String> getAllProductIds() {
		return new ArrayList<String>(products.keySet());
	}
}
