/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageProducerImpl;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class TopicPublisherImpl
extends MessageProducerImpl
implements TopicPublisher,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/TopicPublisherImpl.java, disthub, j600, j600-101-060328 1.29.1.1 05/05/25 15:23:57";
    private static final DebugObject debug = new DebugObject("TopicPublisherImpl");

    TopicPublisherImpl(Topic topic, TopicSessionImpl topicSessionImpl) throws JMSNotActiveException, InvalidDestinationException {
        super((Destination)topic, topicSessionImpl);
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void publish(Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publish");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.trace(this, "topic == null - JMSNotSupportedException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        this.publish(message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "publish");
        }
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null - JMSNotSupportedException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS6402";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(this.topic, messageImpl, n, n2, l);
    }

    private MessageImpl createGryphonDomesticMessage(Message message) throws JMSException {
        Object object;
        if (message instanceof MessageImpl) {
            return (MessageImpl)message;
        }
        MessageImpl messageImpl = null;
        SessionImpl sessionImpl = this.getSession();
        Class<?> clazz = message.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getName().equals("javax.jms.ByteMessage")) {
                messageImpl = (BytesMessageImpl)sessionImpl.createBytesMessage();
                object = new byte[256];
                int n = -1;
                while ((n = ((BytesMessage)message).readBytes((byte[])object)) == ((byte[])object).length) {
                    ((BytesMessage)messageImpl).writeBytes((byte[])object);
                }
                if (n == -1) break;
                ((BytesMessage)messageImpl).writeBytes((byte[])object, 0, n);
                break;
            }
            if (classArray[i].getName().equals("javax.jms.StreamMessage")) {
                messageImpl = (StreamMessageImpl)sessionImpl.createStreamMessage();
                try {
                    while (true) {
                        ((StreamMessage)messageImpl).writeObject(((StreamMessage)message).readObject());
                    }
                }
                catch (MessageEOFException messageEOFException) {
                    break;
                }
            }
            if (classArray[i].getName().equals("javax.jms.TextMessage")) {
                messageImpl = (TextMessageImpl)sessionImpl.createTextMessage();
                ((TextMessage)messageImpl).setText(((TextMessage)message).getText());
                break;
            }
            if (classArray[i].getName().equals("javax.jms.ObjectMessage")) {
                messageImpl = (ObjectMessageImpl)sessionImpl.createObjectMessage();
                ((ObjectMessage)messageImpl).setObject(((ObjectMessage)message).getObject());
                break;
            }
            if (!classArray[i].getName().equals("javax.jms.MapMessage")) continue;
            messageImpl = (MapMessageImpl)sessionImpl.createMapMessage();
            object = ((MapMessage)messageImpl).getMapNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                ((MapMessage)messageImpl).setObject(string, ((MapMessage)message).getObject(string));
            }
            break;
        }
        if (messageImpl == null) {
            messageImpl = new MessageImpl();
        }
        messageImpl.setJMSCorrelationID(message.getJMSCorrelationID());
        messageImpl.setJMSPriority(message.getJMSPriority());
        messageImpl.setJMSExpiration(message.getJMSExpiration());
        messageImpl.setJMSType(message.getJMSType());
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            messageImpl.setObjectProperty((String)object, message.getObjectProperty((String)object));
        }
        return messageImpl;
    }

    public void publish(Topic topic, Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null, JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string2);
        }
        if (!(topic instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "Not an MQ Topic");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)topic;
        if (mQTopic.containsWildcard()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "InvalidDestinationException");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
        }
        this.publish(mQTopic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (topic != null && topic instanceof TemporaryTopicImpl && ((TemporaryTopicImpl)topic).isDeleted()) {
            String string = "MQJMS3019";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string3);
        }
        if (!(topic instanceof MQTopic)) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)topic;
        if (mQTopic.containsWildcard()) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS6402";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string4, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(mQTopic, messageImpl, n, n2, l);
    }

    public void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        TopicSessionImpl topicSessionImpl = (TopicSessionImpl)this.getSession();
        if (topicSessionImpl != null) {
            topicSessionImpl.closed(this);
        }
        super.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

