/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.MessageImpl;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.mq.jms.GenericMessage;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class MsgConverter
implements ClientLogConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MsgConverter.java, disthub, j600, j600-101-060328 1.10.1.1 05/05/25 15:43:53";
    private static final DebugObject debug = new DebugObject("MsgConverter");

    private MsgConverter() {
    }

    public static void fromGryphon(MessageImpl messageImpl, GenericMessage genericMessage) {
        Object object;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"fromGryphon", (Object)messageImpl, (Object)genericMessage);
        }
        genericMessage.setMessageType(messageImpl.getMessageType());
        genericMessage.setTopic(messageImpl.getTopicString());
        genericMessage.setReplyTopic(messageImpl.getReplyString());
        genericMessage.setMessageID(messageImpl.getMessageID());
        genericMessage.setMDT(messageImpl.cursor.getByteArray(0));
        genericMessage.setJMSCorrelationID(messageImpl.getCorrelationID());
        genericMessage.setJMSDeliveryMode(1);
        genericMessage.setJMSExpiration(messageImpl.getJMSExpirationField());
        genericMessage.setJMSPriority(messageImpl.getPriority());
        genericMessage.setJMSRedelivered(false);
        genericMessage.setJMSTimestamp(messageImpl.getTimestamp());
        genericMessage.setJMSType(messageImpl.getJMSTypeField());
        Dictionary dictionary = messageImpl.getProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            genericMessage.setProperty((String)object, dictionary.get(object));
        }
        switch (messageImpl.getMessageType()) {
            case 1: {
                break;
            }
            case 3: {
                genericMessage.setBody(messageImpl.getBytesBody());
                break;
            }
            case 5: {
                enumeration = messageImpl.getFields().elements();
                while (enumeration.hasMoreElements()) {
                    genericMessage.setField(enumeration.nextElement());
                }
                break;
            }
            case 6: {
                enumeration = messageImpl.getNamedFields();
                object = ((Dictionary)((Object)enumeration)).keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    genericMessage.setField(string, ((Dictionary)((Object)enumeration)).get(string));
                }
                break;
            }
            case 2: {
                genericMessage.setBody(messageImpl.getObjectRaw());
                break;
            }
            case 4: {
                genericMessage.setText(messageImpl.getTextBody());
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"fromGryphon");
        }
    }

    public static MessageImpl toGryphon(GenericMessage genericMessage) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"toGryphon", (Object)genericMessage);
        }
        MessageImpl messageImpl = new MessageImpl();
        messageImpl.setTopicString(genericMessage.getTopic());
        messageImpl.setReplyString(genericMessage.getReplyTopic());
        messageImpl.setMessageID(genericMessage.getMessageID());
        messageImpl.cursor.setByteArray(0, genericMessage.getMDT());
        messageImpl.setCorrelationID(genericMessage.getJMSCorrelationID());
        messageImpl.setPriority(genericMessage.getJMSPriority());
        messageImpl.setTimestamp(genericMessage.getJMSTimestamp());
        messageImpl.setJMSTypeField(genericMessage.getJMSType());
        Hashtable hashtable = new Hashtable();
        Object object = genericMessage.getProperties();
        while (object.hasMoreElements()) {
            hashtable.put(object.getName(), object.nextElement());
        }
        messageImpl.setProperties(hashtable);
        switch (genericMessage.getMessageType()) {
            case 1: {
                break;
            }
            case 3: {
                messageImpl.setBytesBody(genericMessage.getBody());
                break;
            }
            case 5: {
                object = new Vector();
                Enumeration enumeration = genericMessage.getFields();
                while (enumeration.hasMoreElements()) {
                    ((Vector)object).addElement(enumeration.nextElement());
                }
                messageImpl.setFields((Vector)object);
                break;
            }
            case 6: {
                Hashtable hashtable2 = new Hashtable();
                GenericMessage.NamedEnumeration namedEnumeration = genericMessage.getNamedFields();
                while (namedEnumeration.hasMoreElements()) {
                    hashtable2.put(namedEnumeration.getName(), namedEnumeration.nextElement());
                }
                messageImpl.setNamedFields(hashtable2);
                break;
            }
            case 2: {
                messageImpl.setObjectRaw(genericMessage.getBody());
                break;
            }
            case 4: {
                messageImpl.setTextBody(genericMessage.getText());
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"toGryphon");
        }
        return messageImpl;
    }
}

