/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.FormattedMessage;
import com.ibm.disthub2.impl.matching.MatchingContext;
import com.ibm.disthub2.impl.matching.selector.BooleanValue;
import com.ibm.disthub2.impl.matching.selector.EvalContext;
import com.ibm.disthub2.impl.matching.selector.Evaluator;
import com.ibm.disthub2.impl.matching.selector.MatchParser;
import com.ibm.disthub2.impl.matching.selector.Selector;
import com.ibm.disthub2.impl.matching.selector.TokenMgrError;
import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.SelectorDataAccessor;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQMessageSelector {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/MQMessageSelector.java, jms, j600, j600-101-060328 1.40.1.1 05/05/25 15:24:05";
    private static final String JMSCORRELATIONID = "JMSCorrelationID";
    private static final String JMSMESSAGEID = "JMSMessageID";
    private static final int ID_LENGTH = 24;
    private MatchParser matchParser = null;
    private Selector selectorTree = null;
    private String specialSelector = null;

    public MQMessageSelector() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelector() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSelector");
            }
            String string = this.selectorTree == null ? this.specialSelector : this.selectorTree.toString();
            String string2 = string;
            return string2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSelector");
            }
        }
    }

    public boolean isSelected(JMSMessage jMSMessage, MQMsg2 mQMsg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "isSelected");
        }
        try {
            boolean bl;
            block14: {
                if (this.selectorTree == null) {
                    bl = true;
                } else {
                    try {
                        SelectorDataAccessor selectorDataAccessor = new SelectorDataAccessor(jMSMessage, mQMsg2);
                        MatchingContext matchingContext = new MatchingContext();
                        matchingContext.setMessage((FormattedMessage)selectorDataAccessor);
                        Object object = Evaluator.eval((Selector)this.selectorTree, (EvalContext)matchingContext, (boolean)false);
                        if (object instanceof BooleanValue) {
                            bl = ((BooleanValue)object).booleanValue();
                            break block14;
                        }
                        if (object == null) {
                            bl = false;
                            break block14;
                        }
                        throw new JMSException("Need a message here");
                    }
                    catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
                        boolean bl2 = false;
                        throw new JMSException(badMessageFormatMatchingException.toString());
                    }
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "isSelected", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isSelected");
            }
        }
    }

    public void setSelector(String string) throws SyntaxException {
        if (Trace.isOn) {
            Trace.entry(this, "setSelector(selector)");
        }
        this.setSelector(string, null);
        if (Trace.isOn) {
            Trace.exit(this, "setSelector(selector)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSelector(String string, MQMsg2 mQMsg2) throws SyntaxException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSelector(selector, mqmd)");
            }
            boolean bl = this.setSelector(string, mQMsg2, null);
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setSelector(selector, mqmd)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSelector(String string, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws SyntaxException {
        if (Trace.isOn) {
            Trace.entry(this, "setSelector(selector, mqmsg2, gmo)");
        }
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String string2;
            if (mQMsg2 != null && string != null && string.length() > 0) {
                string2 = new String(string.trim());
                try {
                    object3 = null;
                    object2 = null;
                    object = null;
                    int n = 0;
                    boolean bl2 = false;
                    if (string2.startsWith(JMSCORRELATIONID)) {
                        string2 = string2.substring(JMSCORRELATIONID.length()).trim();
                        n = 24;
                        bl2 = true;
                        object3 = object = (Object)new byte[n];
                        if (mQGetMessageOptions != null) {
                            mQGetMessageOptions.matchOptions |= 2;
                        }
                    }
                    if (string2.startsWith(JMSMESSAGEID)) {
                        string2 = string2.substring(JMSMESSAGEID.length()).trim();
                        n = 24;
                        bl2 = true;
                        object3 = object2 = (Object)new byte[n];
                        if (mQGetMessageOptions != null) {
                            mQGetMessageOptions.matchOptions |= 1;
                        }
                    }
                    if (bl2 && string2.charAt(0) == '=' && (string2 = string2.substring(1).trim()).startsWith("'ID:")) {
                        boolean bl3 = false;
                        if ((string2 = string2.substring(4).toLowerCase()).length() == n * 2 + 1 && string2.charAt(n * 2) == '\'') {
                            bl3 = true;
                            for (int i = 0; i < 24; ++i) {
                                int n2 = 0;
                                char c = string2.charAt(i * 2);
                                if (c >= '0' && c <= '9') {
                                    n2 += c - 48;
                                } else if (c >= 'a' && c <= 'f') {
                                    n2 += c - 97 + 10;
                                } else {
                                    bl3 = false;
                                }
                                n2 *= 16;
                                char c2 = string2.charAt(i * 2 + 1);
                                if (c2 >= '0' && c2 <= '9') {
                                    n2 += c2 - 48;
                                } else if (c2 >= 'a' && c2 <= 'f') {
                                    n2 += c2 - 97 + 10;
                                } else {
                                    bl3 = false;
                                }
                                object3[i] = (byte)n2;
                            }
                        }
                        if (bl3) {
                            bl = true;
                        }
                    }
                    if (object2 != null) {
                        mQMsg2.setMessageId((byte[])object2);
                    } else if (object != null) {
                        mQMsg2.setCorrelationId((byte[])object);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "Selector is a special case.");
                }
                this.specialSelector = string;
            } else {
                this.matchParser = MatchParser.prime(null, (String)string, (boolean)true);
                try {
                    this.selectorTree = this.matchParser.getSelector();
                }
                catch (TokenMgrError tokenMgrError) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Selector was Invalid");
                        Trace.exception(this, "TokenMgrError thrown:", (Throwable)tokenMgrError);
                    }
                    object3 = "MQJMS0004";
                    object2 = ConfigEnvironment.getErrorMessage((String)object3);
                    object = new SyntaxException((String)object2);
                    throw object;
                }
                if (this.selectorTree.type == 2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Selector was Invalid");
                    }
                    string2 = "MQJMS0004";
                    object3 = ConfigEnvironment.getErrorMessage(string2);
                    object2 = new SyntaxException((String)object3);
                    throw object2;
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setSelector(selector, mqmsg2, gmo)");
            }
        }
    }
}

