/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.examples.service;

import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.session.SessionPool;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.Callback;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class HelloWorldCallbackImpl implements HelloWorldCallback {
	public void sendText(String text) {
		Session session = SessionPool.getInstance().createSession();

		RecordItem inputItem = ItemFactory.createRecordItem(session);
		RecordItem outputItem = ItemFactory.createRecordItem(session);
		ArrayItem errorItem = ItemFactory.createArrayItem(session);
		StringItem textItem = ItemFactory.createStringItem(session);
		try {
			textItem.setValueFromString(text);
		} catch (UnsupportedEncodingException e) {
			// ignore
		}
		inputItem.setItem(0, textItem, true);
		Callback.invoke("sendText...javaCallback_713690829|_14_0_1_c3202fe_1228744452831_389409_6538",
				inputItem, outputItem, errorItem);
	}
}
