/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.bridge.server.office;

import java.util.*;

@SuppressWarnings("UnusedDeclaration")
public class Row {
    private int rowNum;
    private int numberOfCells;
    private List<Cell> cells;

    Row(org.apache.poi.ss.usermodel.Row poiRow, Workbook workbook) {
        rowNum = poiRow.getRowNum();
        cells = new CellList(poiRow, workbook);
    }

    public Row() {
    }

    public List<Cell> getCells() {
        return cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = new CellList(cells);
    }

    public int getRowNum() {
        return rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getNumberOfCells() {
        return cells.size();
    }

    public void setNumberOfCells(int numberOfCells) {
//		this.numberOfCells = numberOfCells;
    }

    int getPhysicalNumberOfCells() {
        return ((CellList)cells).getPhysicalSize();
    }

    private static class CellList extends AbstractList<Cell> {
        private final int size;
        private final Map<Integer, Cell> map;

        CellList(org.apache.poi.ss.usermodel.Row poiRow, Workbook workbook) {
            size = poiRow.getLastCellNum();
            map = new HashMap<Integer, Cell>();
            for (int i = poiRow.getFirstCellNum(); i < size; i++) {
                final org.apache.poi.ss.usermodel.Cell poiCell = poiRow.getCell(i);
                if (poiCell != null) {
                    Cell cell = new Cell(poiCell, workbook);
                    if (!(workbook.getOmitEmptyCells() && cell.getValue().isEmpty())) {
                        map.put(poiCell.getColumnIndex(), cell);
                    }
                }
            }
        }

        CellList(List<Cell> list) {
            if (list == null) {
                size = 0;
                map = Collections.emptyMap();
            } else {
                size = list.size();
                map = new HashMap<Integer, Cell>();
                for (int i = 0; i < size; i++) {
                    final Cell cell = list.get(i);
                    if (cell != null) map.put(i, cell);
                }
            }
        }

        @Override
        public Cell get(int index) {
            if (index < 0 || index >= size) throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
            return map.get(index);
        }

        @Override
        public int size() {
            return size;
        }

        int getPhysicalSize() {
            return map.size();
        }
    }
}
