/*
 * e2e technologies Ltd.
 * Project: JavaAddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Characters.java,v 1.2 2010/12/20 16:50:32 pmuessig Exp $
 */
package ch.e2e.examples.simple;

/**
 * Shows you how to handle with characters in the E2E Bridge.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the methods:<br>
 * <ul>
 * <code><li><a href="#toUpperCase(char)">public char toUpperCase(char ch)</a></li></code>
 * <code><li><a href="#toLowerCase(char)">public char toLowerCase(char ch)</a></li></code>
 * <code><li><a href="#toUpperCase(char[])">public char[] toUpperCase(char[] chArray)</a></li></code>
 * <code><li><a href="#toLowerCase(char[])">public char[] toLowerCase(char[] chArray)</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.2 $
 */
public class Characters {
	/**
	 * Returns the uppercase value of the given character.
	 * @param character The character to convert.
	 * @return the uppercase value of the given character.
	 */
	public static char toUpperCase(char character) {
		return Character.toUpperCase(character);
	}

	/**
	 * Returns the lowercase value of the given character.
	 * @param character The character to convert.
	 * @return the uppercase value of the given character.
	 */
	public static char toLowerCase(char character) {
		return Character.toLowerCase(character);
	}

	/**
	 * Returns the uppercase values of the given characters.
	 * @param characters The characters to convert.
	 * @return the uppercase values of the given characters.
	 */
	public static char[] toUpperCase(char[] characters) {
		String resultStr = new String(characters).toUpperCase();
		return resultStr.toCharArray();
	}

	/**
	 * Returns the lowercase values of the given characters.
	 * @param characters The characters to convert.
	 * @return the uppercase values of the given characters.
	 */
	public static char[] toLowerCase(char[] characters) {
		String resultStr = new String(characters).toLowerCase();
		return resultStr.toCharArray();
	}
}
