/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQPSStatusMgr;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQQueueSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueSubscriptionEngine.java, jms, j600, j600-101-060328 1.32.1.3 05/09/13 18:36:53";
    private static final int REGISTER_SUBSCRIBER = 1;
    private static final int DEREGISTER_SUBSCRIBER = 2;
    private static final int REGISTER_PUBLISHER = 3;
    private static final int DEREGISTER_PUBLISHER = 4;
    private MQPSStatusMgr pubsubStatusMgr;
    private byte[] statusMgrId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueueSubscriptionEngine(MQConnection mQConnection, MQQueueManager mQQueueManager) {
        super(mQConnection);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        try {
            this.pubsubStatusMgr = new MQPSStatusMgr(mQQueueManager, mQConnection.getBrkControlQueue(), mQConnection.getBrkPubQueue());
            this.statusMgrId = this.pubsubStatusMgr.addConnection(mQConnection);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "Constructor", (Throwable)jMSException);
            }
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
            return;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    public MQSubscription openSubscription(MQSession mQSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2) throws JMSException {
        MQQueue mQQueue = null;
        MQQueueSubscription mQQueueSubscription = null;
        byte[] byArray = null;
        boolean bl3 = false;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription()");
        }
        try {
            int n = 1;
            if (mQTopic != null) {
                n = mQTopic.getFailIfQuiesce();
            } else if (mQSession != null) {
                n = mQSession.getFailIfQuiesce();
            }
            mQQueueSubscription = new MQQueueSubscription(this, mQSession, false, bl2, mQSession.qm.name, this.getMQConnection().getClientID(), null, mQTopic, string, bl, string2, null, null);
            if (Trace.isOn) {
                Trace.trace(this, "setting StatusMgrId = " + Utils.bytesToHex(this.statusMgrId));
            }
            mQQueueSubscription.setStatusMgrId(this.statusMgrId);
            mQQueue = this.openSubscriberQueue(mQSession, string2, bl2, false, n);
            mQQueueSubscription.setSubscriberQueue(mQQueue);
            mQQueueSubscription.setQueueName(mQQueue.name);
            byArray = MQQueueSubscriptionEngine.addNDSubscriptionEntry(mQQueueSubscription);
            mQQueueSubscription.setCorrelationId(byArray);
            if (Trace.isOn) {
                Trace.trace(this, "Using correl ID = " + Utils.bytesToHex(byArray));
            }
            try {
                this.sendBrokerCommand(mQQueueSubscription, 1, true);
                bl3 = true;
            }
            catch (NoBrokerResponseException noBrokerResponseException) {
                bl3 = true;
                throw noBrokerResponseException;
            }
            catch (BrokerCommandFailedException brokerCommandFailedException) {
                throw brokerCommandFailedException;
            }
        }
        catch (JMSException jMSException) {
            boolean bl4;
            block34: {
                block33: {
                    if (Trace.isOn) {
                        Trace.trace(this, "cleaning up partial subscription");
                    }
                    bl4 = false;
                    if (bl3) {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "deregistering");
                            }
                            this.sendBrokerCommand(mQQueueSubscription, 2, true);
                        }
                        catch (JMSException jMSException2) {
                            bl4 = true;
                            if (!Trace.isOn) break block33;
                            Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException2));
                            Exception exception = jMSException2.getLinkedException();
                            if (exception == null) break block33;
                            Trace.trace(this, "linked exception = " + exception);
                        }
                    }
                }
                if (mQQueue != null) {
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "deleting subscription queue");
                        }
                        if (!bl2) {
                            mQQueue.closeOptions = 2;
                        }
                        mQQueue.close();
                    }
                    catch (Exception exception) {
                        bl4 = true;
                        if (!Trace.isOn) break block34;
                        Trace.trace(this, "queue delete failed with " + exception);
                    }
                }
            }
            if (!bl4) {
                MQQueueSubscriptionEngine.removeNDSubscriptionEntry(mQQueueSubscription);
            }
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception = " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "openSubscriber()");
            }
        }
        return mQQueueSubscription;
    }

    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "closeSubscription");
        }
        try {
            MQQueueSubscription mQQueueSubscription;
            block24: {
                mQQueueSubscription = null;
                if (!(mQSubscription instanceof MQQueueSubscription)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    if (Trace.isOn) {
                        Trace.exception(this, "closeSubscription", (Throwable)jMSException);
                        Trace.exit(this, "closeSubscription");
                    }
                    throw jMSException;
                }
                mQQueueSubscription = (MQQueueSubscription)mQSubscription;
                MQSession mQSession = mQQueueSubscription.getMQSession();
                if (!mQQueueSubscription.isDurable()) {
                    try {
                        if (mQQueueSubscription.isClosed()) {
                            if (mQQueueSubscription.getSubscriberQueue() != null) {
                                SubscriptionHelper.deleteSubscriberMessages(mQQueueSubscription);
                            }
                        } else {
                            this.deleteSubscriber(mQQueueSubscription);
                        }
                        mQQueueSubscription.setSubscriberQueue(null);
                    }
                    catch (JMSException jMSException) {
                        Exception exception = jMSException.getLinkedException();
                        if (exception instanceof MQException && ((MQException)exception).reasonCode == 2055) {
                            if (Trace.isOn) {
                                Trace.trace(this, "close ignoring MQException 2055");
                            }
                            break block24;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "closeSubscription() ignoring exception " + (Object)((Object)jMSException));
                            if (exception != null) {
                                Trace.trace(this, "linked exception " + exception);
                            }
                        }
                        mQQueueSubscription.setSubscriberQueue(null);
                    }
                } else {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    if (Trace.isOn) {
                        Trace.exception(this, "closeSubscription", (Throwable)jMSException);
                        Trace.exit(this, "closeSubscription");
                    }
                    throw jMSException;
                }
            }
            if (!mQQueueSubscription.isClosed() && !mQQueueSubscription.isDurable()) {
                MQQueueSubscriptionEngine.removeNDSubscriptionEntry(mQQueueSubscription);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeSubscription");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openDurableSubscription(MQSession mQSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2, String string3) throws JMSException {
        MQQueueSubscription mQQueueSubscription;
        block30: {
            Object var8_8 = null;
            MQQueue mQQueue = null;
            MQQueueSubscription mQQueueSubscription2 = null;
            MQQueueSubscription mQQueueSubscription3 = null;
            mQQueueSubscription = null;
            Object var13_13 = null;
            if (Trace.isOn) {
                Trace.entry(this, "openDurableSubscription()");
            }
            try {
                block29: {
                    try {
                        String string4;
                        if (Trace.isOn) {
                            Trace.trace(this, "Topic name = " + mQTopic.getBaseTopicName());
                            Trace.trace(this, "Sub Q name = " + string2);
                            Trace.trace(this, "sub Name   = " + string3);
                            Trace.trace(this, "Selector   = " + string);
                            Trace.trace(this, "noLocal    = " + bl);
                        }
                        int n = 1;
                        if (mQTopic != null) {
                            n = mQTopic.getFailIfQuiesce();
                        } else if (mQSession != null) {
                            n = mQSession.getFailIfQuiesce();
                        }
                        mQQueue = this.getAdminQueueAccess(mQSession, n);
                        String string5 = this.getMQConnection().getClientID();
                        if (string5 == null) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                            throw jMSException;
                        }
                        mQQueueSubscription3 = new MQQueueSubscription(this, mQSession, true, bl2, mQSession.qm.name, string5, string3, mQTopic, string, bl, string2, null, null);
                        mQQueueSubscription2 = this.getResolvedSubscription(mQQueue, mQQueueSubscription3, null, false);
                        if (mQQueueSubscription2 == null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "DurSubEntry not found; new durable subscriber");
                                Trace.trace(this, "setting StatusMgrId = " + Utils.bytesToHex(this.statusMgrId));
                            }
                            mQQueueSubscription3.setStatusMgrId(this.statusMgrId);
                            mQQueueSubscription = this.createNewDurableSubscription(mQQueue, mQQueueSubscription3);
                            break block29;
                        }
                        String string6 = mQQueueSubscription3.getSelector();
                        if (string6 == null) {
                            string6 = "";
                        }
                        if ((string4 = mQQueueSubscription2.getSelector()) == null) {
                            string4 = "";
                        }
                        if (mQQueueSubscription3.getFullName().equals(mQQueueSubscription2.getFullName()) && mQQueueSubscription3.getTopic().equals(mQQueueSubscription2.getTopic()) && string6.equals(string4)) {
                            String string7;
                            if (Trace.isOn) {
                                Trace.trace(this, "Found an entry for this client");
                                Trace.trace(this, "Name                  = " + mQQueueSubscription2.getSubName());
                                Trace.trace(this, "Topic name            = " + mQQueueSubscription2.getTopic());
                                Trace.trace(this, "Subscriber queue name = " + mQQueueSubscription2.getQueueName());
                                Trace.trace(this, "Comparing given subscriber queue name: " + string2);
                            }
                            if (!(string7 = mQQueueSubscription2.getQueueName().trim()).equals(string2 = string2.trim())) {
                                if (!string2.endsWith("*")) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string2, string7);
                                    throw jMSException;
                                }
                                if (mQQueueSubscription2.isSharedQueue() || !string7.regionMatches(0, string2, 0, string2.length() - 1)) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string2, string7);
                                    throw jMSException;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Using original subscriber queue: " + string7);
                                }
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Reset durable subscriber options");
                            }
                            try {
                                this.sendBrokerCommand(mQQueueSubscription2, 1, true);
                            }
                            catch (NoBrokerResponseException noBrokerResponseException) {
                                if (!Trace.isOn) throw noBrokerResponseException;
                                Trace.trace(this, "re-subscribe command failed");
                                throw noBrokerResponseException;
                            }
                            mQQueueSubscription = this.createExistingDurableSubscription(mQQueue, mQQueueSubscription2);
                            break block29;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Updating a durable subscriber:");
                            Trace.trace(this, "Old subscriber: " + mQQueueSubscription2.toString());
                            Trace.trace(this, "New subscriber: " + mQQueueSubscription3.toString());
                        }
                        mQQueueSubscription = this.createUpdatedDurableSubscriber(mQQueue, mQQueueSubscription3);
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception == null) throw jMSException;
                        Trace.trace(this, "linked exception " + exception);
                        throw jMSException;
                    }
                }
                Object var21_25 = null;
                if (mQQueue == null) break block30;
            }
            catch (Throwable throwable) {
                Object var21_26 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = new JMSException("MQJMS2000");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "createDurableSubscription(t,n,s,n)");
                throw throwable;
            }
            try {}
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            mQQueue.close();
        }
        if (!Trace.isOn) return mQQueueSubscription;
        Trace.exit(this, "createDurableSubscription(t,n,s,n)");
        return mQQueueSubscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        boolean bl = true;
        MQQueue mQQueue = null;
        if (Trace.isOn) {
            Trace.entry(this, "closeDurableSubscription");
        }
        try {
            MQQueueSubscription mQQueueSubscription = null;
            if (!(mQSubscription instanceof MQQueueSubscription)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005");
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "closeDurableSubscription", (Throwable)jMSException);
                Trace.exit(this, "closeDurableSubscription");
                throw jMSException;
            }
            mQQueueSubscription = (MQQueueSubscription)mQSubscription;
            if (!mQQueueSubscription.isDurable()) {
                return;
            }
            if (mQQueueSubscription.getSubscriberQueue() == null) return;
            MQQueue mQQueue2 = null;
            try {
                try {
                    mQQueue2 = mQQueueSubscription.getSubscriberQueue();
                    mQQueue2.close();
                    mQQueue2 = null;
                    int n = 1;
                    if (mQQueueSubscription.getMQTopic() != null) {
                        n = mQQueueSubscription.getMQTopic().getFailIfQuiesce();
                    } else if (mQQueueSubscription.getMQSession() != null) {
                        n = mQQueueSubscription.getMQSession().getFailIfQuiesce();
                    }
                    mQQueue = this.getAdminQueueAccess(mQQueueSubscription.getMQSession(), n);
                    mQQueueSubscription.setSubscriberState('i');
                    if (Trace.isOn) {
                        Trace.trace(this, "Add new subscription entry");
                    }
                    this.addSubscriptionEntry(mQQueue, mQQueueSubscription, false);
                    if (Trace.isOn) {
                        Trace.trace(this, "Remove old subscription entry");
                    }
                    this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", mQQueueSubscription.getQueueName());
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                }
                Object var9_11 = null;
                if (mQQueue == null) return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (mQQueue == null) throw throwable;
                try {
                    mQQueue.close();
                    throw throwable;
                }
                catch (MQException mQException) {
                    JMSException jMSException = new JMSException("MQJMS2000");
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                }
            }
            try {}
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            mQQueue.close();
            return;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            Exception exception = jMSException.getLinkedException();
            if (exception == null) throw jMSException;
            Trace.trace(this, "linked exception " + exception);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeDurableSubscription");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableUnsubscribe(MQSession mQSession, String string) throws JMSException {
        block12: {
            MQQueue mQQueue = null;
            try {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "durableUnsubscribe");
                    }
                    if (mQSession.isClosed()) {
                        String string2 = "MQJMS1024";
                        String string3 = ConfigEnvironment.getErrorMessage(string2);
                        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                        if (!Trace.isOn) throw illegalStateException;
                        Trace.trace(this, "Session is closed. Throwing IllegalStateException.");
                        throw illegalStateException;
                    }
                    int n = 1;
                    if (mQSession != null) {
                        n = mQSession.getFailIfQuiesce();
                    }
                    mQQueue = this.getAdminQueueAccess(mQSession, n);
                    this.unsubscribe(mQQueue, mQSession, string);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception = " + exception);
                    throw jMSException;
                }
                Object var8_10 = null;
                if (mQQueue == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = new JMSException("MQJMS2000");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "durableUnsubscribe");
                throw throwable;
            }
            try {}
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            mQQueue.close();
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "durableUnsubscribe");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            if (this.pubsubStatusMgr != null) {
                MQConnection mQConnection = this.getMQConnection();
                this.pubsubStatusMgr.removeConnection(mQConnection.qmgrName, mQConnection.mqProperties, mQConnection.getConnectionID());
                this.pubsubStatusMgr.close();
                this.pubsubStatusMgr = null;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Problem encountered closing MQQueueSubscriptionEngine");
                Trace.exception(this, "close", (Throwable)jMSException);
                Trace.exit(this, "Close");
            }
            return;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Close");
            }
        }
    }

    private static byte[] addNDSubscriptionEntry(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
        }
        MQQueue mQQueue = null;
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQSession().qm;
        byte[] byArray = null;
        MQMessage mQMessage = mQQueueSubscription.toMessage();
        try {
            mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8208);
            mQQueue.put(mQMessage);
            byArray = mQMessage.messageId;
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exception("MQQueueSubscriptionEngine", "addNDSubscriptionEntry", (Throwable)jMSException);
                Trace.exit("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
        }
        return byArray;
    }

    private static void removeNDSubscriptionEntry(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
        }
        MQQueue mQQueue = null;
        MQMessage mQMessage = new MQMessage();
        mQMessage.messageId = mQQueueSubscription.getCorrelationId();
        try {
            MQQueueManager mQQueueManager = mQQueueSubscription.getMQSession().qm;
            mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8194);
            mQQueue.get(mQMessage);
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exception("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry", (Throwable)jMSException);
                Trace.exit("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
        }
    }

    private MQQueueSubscription getResolvedSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription, byte[] byArray, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getResolvedSubscription");
        }
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQSession().qm;
        BrokerConnectionInfo brokerConnectionInfo = mQQueueSubscription.getMQSession().getBrk();
        String string = mQQueueSubscription.getFullName();
        MQQueueSubscription mQQueueSubscription2 = null;
        MQSubscription mQSubscription = null;
        mQQueueSubscription2 = this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQSession(), string, null, null, bl);
        if (mQQueueSubscription2 != null) {
            mQQueueSubscription2.setDurable(true);
            if (Trace.isOn) {
                Trace.trace(this, "Matching subscriber found. Checking for a second record.");
            }
            mQSubscription = this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQSession(), null, mQQueueSubscription2.getCorrelationId(), null, true);
        }
        if (mQSubscription != null) {
            mQSubscription.setDurable(true);
            if (Trace.isOn) {
                Trace.trace(this, "Second record found: earlier problem must have occurred.");
            }
            if (this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQSession(), null, mQQueueSubscription2.getCorrelationId(), null, false) == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "getResolved ERROR: couldn't reset browse cursor position");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
                throw jMSException;
            }
            if (mQQueueSubscription2.getSubscriberState() == 't' || ((MQQueueSubscription)mQSubscription).getSubscriberState() == 't') {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                this.deleteSubscriber(mQQueueSubscription2);
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
                this.removeSubscriptionEntry(mQQueue, (MQQueueSubscription)mQSubscription);
                if (byArray != null) {
                    mQQueueSubscription2.setSubscriberState('i');
                } else {
                    mQQueueSubscription2 = null;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier re-create or close.");
                }
                MQQueueSubscription mQQueueSubscription3 = mQQueueSubscription2;
                mQQueueSubscription2.setSubscriberState('i');
                mQQueueSubscription2.setStatusMgrId(MQC.MQCI_NONE);
                if (Trace.isOn) {
                    Trace.trace(this, "Remove the first old subscriptionEntry");
                }
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
                if (Trace.isOn) {
                    Trace.trace(this, "Add the new subscriptionEntry");
                }
                this.addSubscriptionEntry(mQQueue, mQQueueSubscription3, false);
                if (Trace.isOn) {
                    Trace.trace(this, "Remove the second old subscriptionEntry");
                }
                this.removeSubscriptionEntry(mQQueue, (MQQueueSubscription)mQSubscription);
                mQQueueSubscription2 = mQQueueSubscription3;
            }
        } else if (mQQueueSubscription2 != null && mQQueueSubscription2.getSubscriberState() == 't') {
            block26: {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                try {
                    this.deleteSubscriber(mQQueueSubscription2);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block26;
                    Trace.trace(this, "cleanup ERROR: deleteSubscriber encountered error " + (Object)((Object)jMSException));
                }
            }
            this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
            if (byArray != null) {
                mQQueueSubscription2.setSubscriberState('i');
            } else {
                mQQueueSubscription2 = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getResolvedSubscription");
        }
        return mQQueueSubscription2;
    }

    private MQQueueSubscription createNewDurableSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = null;
        MQQueue mQQueue2 = null;
        Object var5_5 = null;
        int n = 33;
        byte[] byArray = null;
        boolean bl = false;
        MQQueueManager mQQueueManager = null;
        int n2 = 0;
        if (mQQueueSubscription.getMQTopic() != null && mQQueueSubscription.getMQTopic().getFailIfQuiesce() == 1) {
            n |= 0x2000;
        } else if (this.connection.getFailIfQuiesce() == 1) {
            n |= 0x2000;
        }
        MQSession mQSession = mQQueueSubscription.getMQSession();
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createNewDurablesubscription");
            }
            try {
                mQQueueManager = mQSession.qm;
                string = mQQueueSubscription.getQueueName();
                if (!mQQueueSubscription.isSharedQueue()) {
                    int n3 = 2;
                    n2 = 3;
                    mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n, null, string, null);
                    mQQueueSubscription.setQueueName(mQQueue2.name);
                    string = mQQueue2.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using multiple-queue approach.");
                        Trace.trace(this, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                        Trace.trace(this, "Prefix: SYSTEM.JMS.D.*");
                        Trace.trace(this, "QName:  " + string);
                    }
                } else {
                    int n4 = 4;
                    n2 = 5;
                    mQQueue2 = mQQueueManager.accessQueue(string, n);
                    string = mQQueue2.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using shared-queue approach.");
                        Trace.trace(this, "Prefix: SYSTEM.JMS.D.");
                        Trace.trace(this, "QName:  " + string);
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", string);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            try {
                mQQueueSubscription.setSubscriberQueue(mQQueue2);
                mQQueueSubscription.setSubscriberState('t');
                byArray = this.addSubscriptionEntry(mQQueue, mQQueueSubscription, true);
                mQQueueSubscription.setCorrelationId(byArray);
            }
            catch (JMSException jMSException) {
                block40: {
                    try {
                        mQQueue2.close();
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block40;
                        Trace.exception(this, "createNewDurableSubscription - error closing subscriber queue:", (Throwable)mQException);
                    }
                }
                throw jMSException;
            }
            try {
                this.sendBrokerCommand(mQQueueSubscription, 1, true);
                bl = true;
            }
            catch (NoBrokerResponseException noBrokerResponseException) {
                block41: {
                    if (Trace.isOn) {
                        Trace.trace(this, "subscribe command failed, sending an unsubscribe to cancel it");
                    }
                    try {
                        this.sendBrokerCommand(mQQueueSubscription, 2, true);
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block41;
                        Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception == null) break block41;
                        Trace.trace(this, "linked exception = " + exception);
                    }
                }
                throw noBrokerResponseException;
            }
            catch (BrokerCommandFailedException brokerCommandFailedException) {
                throw brokerCommandFailedException;
            }
            mQQueueSubscription.setSubscriberState('u');
            this.addSubscriptionEntry(mQQueue, mQQueueSubscription, false);
            this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
        }
        catch (JMSException jMSException) {
            boolean bl2;
            block43: {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception = " + exception);
                    }
                }
                bl2 = false;
                if (bl) {
                    if (Trace.isOn) {
                        Trace.trace(this, "cleanup sending a cancel command");
                    }
                    try {
                        this.sendBrokerCommand(mQQueueSubscription, 2, true);
                    }
                    catch (JMSException jMSException2) {
                        bl2 = true;
                        if (!Trace.isOn) break block43;
                        Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException2));
                        Exception exception = jMSException2.getLinkedException();
                        if (exception == null) break block43;
                        Trace.trace(this, "linked exception = " + exception);
                    }
                }
            }
            if (mQQueue2 != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "closing subscription queue");
                }
                if (!mQQueueSubscription.isSharedQueue()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "not a shared queue so will be deleted");
                    }
                    mQQueue2.closeOptions = 2;
                }
                try {
                    mQQueue2.close();
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "failed to delete subscription queue because of " + mQException);
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createNewDurableSubscription");
            }
        }
        return mQQueueSubscription;
    }

    private MQQueueSubscription createExistingDurableSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createExistingDurableSubscription");
        }
        MQQueue mQQueue2 = null;
        MQQueueSubscription mQQueueSubscription2 = null;
        try {
            mQQueue2 = this.checkInactive(mQQueueSubscription);
            mQQueueSubscription.setSubscriberQueue(mQQueue2);
            mQQueueSubscription2 = mQQueueSubscription;
            mQQueueSubscription2.setSubscriberState('u');
            mQQueueSubscription2.setStatusMgrId(this.statusMgrId);
            this.addSubscriptionEntry(mQQueue, mQQueueSubscription2, false);
            this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "createExistingDurableSubscription", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createExistingDurableSubscription");
            }
        }
        return mQQueueSubscription2;
    }

    private MQQueueSubscription createUpdatedDurableSubscriber(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        MQQueueSubscription mQQueueSubscription2 = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createUpdatedDurableSubscription");
            }
            MQQueueSubscription mQQueueSubscription3 = null;
            Object var5_6 = null;
            mQQueueSubscription3 = mQQueueSubscription;
            this.unsubscribe(mQQueue, mQQueueSubscription.getMQSession(), mQQueueSubscription.getSubName());
            mQQueueSubscription3.setStatusMgrId(this.statusMgrId);
            mQQueueSubscription2 = this.createNewDurableSubscription(mQQueue, mQQueueSubscription3);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createUpdatedDurableSubscription");
            }
        }
        return mQQueueSubscription2;
    }

    private MQQueue getAdminQueueAccess(MQSession mQSession, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getAdminQueueAccess");
        }
        MQQueueManager mQQueueManager = mQSession.qm;
        MQQueue mQQueue = null;
        int n2 = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Try to open the adminQueue");
                }
                int n3 = 60;
                if (n == 1) {
                    n3 |= 0x2000;
                }
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", n3);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "I'm sorry Dave. I can't do that");
                }
                switch (mQException.reasonCode) {
                    case 2042: {
                        if (++n2 < 20) {
                            if (Trace.isOn) {
                                Trace.trace(this, "admin queue locked, tried " + n2 + "times");
                            }
                            Trace.trace(this, "suppressing exception and retrying after wait");
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Daisy, Daisy....");
                                }
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Tried 20 attempts. I'm bored now so I'll throw an exception");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.trace(this, "Obtaining the admin queue lock required " + n2 + " retries");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAdminQueueAccess");
        }
        return mQQueue;
    }

    private byte[] addSubscriptionEntry(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addSubscriptionEntry");
            Trace.trace(this, "add was passed:" + mQQueueSubscription);
        }
        byte[] byArray = null;
        if (bl && this.contains(mQQueue, mQQueueSubscription.getMQSession(), mQQueueSubscription.getSubName())) {
            if (Trace.isOn) {
                Trace.trace(this, "In addSubscriptionEntry() - entry already exists!");
                Trace.exit(this, "addSubscriptionEntry");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            throw jMSException;
        }
        MQMessage mQMessage = mQQueueSubscription.toMessage();
        if (Trace.isOn) {
            Trace.trace(this, "MQPUT with messageId '" + Utils.bytesToHex(mQMessage.messageId) + "'");
        }
        try {
            mQQueue.put(mQMessage, new MQPutMessageOptions());
            byArray = mQMessage.messageId;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(this, "In addSubscriptionEntry() - unable to MQPUT new entry");
                Trace.exit(this, "addSubscriptionEntry");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)mQException);
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "addSubscriptionEntry");
        }
        return byArray;
    }

    private void removeSubscriptionEntry(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeSubscriptionEntry");
        }
        MQQueueSubscription mQQueueSubscription2 = null;
        Object var4_4 = null;
        byte[] byArray = mQQueueSubscription.getCorrelationId();
        String string = mQQueueSubscription.getSubName();
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        if (byArray == null) {
            mQGetMessageOptions.options = 16;
        }
        boolean bl = true;
        if (this.connection.getFailIfQuiesce() == 1) {
            mQGetMessageOptions.options |= 0x2000;
        }
        while (bl) {
            Object object;
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                    mQGetMessageOptions.matchOptions |= 1;
                }
                mQQueue.get(mQMessage, mQGetMessageOptions);
                mQQueueSubscription2 = new MQQueueSubscription(this, mQQueueSubscription.getMQSession(), mQMessage);
                if (byArray != null) {
                    bl = false;
                    continue;
                }
                if (mQQueueSubscription2.isValid() && mQQueueSubscription2.getSubName().equals(string)) {
                    mQGetMessageOptions.options = 256;
                    object = new MQMessage();
                    mQQueue.get((MQMessage)object, mQGetMessageOptions);
                    bl = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
                if (this.connection.getFailIfQuiesce() != 1) continue;
                mQGetMessageOptions.options |= 0x2000;
            }
            catch (MQException mQException) {
                object = ConfigEnvironment.newException("MQJMS3013");
                object.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "In removeSubscriptionEntry() - cannot remove msg!");
                }
                throw object;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeSubscriptionEntry");
        }
    }

    private MQQueue checkInactive(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkInactive");
        }
        MQQueueManager mQQueueManager = null;
        MQQueue mQQueue = null;
        boolean bl = false;
        mQQueueManager = mQQueueSubscription.getMQSession().qm;
        if (mQQueueSubscription.getSubscriberState() == 'i') {
            bl = true;
        } else if (mQQueueSubscription.getSubscriberState() != 'u') {
            if (Trace.isOn) {
                Trace.trace(this, "checkInactive: state is neither unknown or inactive!");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3005");
            throw jMSException;
        }
        int n = 1;
        if (mQQueueSubscription.getMQTopic() != null) {
            n = mQQueueSubscription.getMQTopic().getFailIfQuiesce();
        } else if (mQQueueSubscription.getMQSession() != null) {
            n = mQQueueSubscription.getMQSession().getFailIfQuiesce();
        }
        try {
            if (mQQueueSubscription.isSharedQueue() && !bl) {
                int n2 = 10;
                if (n == 1) {
                    n2 |= 0x2000;
                }
                MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n2);
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = mQQueueSubscription.getStatusMgrId();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 16;
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "attempting MQGET for jvm reference msg.");
                    }
                    mQQueue2.get(mQMessage, mQGetMessageOptions);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.trace(this, "shared subscriber assumed active. Throwing ex.");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3023");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                    throw mQException;
                }
                mQQueue2.close();
            }
            if (Trace.isOn) {
                Trace.trace(this, "opening subscription queue");
            }
            mQQueue = this.openSubscriberQueue(mQQueueSubscription.getMQSession(), mQQueueSubscription.getQueueName(), mQQueueSubscription.isSharedQueue(), true, n);
        }
        catch (MQException mQException) {
            JMSException jMSException = mQException.reasonCode == 2042 ? ConfigEnvironment.newException("MQJMS3023") : ConfigEnvironment.newException("MQJMS3005");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exception(this, "StatusMgrConnection", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "checkInactive");
            }
        }
        return mQQueue;
    }

    private MQQueueSubscription getSubscriptionEntry(MQQueue mQQueue, MQSession mQSession, String string, byte[] byArray, byte[] byArray2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getSubscriptionEntry");
        }
        MQQueueSubscription mQQueueSubscription = null;
        MQQueueSubscription mQQueueSubscription2 = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = bl ? 32 : 16;
        if (this.connection.getFailIfQuiesce() == 1) {
            mQGetMessageOptions.options |= 0x2000;
        }
        boolean bl2 = true;
        while (bl2) {
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                }
                if (byArray2 != null) {
                    mQMessage.correlationId = byArray2;
                }
                mQQueue.get(mQMessage, mQGetMessageOptions);
                mQQueueSubscription = new MQQueueSubscription(this, mQSession, mQMessage);
                if (string == null && mQQueueSubscription.isValid()) {
                    mQQueueSubscription2 = mQQueueSubscription;
                    bl2 = false;
                    continue;
                }
                if (string != null && mQQueueSubscription.isValid() && mQQueueSubscription.getFullName().equals(string)) {
                    mQQueueSubscription2 = mQQueueSubscription;
                    bl2 = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                bl2 = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getSubscriptionEntry");
        }
        return mQQueueSubscription2;
    }

    private void deleteSubscriber(MQQueueSubscription mQQueueSubscription) throws JMSException {
        JMSException jMSException = null;
        if (Trace.isOn) {
            Trace.entry(this, "deleteSubscriber");
        }
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        try {
            block14: {
                try {
                    this.sendBrokerCommand(mQQueueSubscription, 2, true);
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    if (!Trace.isOn) break block14;
                    Trace.trace(this, "Failed to deregister due to " + (Object)((Object)jMSException2));
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
            if (jMSException != null) {
                throw jMSException;
            }
        }
        catch (JMSException jMSException3) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing from deleteSubscriber: " + (Object)((Object)jMSException3));
                Exception exception = jMSException3.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "Linked exception: " + exception);
                }
            }
            if (jMSException != null && jMSException3 != jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "NOTE! Throwing pending deregException instead!");
                }
                throw jMSException;
            }
            throw jMSException3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deleteSubscriber");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendBrokerCommand(MQQueueSubscription mQQueueSubscription, int n, boolean bl) throws JMSException {
        Object var5_4 = null;
        Object var6_5 = null;
        MQMsg2 mQMsg2 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = null;
        String string2 = null;
        String string3 = mQQueueSubscription.getTopic();
        MQSession mQSession = mQQueueSubscription.getMQSession();
        BrokerConnectionInfo brokerConnectionInfo = mQSession.getBrk();
        byte[] byArray = mQQueueSubscription.getCorrelationId();
        boolean bl6 = mQQueueSubscription.isDurable();
        int n2 = this.getMQConnection().getBrkOptLevel();
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerCommand");
        }
        if (n == 1 && !bl6 && brokerConnectionInfo.qmName.equals(this.getMQConnection().qmgrName) && !mQSession.persistenceFromMD) {
            bl4 = true;
        }
        if (mQSession.acknowledgeMode == 3 && n == 1) {
            bl5 = true;
        }
        try {
            while (bl3) {
                int n3;
                MQBrokerMessage mQBrokerMessage = null;
                if (this.getMQConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating RFH1 Message");
                    }
                    mQBrokerMessage = new RFH1BrokerMessageImpl();
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating RFH2 Message");
                    }
                    mQBrokerMessage = new RFH2BrokerMessageImpl();
                }
                MQJMSMessage mQJMSMessage = new MQJMSMessage();
                bl3 = false;
                switch (n) {
                    case 1: {
                        mQBrokerMessage.set("MQPSCommand", "RegSub");
                        if (!mQQueueSubscription.isSharedQueue()) break;
                        mQBrokerMessage.setOption("MQPSRegOpts", "CorrelAsId");
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        mQBrokerMessage.set("MQPSCommand", "DeregSub");
                        if (!mQQueueSubscription.isSharedQueue()) break;
                        mQBrokerMessage.setOption("MQPSRegOpts", "CorrelAsId");
                        bl2 = true;
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "unknown value of command: " + n);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", "unknown command value " + n);
                        throw jMSException;
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "getting topic");
                    }
                    mQBrokerMessage.set("MQPSTopic", mQQueueSubscription.getTopic());
                    if (Trace.isOn) {
                        Trace.trace(this, "Current brkOptLevel: " + n2);
                    }
                    if (bl4 && n2 > 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Setting non persistent");
                        }
                        mQBrokerMessage.setOption("MQPSRegOpts", "NonPers");
                    }
                    if (bl5 && n2 > 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Setting DupsOK");
                        }
                        mQBrokerMessage.setOption("MQPSRegOpts", "DupsOK");
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "setting stream name");
                    }
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    if (Trace.isOn) {
                        Trace.trace(this, "setting queue Name");
                    }
                    mQBrokerMessage.set("MQPSQName", mQQueueSubscription.getQueueName());
                    string2 = mQQueueSubscription.getFilter();
                    if (string2 != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting filter to " + string2);
                        }
                        mQBrokerMessage.set("MQPSFilter", string2);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "writing to message");
                    }
                    mQBrokerMessage.writeToMessage(mQJMSMessage);
                    if (Trace.isOn) {
                        Trace.trace(this, "setting jms message as persistent");
                    }
                    mQJMSMessage.setPersistence(1);
                    mQJMSMessage.setFormat(mQBrokerMessage.getHeaderFormat());
                    if (Trace.isOn) {
                        Trace.trace(this, "setting jmsMessage reply to queue");
                    }
                    mQJMSMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    if (bl2) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting jmsMessage correlId - " + Utils.bytesToHex(byArray));
                        }
                        mQJMSMessage.setCorrelationId(byArray);
                    }
                    if (bl) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting jmsMessage report options to wait");
                        }
                        mQJMSMessage.setReport(3);
                    }
                    if (string != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting userId");
                        }
                        mQJMSMessage.setUserId(string);
                    }
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3008");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    SubscriptionHelper.MQPUT1(mQSession.qm, brokerConnectionInfo.qmName, brokerConnectionInfo.controlQ, mQJMSMessage);
                    if (Trace.isOn) {
                        Trace.trace(this, "created msg id = " + Utils.bytesToHex(mQJMSMessage.getMessageId()));
                    }
                }
                catch (JMSException jMSException) {
                    n3 = 0;
                    Exception exception = jMSException.getLinkedException();
                    if (exception instanceof MQException) {
                        MQException mQException = (MQException)exception;
                        if (mQException.completionCode == 1 && mQException.reasonCode == 2104) {
                            n3 = 1;
                        }
                    }
                    if (n3 == 0) {
                        JMSException jMSException2 = ConfigEnvironment.newException("MQJMS3009");
                        jMSException2.setLinkedException((Exception)((Object)jMSException));
                        throw jMSException2;
                    }
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3009");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                if (!bl) continue;
                mQMsg2 = new MQMsg2();
                mQMsg2.setCorrelationId(mQJMSMessage.getMessageId());
                this.getBrokerResponse(mQSession, mQMsg2);
                try {
                    SubscriptionHelper.checkResponse(mQMsg2);
                }
                catch (BrokerCommandFailedException brokerCommandFailedException) {
                    n3 = brokerCommandFailedException.getReason();
                    switch (n3) {
                        case 3083: {
                            if (n2 <= 0) break;
                            if (bl5) {
                                --n2;
                                bl3 = true;
                            } else if (bl4) {
                                --n2;
                                bl3 = true;
                            }
                            if (!bl3) break;
                            this.getMQConnection().setBrkOptLevel(n2);
                            break;
                        }
                        case 3078: {
                            if (string != null) break;
                            string = brokerCommandFailedException.getUserId();
                            bl3 = true;
                            break;
                        }
                    }
                    if (bl3) continue;
                    if (!Trace.isOn) throw brokerCommandFailedException;
                    Trace.trace(this, "Failed to reregister due to " + (Object)((Object)brokerCommandFailedException));
                    throw brokerCommandFailedException;
                    return;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exception(this, "sendBrokerCommand", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerCommand");
            }
        }
    }

    void getBrokerResponse(MQSession mQSession, MQMsg2 mQMsg2) throws NoBrokerResponseException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getBrokerResponse");
            }
            MQQueue mQQueue = mQSession.getResponseQueue();
            MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 1;
            mQGetMessageOptions.matchOptions = 2;
            mQGetMessageOptions.waitInterval = mQSession.getBrokerTimeout();
            if (this.connection.getFailIfQuiesce() == 1) {
                mQGetMessageOptions.options |= 0x2000;
            }
            mQQueue.getMsg2(mQMsg2, mQGetMessageOptions);
        }
        catch (MQException mQException) {
            String string = "MQJMS5053";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
            noBrokerResponseException.setLinkedException(mQException);
            throw noBrokerResponseException;
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("MQJMS1016");
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getBrokerResponse");
            }
        }
    }

    public void unsubscribe(MQQueue mQQueue, MQSession mQSession, String string) throws JMSException {
        try {
            Throwable throwable;
            MQQueueSubscription mQQueueSubscription;
            MQQueueSubscription mQQueueSubscription2;
            if (Trace.isOn) {
                Trace.entry(this, "unsubscribe");
            }
            if ((mQQueueSubscription2 = this.getResolvedSubscription(mQQueue, mQQueueSubscription = new MQQueueSubscription(this, mQSession, true, false, mQSession.qm.name, this.getMQConnection().getClientID(), string, null, null, false, null, null, null), null, false)) == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "No entry found for '" + string + "'");
                }
                String string2 = "MQJMS3018";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Entry found for '" + string + "'");
                Trace.trace(this, mQQueueSubscription2.toString());
            }
            MQQueue mQQueue2 = null;
            try {
                mQQueue2 = this.checkInactive(mQQueueSubscription2);
            }
            catch (JMSException jMSException) {
                throwable = (MQException)jMSException.getLinkedException();
                switch (((MQException)throwable).reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "Warning: durable sub queue '" + mQQueueSubscription2.getQueueName() + " is missing\n");
                        Trace.trace(this, "Carrying on with deregister");
                        break;
                    }
                    default: {
                        throw jMSException;
                    }
                }
            }
            mQQueueSubscription2.setSubscriberQueue(mQQueue2);
            mQQueueSubscription2.setSubscriberState('t');
            this.addSubscriptionEntry(mQQueue, mQQueueSubscription2, false);
            this.deleteSubscriber(mQQueueSubscription2);
            try {
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "unsubscribe problem - failed to remove the admin entry: " + (Object)((Object)jMSException));
                }
                throwable = ConfigEnvironment.newException("MQJMS3013");
                throw throwable;
            }
            this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "unsubscribe throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "unsubscribe");
            }
        }
    }

    MQPSStatusMgr getPubSubStatusMgr() {
        return this.pubsubStatusMgr;
    }

    byte[] getStatusMgrId() {
        return this.statusMgrId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(MQQueue mQQueue, MQSession mQSession, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "contains");
        }
        try {
            boolean bl = this.getSubscriptionEntry(mQQueue, mQSession, string, null, null, false) != null;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "contains");
            }
        }
    }
}

