/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Bill.java,v 1.3 2010/12/20 09:21:21 pmuessig Exp $
 */
package ch.e2e.examples.list;

import java.util.GregorianCalendar;
import java.util.List;

/**
 * The bill for a list of ordered products.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.3 $
 */
@SuppressWarnings({"UnusedDeclaration"})
public class Bill {
	/**
	 * The total amount to pay.
	 */
	private double total;
	/**
	 * The customer ordering these products.
	 */
	private Customer customer;
	/**
	 * The list of ordered products. All elements in this list are of
	 * type <code>ch.e2e.examples.list.Product</code>.
	 */
	private List<Product> products;
	/**
	 * The list with ids and quantity of the ordered products. All elements
	 * in this list are of type <code>ch.e2e.examples.list.ProductOrder</code>.
	 */
	private List<ProductOrder> productOrders;
	/**
	 * The date of the bill.
	 */
	private GregorianCalendar date;

	/**
	 * Returns the customer ordering these products.
	 * @return The customer ordering these products.
	 */
	public Customer getCustomer() {
		return customer;
	}

	/**
	 * Sets the customer ordering these products.
	 * @param customer The customer ordering these products.
	 */
	public void setCustomer(Customer customer) {
		this.customer = customer;
	}

	/**
	 * Returns the date of the bill.
	 * @return the date of the bill.
	 */
	public GregorianCalendar getDate() {
		return date;
	}

	/**
	 * Set the date of the bill.
	 * @param date The date of the bill.
	 */
	public void setDate(GregorianCalendar date) {
		this.date = date;
	}

	/**
	 * Returns the products ordered by the customer.
	 * @return The products ordered by the customer.
	 */
	public List<Product> getProducts() {
		return products;
	}

	/**
	 * Sets the products ordered by the customer.
	 * @param products The products ordered by the customer.
	 */
	public void setProducts(List<Product> products) {
		this.products = products;
	}

	/**
	 * Returns the list of ids and quantity of the ordered products.
	 * @return The list of ids and quantity of the ordered products.
	 */
	public List<ProductOrder> getProductOrders() {
		return productOrders;
	}

	/**
	 * Sets the list of ids and quantity of the ordered products.
	 * @param productOrders The list of ids and quantity of the ordered products.
	 */
	public void setProductOrders(List<ProductOrder> productOrders) {
		this.productOrders = productOrders;
	}

	/**
	 * Returns the total amount to pay.
	 * @return The total amount to pay.
	 */
	public double getTotal() {
		return total;
	}

	/**
	 * Sets the total amount to pay.
	 * @param total The total amount to pay.
	 */
	public void setTotal(double total) {
		this.total = total;
	}
}
